/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParameterizedInterfaceModel;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;

class ParameterizedInterfaceModelImpl
implements ParameterizedInterfaceModel {
    final TypeProxy<InterfaceModel> rawInterface;
    final List<ParameterizedInterfaceModel> parameterizedTypes = new ArrayList<ParameterizedInterfaceModel>();

    ParameterizedInterfaceModelImpl(TypeProxy<InterfaceModel> rawInterface) {
        this.rawInterface = rawInterface;
    }

    synchronized void addParameterizedType(ParameterizedInterfaceModel type2) {
        this.parameterizedTypes.add(type2);
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rawInterface.getName());
        if (!this.parameterizedTypes.isEmpty()) {
            sb.append("<");
            Iterator<ParameterizedInterfaceModel> parameterizedTypeItr = this.parameterizedTypes.iterator();
            while (parameterizedTypeItr.hasNext()) {
                sb.append(parameterizedTypeItr.next().getName());
                if (!parameterizedTypeItr.hasNext()) continue;
                sb.append(",");
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public TypeProxy<InterfaceModel> getRawInterfaceProxy() {
        return this.rawInterface;
    }

    @Override
    public InterfaceModel getRawInterface() {
        return this.rawInterface.get();
    }

    @Override
    public Collection<ParameterizedInterfaceModel> getParametizedTypes() {
        return Collections.unmodifiableCollection(this.parameterizedTypes);
    }
}

