/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;
import org.glassfish.hk2.classmodel.reflect.impl.TypesCtr;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;
import org.glassfish.hk2.classmodel.reflect.util.DirectoryArchive;
import org.glassfish.hk2.classmodel.reflect.util.JarArchive;
import org.glassfish.hk2.classmodel.reflect.util.ResourceLocator;
import org.glassfish.hk2.external.org.objectweb.asm.ClassReader;

public class Parser
implements Closeable {
    public static final String DEFAULT_WAIT_SYSPROP = "hk2.parser.timeout";
    private final ParsingContext context;
    private final Map<String, Types> processedURI = Collections.synchronizedMap(new HashMap());
    private final Stack<Future<Result>> futures = new Stack();
    private final ExecutorService executorService;
    private final boolean ownES;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final int DEFAULT_TIMEOUT = Integer.getInteger("hk2.parser.timeout", 100);

    public Parser(ParsingContext context) {
        this.context = context;
        this.executorService = context.executorService == null ? this.createExecutorService() : context.executorService;
        this.ownES = context.executorService == null;
    }

    public Exception[] awaitTermination() throws InterruptedException {
        return this.awaitTermination(this.DEFAULT_TIMEOUT, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Exception[] awaitTermination(int timeOut, TimeUnit unit) throws InterruptedException {
        Exception[] exceptionArray;
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        final Logger logger2 = this.context.logger;
        while (this.futures.size() > 0) {
            Future<Result> f;
            if (this.context.logger.isLoggable(Level.FINE)) {
                this.context.logger.log(Level.FINE, "Await iterating at " + System.currentTimeMillis() + " waiting for " + this.futures.size());
            }
            exceptionArray = this.futures;
            // MONITORENTER : this.futures
            try {
                f = this.futures.pop();
            }
            catch (EmptyStackException e) {
                f = null;
            }
            if (f == null) continue;
            try {
                Result result = f.get(timeOut, unit);
                if (this.context.logger.isLoggable(Level.FINE)) {
                    this.context.logger.log(Level.FINE, "future finished at " + System.currentTimeMillis() + " for " + result.name);
                }
                this.context.logger.log(Level.FINER, "result {0}", result);
                if (result != null && result.fault != null) {
                    this.context.logger.log(Level.WARNING, "result fault {0}", result);
                }
                if (result == null || result.fault == null) continue;
                exceptions.add(result.fault);
            }
            catch (TimeoutException e) {
                exceptions.add(e);
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
        }
        this.lock.writeLock().lock();
        try {
            final ResourceLocator locator = this.context.getLocator();
            if (locator != null) {
                this.context.logger.info("visiting unvisited references");
                this.context.types.onNotVisitedEntries(new TypesCtr.ProxyTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void on(TypeProxy<?> proxy) {
                        String name = proxy.getName();
                        String resourceName = name.replaceAll("\\.", "/") + ".class";
                        InputStream is = null;
                        try {
                            is = locator.openResourceStream(resourceName);
                            if (null == is) {
                                return;
                            }
                            logger2.log(Level.FINE, "Going to visit {0}", resourceName);
                            ClassReader cr = new ClassReader(is);
                            try {
                                URL url = locator.getResource(resourceName);
                                File file = Parser.getFilePath(url.getPath(), resourceName);
                                URI definingURI = Parser.getDefiningURI(file);
                                if (logger2.isLoggable(Level.FINE)) {
                                    logger2.fine("file=" + file + "; definingURI=" + definingURI);
                                }
                                cr.accept(Parser.this.context.getClassVisitor(definingURI, resourceName), 2);
                            }
                            catch (Throwable e) {
                                logger2.log(Level.SEVERE, "Exception while visiting {0}", name);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    logger2.log(Level.SEVERE, "Exception while closing " + resourceName + " stream", e);
                                }
                            }
                        }
                    }
                });
            } else {
                this.context.types.clearNonVisitedEntries();
            }
            this.close();
            exceptionArray = exceptions.toArray(new Exception[exceptions.size()]);
            return exceptionArray;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static URI getDefiningURI(File file) {
        try {
            return file.getCanonicalFile().toURI();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File getFilePath(String path, String resourceName) {
        if ((path = path.substring(0, path.length() - resourceName.length())).endsWith("!/")) {
            path = path.substring(0, path.length() - 2);
        }
        if (path.startsWith("file:/")) {
            path = path.substring(6, path.length());
        }
        File file = new File(path);
        return file;
    }

    @Override
    public void close() {
        if (this.executorService != null && this.ownES) {
            this.executorService.shutdown();
        }
    }

    public void parse(File source, final Runnable doneHook) throws IOException {
        final ArchiveAdapter adapter = this.createArchiveAdapter(source, doneHook);
        Runnable cleanUpAndNotify = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        adapter.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    if (doneHook != null) {
                        doneHook.run();
                    }
                }
            }
        };
        this.parse(adapter, cleanUpAndNotify);
    }

    private ArchiveAdapter createArchiveAdapter(File source, Runnable doneHook) throws IOException {
        try {
            AbstractAdapter aa = source.isFile() ? new JarArchive(this, source.toURI()) : new DirectoryArchive(this, source);
            return aa;
        }
        catch (IOException e) {
            if (doneHook != null) {
                doneHook.run();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Result> parse(final ArchiveAdapter source, final Runnable doneHook) throws IOException {
        this.lock.readLock().lock();
        try {
            ExecutorService es = this.executorService;
            boolean immediateShutdown = false;
            if (es.isShutdown()) {
                this.context.logger.info("Executor service is shutdown, since awaitTermination was called, provide an executor service instance from the context to avoid automatic shutdown");
                es = this.createExecutorService();
                immediateShutdown = true;
            }
            final Logger logger2 = this.context.logger;
            Types types = this.getResult(source.getURI());
            if (types != null) {
                if (logger2.isLoggable(Level.FINE)) {
                    logger2.fine("Skipping reparsing..." + source.getURI());
                }
                doneHook.run();
                Future<Result> future = null;
                return future;
            }
            if (logger2.isLoggable(Level.FINE)) {
                logger2.log(Level.FINE, "at " + System.currentTimeMillis() + "in " + this + " submitting file " + source.getURI().getPath());
                logger2.log(Level.FINE, "submitting file " + source.getURI().getPath());
            }
            Future<Result> future = es.submit(new Callable<Result>(){

                @Override
                public Result call() throws Exception {
                    try {
                        if (logger2.isLoggable(Level.FINE)) {
                            logger2.log(Level.FINE, "elected file " + source.getURI().getPath());
                        }
                        if (logger2.isLoggable(Level.FINE)) {
                            ((Parser)Parser.this).context.logger.log(Level.FINE, "started working at " + System.currentTimeMillis() + "in " + this + " on " + source.getURI().getPath());
                        }
                        Parser.this.doJob(source, doneHook);
                        return new Result(source.getURI().getPath(), null);
                    }
                    catch (Exception e) {
                        logger2.log(Level.SEVERE, "Exception while parsing file " + source.getURI(), e);
                        return new Result(source.getURI().getPath(), e);
                    }
                }
            });
            Object object = this.futures;
            synchronized (object) {
                this.futures.add(future);
            }
            if (immediateShutdown) {
                es.shutdown();
            }
            object = future;
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private synchronized Types getResult(URI uri) {
        return this.processedURI.get(uri.getSchemeSpecificPart());
    }

    private synchronized void saveResult(URI uri, Types types) {
        this.processedURI.put(uri.getPath(), types);
    }

    private void doJob(ArchiveAdapter adapter, Runnable doneHook) throws Exception {
        final Logger logger2 = this.context.logger;
        long startTime = System.currentTimeMillis();
        if (logger2.isLoggable(Level.FINE)) {
            logger2.fine("Parsing " + adapter.getURI() + " on thread " + Thread.currentThread().getName());
        }
        if (this.context.archiveSelector == null || this.context.archiveSelector.selects(adapter)) {
            final URI uri = adapter.getURI();
            if (logger2.isLoggable(Level.FINE)) {
                logger2.log(Level.FINE, "Parsing file {0}", uri.getPath());
            }
            adapter.onSelectedEntries(new ArchiveAdapter.Selector(){

                @Override
                public boolean isSelected(ArchiveAdapter.Entry entry) {
                    return entry.name.endsWith(".class");
                }
            }, new ArchiveAdapter.EntryTask(){

                @Override
                public void on(ArchiveAdapter.Entry entry, InputStream is) throws IOException {
                    if (logger2.isLoggable(Level.FINER)) {
                        logger2.log(Level.FINER, "Parsing class " + entry.name);
                    }
                    try {
                        ClassReader cr = new ClassReader(is);
                        cr.accept(Parser.this.context.getClassVisitor(uri, entry.name, true), 2);
                    }
                    catch (Throwable e) {
                        logger2.log(Level.SEVERE, "Exception while visiting " + entry.name + " of size " + entry.size, e);
                    }
                }
            }, logger2);
            this.saveResult(uri, this.context.getTypes());
        }
        if (logger2.isLoggable(Level.FINE)) {
            logger2.log(Level.FINE, "Finished parsing " + adapter.getURI().getPath() + " at " + System.currentTimeMillis() + " in " + (System.currentTimeMillis() - startTime) + " ms");
        }
        if (logger2.isLoggable(Level.FINE)) {
            logger2.log(Level.FINE, "before running doneHook" + adapter.getURI().getPath());
        }
        if (doneHook != null) {
            doneHook.run();
        }
        if (logger2.isLoggable(Level.FINE)) {
            logger2.log(Level.FINE, "after running doneHook " + adapter.getURI().getPath());
        }
    }

    public ParsingContext getContext() {
        return this.context;
    }

    private ExecutorService createExecutorService() {
        int nbOfProcessors = 1;
        return Executors.newFixedThreadPool(nbOfProcessors, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Hk2-jar-scanner-" + t.getId());
                t.setDaemon(true);
                return t;
            }
        });
    }

    public static class Result {
        public final String name;
        public final Exception fault;

        private Result(String name, Exception fault) {
            this.name = name;
            this.fault = fault;
        }

        public String toString() {
            return super.toString() + " Result for " + this.name;
        }
    }
}

