/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.grizzly.http2.hpack.EncodingStrategy;
import org.glassfish.grizzly.http2.hpack.HeaderFieldTable;
import org.glassfish.grizzly.http2.hpack.Indexed;
import org.glassfish.grizzly.http2.hpack.Literal;

public class DefaultEncoding
implements EncodingStrategy {
    private final boolean useHuffman;

    public DefaultEncoding(boolean useHuffmanOnLiterals) {
        this.useHuffman = useHuffmanOnLiterals;
    }

    @Override
    public void encode(String name, String value, OutputStream destination, HeaderFieldTable.EncTable table) throws IOException {
        int index = table.indexOf(name, value);
        if (index != -1) {
            Indexed.write(index, destination);
        } else {
            index = table.indexOf(name);
            if (index != -1) {
                Literal.write(index, value, destination, this.useHuffman);
            } else {
                Literal.write(name, value, destination, this.useHuffman);
            }
        }
    }
}

