/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.util.Objects;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.compression.HeaderListener;
import org.glassfish.grizzly.http2.hpack.BinaryRepresentation;
import org.glassfish.grizzly.http2.hpack.HeaderFieldTable;
import org.glassfish.grizzly.http2.hpack.Indexed;
import org.glassfish.grizzly.http2.hpack.Literal;
import org.glassfish.grizzly.http2.hpack.LiteralNeverIndexed;
import org.glassfish.grizzly.http2.hpack.LiteralWithIndexing;
import org.glassfish.grizzly.http2.hpack.SizeUpdate;

public class Decoder {
    private static final BinaryRepresentation INDEXED = Indexed.getInstance();
    private static final BinaryRepresentation LITERAL = Literal.getInstance();
    private static final BinaryRepresentation LITERAL_NEVER_INDEXED = LiteralNeverIndexed.getInstance();
    private static final BinaryRepresentation LITERAL_WITH_INDEXING = LiteralWithIndexing.getInstance();
    private static final BinaryRepresentation SIZE_UPDATE = SizeUpdate.getInstance();
    private final HeaderFieldTable.DecTable table;

    public Decoder(int settingsHeaderTableSize) {
        this.table = HeaderFieldTable.createDecodingTable(settingsHeaderTableSize, 16);
    }

    public void decode(Buffer source, HeaderListener handler) {
        Objects.requireNonNull(source, "source == null");
        Objects.requireNonNull(handler, "handler == null");
        while (source.hasRemaining()) {
            byte sig = source.get(source.position());
            this.getRepresentations(sig).process(source, this.table, handler);
        }
    }

    private BinaryRepresentation getRepresentations(byte sig) {
        if (Indexed.matches(sig)) {
            return INDEXED;
        }
        if (Literal.matches(sig)) {
            return LITERAL;
        }
        if (LiteralNeverIndexed.matches(sig)) {
            return LITERAL_NEVER_INDEXED;
        }
        if (LiteralWithIndexing.matches(sig)) {
            return LITERAL_WITH_INDEXING;
        }
        if (SizeUpdate.matches(sig)) {
            return SIZE_UPDATE;
        }
        throw new IllegalStateException("Unknown representation: " + sig);
    }
}

