/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.hpack.HuffmanCoding;
import org.glassfish.grizzly.http2.hpack.ObjectHolder;

public final class BinaryPrimitives {
    private static final int MAX_INTEGER = Integer.MAX_VALUE;
    private static final HuffmanCoding huffmanCoding = HuffmanCoding.getInstance();

    private BinaryPrimitives() {
    }

    public static int readInteger(Buffer source, int N) {
        return BinaryPrimitives.readInteger(source, N, Integer.MAX_VALUE);
    }

    private static int readInteger(Buffer source, int n, int maxInteger) {
        byte i;
        long newVal;
        BinaryPrimitives.checkPrefix(n);
        int nBitMask = 255 >> 8 - n;
        int nBits = source.get() & nBitMask;
        if (nBits != nBitMask) {
            return nBits;
        }
        int r = nBitMask;
        int b = 0;
        while ((newVal = ((long)((i = source.get()) & 0x7F) << b) + (long)r) <= (long)maxInteger) {
            r = (int)newVal;
            if ((i & 0x80) == 0) {
                return r;
            }
            if ((b += 7) < 32) continue;
        }
        throw new IllegalArgumentException("Integer overflow");
    }

    static void writeInteger(OutputStream destination, int value, int n) throws IOException {
        BinaryPrimitives.writeInteger(destination, value, n, 0);
    }

    static void writeInteger(OutputStream destination, int value, int n, int payload) throws IOException {
        Objects.requireNonNull(destination);
        BinaryPrimitives.checkPrefix(n);
        if (value < 0) {
            throw new IllegalArgumentException("value < 0: value=" + value);
        }
        assert (payload == (payload & 0xFF & -1 << n));
        int i = value;
        int nBitMask = 255 >> 8 - n;
        if (i < nBitMask) {
            destination.write((byte)(payload | i));
            return;
        }
        destination.write((byte)(payload | nBitMask));
        i -= nBitMask;
        while (i >= 128) {
            destination.write(i & 0x7F | 0x80);
            i >>= 7;
        }
        destination.write((byte)i);
    }

    public static void readString(Buffer source, ObjectHolder<String> result) {
        int m = source.position();
        boolean huffman = (source.get() & 0x80) != 0;
        source.position(m);
        int len = BinaryPrimitives.readInteger(source, 7);
        if (source.limit() < source.position() + len) {
            throw new IllegalArgumentException(String.format("String representation supposed to consist of more octets than is available: expected string length=%s", len));
        }
        int l = source.limit();
        source.limit(source.position() + len);
        if (!huffman) {
            result.setObj(source.toStringContent(StandardCharsets.ISO_8859_1));
        } else {
            result.setObj(huffmanCoding.from(source));
        }
        source.limit(l);
    }

    public static void writeString(OutputStream destination, String value, boolean useHuffmanCoding) throws IOException {
        if (useHuffmanCoding) {
            BinaryPrimitives.writeHuffmanString(destination, value);
        } else {
            BinaryPrimitives.writeString(destination, value);
        }
    }

    public static void writeString(OutputStream destination, byte[] value, boolean useHuffmanCoding) throws IOException {
        BinaryPrimitives.writeString(destination, value, 0, value.length, useHuffmanCoding);
    }

    public static void writeString(OutputStream destination, byte[] value, int off, int len, boolean useHuffmanCoding) throws IOException {
        if (useHuffmanCoding) {
            BinaryPrimitives.writeHuffmanString(destination, value, off, len);
        } else {
            BinaryPrimitives.writeString(destination, value, off, len);
        }
    }

    private static void writeString(OutputStream destination, byte[] value, int off, int len) throws IOException {
        Objects.requireNonNull(destination, "destination == null");
        Objects.requireNonNull(value, "value == null");
        BinaryPrimitives.writeInteger(destination, len, 7, 0);
        destination.write(value, off, len);
    }

    private static void writeString(OutputStream destination, String value) throws IOException {
        Objects.requireNonNull(destination, "destination == null");
        Objects.requireNonNull(value, "value == null");
        int len = value.length();
        BinaryPrimitives.writeInteger(destination, len, 7, 0);
        for (int i = 0; i < len; ++i) {
            destination.write(value.charAt(i));
        }
    }

    private static void writeHuffmanString(OutputStream destination, byte[] value, int off, int len) throws IOException {
        Objects.requireNonNull(destination, "destination == null");
        Objects.requireNonNull(value, "value == null");
        BinaryPrimitives.writeInteger(destination, huffmanCoding.lengthOf(value, off, len), 7, 128);
        huffmanCoding.to(destination, value, off, len);
    }

    private static void writeHuffmanString(OutputStream destination, String value) throws IOException {
        Objects.requireNonNull(destination, "destination == null");
        Objects.requireNonNull(value, "value == null");
        BinaryPrimitives.writeInteger(destination, huffmanCoding.lengthOf(value), 7, 128);
        huffmanCoding.to(destination, value);
    }

    private static void checkPrefix(int N) {
        if (N < 1 || N > 8) {
            throw new IllegalArgumentException("N is always between 1 and 8 bits: N= " + N);
        }
    }
}

