/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http2.BundleQueue;
import org.glassfish.grizzly.http2.Constants;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.Source;
import org.glassfish.grizzly.http2.StreamOutputSink;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.utils.ChunkedCompletionHandler;
import org.glassfish.grizzly.memory.Buffers;

class DefaultOutputSink
implements StreamOutputSink {
    private static final Logger LOGGER = Grizzly.logger(StreamOutputSink.class);
    private static final Level LOGGER_LEVEL = Level.INFO;
    private static final int MAX_OUTPUT_QUEUE_SIZE = 65536;
    private static final int ZERO_QUEUE_RECORD_SIZE = 1;
    private static final OutputQueueRecord TERMINATING_QUEUE_RECORD = new OutputQueueRecord(null, null, true, true);
    final TaskQueue<OutputQueueRecord> outputQueue = TaskQueue.createTaskQueue(new TaskQueue.MutableMaxQueueSize(){

        @Override
        public int getMaxQueueSize() {
            return 65536;
        }
    });
    private final AtomicInteger availStreamWindowSize;
    private volatile boolean isLastFrameQueued;
    private Http2Stream.Termination terminationFlag;
    private final Http2Connection http2Connection;
    private final Http2Stream stream;
    private final AtomicInteger unflushedWritesCounter = new AtomicInteger();
    private final Object flushHandlersSync = new Object();
    private BundleQueue<CompletionHandler<Http2Stream>> flushHandlersQueue;

    DefaultOutputSink(Http2Stream stream) {
        this.stream = stream;
        this.http2Connection = stream.getHttp2Connection();
        this.availStreamWindowSize = new AtomicInteger(stream.getPeerWindowSize());
    }

    @Override
    public boolean canWrite() {
        return this.outputQueue.size() < 65536;
    }

    @Override
    public void notifyWritePossible(WriteHandler writeHandler) {
        this.outputQueue.notifyWritePossible(writeHandler, 65536);
    }

    private void assertReady() throws IOException {
        if (this.isTerminated()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Terminated!!! id={0} description={1}", new Object[]{this.stream.getId(), this.terminationFlag.getDescription()});
            }
            throw new IOException(this.terminationFlag.getDescription());
        }
        if (this.isLastFrameQueued) {
            throw new IOException("Write beyond end of stream");
        }
    }

    @Override
    public void onPeerWindowUpdate(int delta) throws Http2StreamException {
        this.availStreamWindowSize.addAndGet(delta);
        while (this.isWantToWrite() && !this.outputQueue.isEmpty()) {
            OutputQueueRecord outputQueueRecord = this.outputQueue.poll();
            if (outputQueueRecord == null) {
                return;
            }
            if (outputQueueRecord == TERMINATING_QUEUE_RECORD) {
                this.releaseWriteQueueSpace(0, true, true);
                this.writeEmptyFin();
                return;
            }
            FlushCompletionHandler completionHandler = outputQueueRecord.chunkedCompletionHandler;
            boolean isLast = outputQueueRecord.isLast;
            boolean isZeroSizeData = outputQueueRecord.isZeroSizeData;
            Source resource = outputQueueRecord.resource;
            int bytesToSend = this.checkOutputWindow(resource.remaining());
            Buffer dataChunkToSend = resource.read(bytesToSend);
            boolean hasRemaining = resource.hasRemaining();
            if (hasRemaining) {
                outputQueueRecord.reset(resource, completionHandler, isLast);
                outputQueueRecord.incChunksCounter();
                isLast = false;
            } else {
                outputQueueRecord.release();
                outputQueueRecord = null;
            }
            if (dataChunkToSend != null && (dataChunkToSend.hasRemaining() || isLast)) {
                int dataChunkToSendSize = dataChunkToSend.remaining();
                this.flushToConnectionOutputSink(null, dataChunkToSend, completionHandler, null, isLast);
                this.availStreamWindowSize.addAndGet(-dataChunkToSendSize);
                this.releaseWriteQueueSpace(dataChunkToSendSize, isZeroSizeData, outputQueueRecord == null);
                this.outputQueue.doNotify();
            } else if (isZeroSizeData && outputQueueRecord == null) {
                this.releaseWriteQueueSpace(0, true, true);
                this.outputQueue.doNotify();
            }
            if (outputQueueRecord == null) continue;
            this.outputQueue.setCurrentElement(outputQueueRecord);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <E> void writeDownStream(HttpPacket httpPacket, FilterChainContext ctx, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner) throws IOException {
        assert (ctx != null);
        this.assertReady();
        HttpHeader httpHeader = this.stream.getOutputHttpHeader();
        HttpContent httpContent = HttpContent.isContent(httpPacket) ? (HttpContent)httpPacket : null;
        List<Http2Frame> headerFrames = null;
        OutputQueueRecord outputQueueRecord = null;
        boolean isDeflaterLocked = false;
        try {
            int remaining;
            int fitWindowLen;
            int spaceToReserve;
            if (!httpHeader.isCommitted()) {
                boolean isNoPayload = !httpHeader.isExpectContent() || httpContent != null && httpContent.isLast() && !httpContent.getContent().hasRemaining();
                isDeflaterLocked = true;
                this.http2Connection.getDeflaterLock().lock();
                headerFrames = this.http2Connection.encodeHttpHeaderAsHeaderFrames(ctx, httpHeader, this.stream.getId(), isNoPayload, null);
                this.stream.onSndHeaders(isNoPayload);
                httpHeader.setCommitted(true);
                if (isNoPayload || httpContent == null) {
                    this.unflushedWritesCounter.incrementAndGet();
                    this.flushToConnectionOutputSink(headerFrames, null, new FlushCompletionHandler(completionHandler), messageCloner, isNoPayload);
                    return;
                }
            }
            if (httpContent == null) {
                return;
            }
            this.http2Connection.handlerFilter.onHttpContentEncoded(httpContent, ctx);
            Buffer dataToSend = null;
            boolean isLast = httpContent.isLast();
            Buffer data = httpContent.getContent();
            int dataSize = data.remaining();
            if (isLast && dataSize == 0) {
                this.close();
                return;
            }
            this.unflushedWritesCounter.incrementAndGet();
            FlushCompletionHandler flushCompletionHandler = new FlushCompletionHandler(completionHandler);
            boolean isDataCloned = false;
            boolean isZeroSizeData = dataSize == 0;
            int n = spaceToReserve = isZeroSizeData ? 1 : dataSize;
            if (this.reserveWriteQueueSpace(spaceToReserve) > spaceToReserve) {
                assert (headerFrames == null);
                if (messageCloner != null) {
                    data = messageCloner.clone(this.http2Connection.getConnection(), data);
                    isDataCloned = true;
                }
                outputQueueRecord = new OutputQueueRecord(Source.factory(this.stream).createBufferSource(data), flushCompletionHandler, isLast, isZeroSizeData);
                this.outputQueue.offer(outputQueueRecord);
                if (this.outputQueue.size() != spaceToReserve || !this.outputQueue.remove(outputQueueRecord)) {
                    return;
                }
                outputQueueRecord = null;
            }
            if ((fitWindowLen = this.checkOutputWindow(remaining = data.remaining())) < remaining) {
                if (!isDataCloned && messageCloner != null) {
                    data = messageCloner.clone(this.http2Connection.getConnection(), data);
                    isDataCloned = true;
                }
                Buffer dataChunkToStore = this.splitOutputBufferIfNeeded(data, fitWindowLen);
                outputQueueRecord = new OutputQueueRecord(Source.factory(this.stream).createBufferSource(dataChunkToStore), flushCompletionHandler, isLast, isZeroSizeData);
                isLast = false;
            }
            if (data != null && (data.hasRemaining() || isLast)) {
                int dataChunkToSendSize = data.remaining();
                this.availStreamWindowSize.addAndGet(-dataChunkToSendSize);
                this.releaseWriteQueueSpace(dataChunkToSendSize, isZeroSizeData, outputQueueRecord == null);
                dataToSend = data;
            }
            if (headerFrames != null || dataToSend != null) {
                if (outputQueueRecord != null) {
                    outputQueueRecord.incChunksCounter();
                }
                this.flushToConnectionOutputSink(headerFrames, dataToSend, flushCompletionHandler, isDataCloned ? null : messageCloner, isLast);
            }
        }
        finally {
            if (isDeflaterLocked) {
                this.http2Connection.getDeflaterLock().unlock();
            }
        }
        if (outputQueueRecord == null) {
            return;
        }
        this.addOutputQueueRecord(outputQueueRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writeDownStream(Source source, FilterChainContext ctx) throws IOException {
        assert (ctx != null);
        this.assertReady();
        this.isLastFrameQueued = true;
        HttpHeader httpHeader = this.stream.getOutputHttpHeader();
        if (httpHeader.isCommitted()) {
            throw new IllegalStateException("Headers have been already commited");
        }
        OutputQueueRecord outputQueueRecord = null;
        ReentrantLock deflaterLock = this.http2Connection.getDeflaterLock();
        deflaterLock.lock();
        try {
            boolean isNoPayload = !httpHeader.isExpectContent() || source == null || !source.hasRemaining();
            List<Http2Frame> headerFrames = this.http2Connection.encodeHttpHeaderAsHeaderFrames(ctx, httpHeader, this.stream.getId(), isNoPayload, null);
            this.stream.onSndHeaders(isNoPayload);
            httpHeader.setCommitted(true);
            if (isNoPayload) {
                this.unflushedWritesCounter.incrementAndGet();
                this.flushToConnectionOutputSink(headerFrames, null, new FlushCompletionHandler(null), null, isNoPayload);
                return;
            }
            long dataSize = source.remaining();
            if (dataSize == 0L) {
                this.close();
                return;
            }
            this.reserveWriteQueueSpace(1);
            boolean isLast = true;
            int fitWindowLen = this.checkOutputWindow(dataSize);
            if ((long)fitWindowLen < dataSize) {
                outputQueueRecord = new OutputQueueRecord(source, null, true, true);
                isLast = false;
            }
            Buffer bufferToSend = source.read(fitWindowLen);
            int dataChunkToSendSize = bufferToSend.remaining();
            this.availStreamWindowSize.addAndGet(-dataChunkToSendSize);
            this.releaseWriteQueueSpace(dataChunkToSendSize, true, outputQueueRecord == null);
            this.unflushedWritesCounter.incrementAndGet();
            this.flushToConnectionOutputSink(headerFrames, bufferToSend, new FlushCompletionHandler(null), null, isLast);
        }
        finally {
            deflaterLock.unlock();
        }
        if (outputQueueRecord == null) {
            return;
        }
        this.addOutputQueueRecord(outputQueueRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(CompletionHandler<Http2Stream> completionHandler) {
        if (this.unflushedWritesCounter.get() > 0) {
            Object object = this.flushHandlersSync;
            synchronized (object) {
                int counterNow = this.unflushedWritesCounter.get();
                if (counterNow > 0) {
                    if (this.flushHandlersQueue == null) {
                        this.flushHandlersQueue = new BundleQueue();
                    }
                    this.flushHandlersQueue.add(counterNow, completionHandler);
                    return;
                }
            }
        }
        completionHandler.completed(this.stream);
    }

    private int checkOutputWindow(long size) {
        return Math.max(0, Math.min(this.availStreamWindowSize.get(), (int)size));
    }

    private Buffer splitOutputBufferIfNeeded(Buffer buffer, int length) {
        if (length == buffer.remaining()) {
            return null;
        }
        return buffer.split(buffer.position() + length);
    }

    private void flushToConnectionOutputSink(List<Http2Frame> headerFrames, Buffer data, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner, boolean isLast) {
        this.http2Connection.getOutputSink().writeDataDownStream(this.stream, headerFrames, data, completionHandler, messageCloner, isLast);
        if (isLast) {
            this.terminate(Constants.OUT_FIN_TERMINATION);
        }
    }

    @Override
    public synchronized void close() {
        if (!this.isClosed()) {
            this.isLastFrameQueued = true;
            if (this.outputQueue.isEmpty()) {
                this.writeEmptyFin();
                return;
            }
            this.outputQueue.reserveSpace(1);
            this.outputQueue.offer(TERMINATING_QUEUE_RECORD);
            if (this.outputQueue.size() == 1 && this.outputQueue.remove(TERMINATING_QUEUE_RECORD)) {
                this.writeEmptyFin();
            }
        }
    }

    @Override
    public synchronized void terminate(Http2Stream.Termination terminationFlag) {
        if (!this.isTerminated()) {
            this.terminationFlag = terminationFlag;
            this.outputQueue.onClose();
            this.stream.onOutputClosed();
        }
    }

    @Override
    public boolean isClosed() {
        return this.isLastFrameQueued || this.isTerminated();
    }

    @Override
    public int getUnflushedWritesCount() {
        return this.unflushedWritesCounter.get();
    }

    private boolean isTerminated() {
        return this.terminationFlag != null;
    }

    private void writeEmptyFin() {
        if (!this.isTerminated()) {
            this.unflushedWritesCounter.incrementAndGet();
            this.flushToConnectionOutputSink(null, Buffers.EMPTY_BUFFER, new FlushCompletionHandler(null), null, true);
        }
    }

    private boolean isWantToWrite() {
        int windowSizeLimit;
        int availableWindowSizeBytesNow = this.availStreamWindowSize.get();
        return availableWindowSizeBytesNow >= (windowSizeLimit = this.stream.getPeerWindowSize()) / 4;
    }

    private void addOutputQueueRecord(OutputQueueRecord outputQueueRecord) throws Http2StreamException {
        do {
            this.outputQueue.setCurrentElement(outputQueueRecord);
            if (!this.isWantToWrite() || !this.outputQueue.compareAndSetCurrentElement(outputQueueRecord, null)) break;
            FlushCompletionHandler chunkedCompletionHandler = outputQueueRecord.chunkedCompletionHandler;
            boolean isLast = outputQueueRecord.isLast;
            boolean isZeroSizeData = outputQueueRecord.isZeroSizeData;
            Source currentResource = outputQueueRecord.resource;
            int fitWindowLen = this.checkOutputWindow(currentResource.remaining());
            Buffer dataChunkToSend = currentResource.read(fitWindowLen);
            if (currentResource.hasRemaining()) {
                outputQueueRecord.reset(currentResource, chunkedCompletionHandler, isLast);
                outputQueueRecord.incChunksCounter();
                isLast = false;
            } else {
                outputQueueRecord.release();
                outputQueueRecord = null;
            }
            if (dataChunkToSend != null && (dataChunkToSend.hasRemaining() || isLast)) {
                int dataChunkToSendSize = dataChunkToSend.remaining();
                this.flushToConnectionOutputSink(null, dataChunkToSend, chunkedCompletionHandler, null, isLast);
                this.availStreamWindowSize.addAndGet(-dataChunkToSendSize);
                this.releaseWriteQueueSpace(dataChunkToSendSize, isZeroSizeData, outputQueueRecord == null);
                continue;
            }
            if (!isZeroSizeData || outputQueueRecord != null) continue;
            this.releaseWriteQueueSpace(0, true, true);
        } while (outputQueueRecord != null);
    }

    private int reserveWriteQueueSpace(int spaceToReserve) {
        return this.outputQueue.reserveSpace(spaceToReserve);
    }

    private void releaseWriteQueueSpace(int justSentBytes, boolean isAtomic, boolean isEndOfChunk) {
        if (isEndOfChunk) {
            this.outputQueue.releaseSpace(isAtomic ? 1 : justSentBytes);
        } else if (!isAtomic) {
            this.outputQueue.releaseSpace(justSentBytes);
        }
    }

    private final class FlushCompletionHandler
    extends ChunkedCompletionHandler {
        public FlushCompletionHandler(CompletionHandler<WriteResult> parentCompletionHandler) {
            super(parentCompletionHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done0() {
            boolean hasNext;
            Object object = DefaultOutputSink.this.flushHandlersSync;
            synchronized (object) {
                DefaultOutputSink.this.unflushedWritesCounter.decrementAndGet();
                if (DefaultOutputSink.this.flushHandlersQueue == null || !DefaultOutputSink.this.flushHandlersQueue.nextBundle()) {
                    return;
                }
            }
            do {
                CompletionHandler handler;
                Object object2 = DefaultOutputSink.this.flushHandlersSync;
                synchronized (object2) {
                    handler = (CompletionHandler)DefaultOutputSink.this.flushHandlersQueue.next();
                    hasNext = DefaultOutputSink.this.flushHandlersQueue.hasNext();
                }
                try {
                    handler.completed(DefaultOutputSink.this.stream);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (hasNext);
        }
    }

    private static class OutputQueueRecord
    extends AsyncQueueRecord<WriteResult> {
        private Source resource;
        private FlushCompletionHandler chunkedCompletionHandler;
        private boolean isLast;
        private final boolean isZeroSizeData;

        public OutputQueueRecord(Source resource, FlushCompletionHandler completionHandler, boolean isLast, boolean isZeroSizeData) {
            super(null, null, null);
            this.resource = resource;
            this.chunkedCompletionHandler = completionHandler;
            this.isLast = isLast;
            this.isZeroSizeData = isZeroSizeData;
        }

        private void incChunksCounter() {
            if (this.chunkedCompletionHandler != null) {
                this.chunkedCompletionHandler.incChunks();
            }
        }

        private void reset(Source resource, FlushCompletionHandler completionHandler, boolean last) {
            this.resource = resource;
            this.chunkedCompletionHandler = completionHandler;
            this.isLast = last;
        }

        public void release() {
            if (this.resource != null) {
                this.resource.release();
                this.resource = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyFailure(Throwable e) {
            FlushCompletionHandler chLocal = this.chunkedCompletionHandler;
            this.chunkedCompletionHandler = null;
            try {
                if (chLocal != null) {
                    chLocal.failed(e);
                }
            }
            finally {
                this.release();
            }
        }

        @Override
        public void recycle() {
        }

        @Override
        public WriteResult getCurrentResult() {
            return null;
        }
    }
}

