/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2Request;
import org.glassfish.grizzly.http2.compression.HeaderListener;

class DecoderUtils {
    private static final Logger LOGGER = Grizzly.logger(DecoderUtils.class);

    DecoderUtils() {
    }

    static void decodeRequestHeaders(Http2Connection http2Connection, final HttpRequestPacket request) throws IOException {
        http2Connection.getHeadersDecoder().decode(new HeaderListener(){

            @Override
            public void onDecodedHeader(String name, String value) {
                if (name.charAt(0) == ':') {
                    DecoderUtils.processServiceRequestHeader(request, name, value);
                } else {
                    DecoderUtils.processNormalHeader(request, name, value);
                }
            }
        });
        request.setProtocol(Protocol.HTTP_2_0);
    }

    static void decodeResponseHeaders(Http2Connection http2Connection, final HttpResponsePacket response) throws IOException {
        http2Connection.getHeadersDecoder().decode(new HeaderListener(){

            @Override
            public void onDecodedHeader(String name, String value) {
                if (name.charAt(0) == ':') {
                    DecoderUtils.processServiceResponseHeader(response, name, value);
                } else {
                    DecoderUtils.processNormalHeader(response, name, value);
                }
            }
        });
        response.setProtocol(Protocol.HTTP_2_0);
    }

    private static void processServiceRequestHeader(HttpRequestPacket request, String name, String value) {
        int valueLen = value.length();
        switch (name) {
            case ":path": {
                int questionIdx = value.indexOf(63);
                if (questionIdx == -1) {
                    request.getRequestURIRef().init(value);
                } else {
                    request.getRequestURIRef().init(value.substring(0, questionIdx));
                    if (questionIdx < valueLen - 1) {
                        request.getQueryStringDC().setString(value.substring(questionIdx + 1));
                    }
                }
                return;
            }
            case ":method": {
                request.getMethodDC().setString(value);
                return;
            }
            case ":scheme": {
                request.setSecure(valueLen == 5);
                return;
            }
            case ":authority": {
                request.getHeaders().addValue(Header.Host).setString(value);
                return;
            }
        }
        LOGGER.log(Level.FINE, "Skipping unknown service header[{0}={1}", new Object[]{name, value});
    }

    private static void processServiceResponseHeader(HttpResponsePacket response, String name, String value) {
        int valueLen = value.length();
        switch (name) {
            case ":status": {
                if (valueLen != 3) {
                    throw new IllegalStateException("Unexpected status code: " + value);
                }
                response.setStatus(Integer.parseInt(value));
            }
        }
        LOGGER.log(Level.FINE, "Skipping unknown service header[{0}={1}", new Object[]{name, value});
    }

    private static void processNormalHeader(HttpHeader httpHeader, String name, String value) {
        MimeHeaders mimeHeaders = httpHeader.getHeaders();
        DataChunk valueChunk = mimeHeaders.addValue(name);
        valueChunk.setString(value.replace('\u0000', ','));
        DecoderUtils.finalizeKnownHeader(httpHeader, name, value);
    }

    private static void finalizeKnownHeader(HttpHeader httpHeader, String name, String value) {
        switch (name) {
            case "content-length": {
                httpHeader.setContentLengthLong(Long.parseLong(value));
                return;
            }
            case "upgrade": {
                httpHeader.getUpgradeDC().setString(value);
                return;
            }
            case "expect": {
                ((Http2Request)httpHeader).requiresAcknowledgement(true);
                return;
            }
        }
    }

    private static boolean checkArraysContent(byte[] b1, int pos1, byte[] control, int pos2) {
        int len = control.length - pos2;
        for (int i = 0; i < len; ++i) {
            if (b1[pos1 + i] == control[pos2 + i]) continue;
            return false;
        }
        return true;
    }

    private static final class InitialLineParsingState
    implements Cacheable {
        private static final ThreadCache.CachedTypeIndex<InitialLineParsingState> CACHE_IDX = ThreadCache.obtainIndex(InitialLineParsingState.class, 8);
        private byte parseState;

        private InitialLineParsingState() {
        }

        static InitialLineParsingState create() {
            InitialLineParsingState state = ThreadCache.getFromCache(CACHE_IDX);
            if (state == null) {
                state = new InitialLineParsingState();
            }
            return state;
        }

        void statusCodeParsed() {
            this.parseState = (byte)(this.parseState | 1);
        }

        boolean isParseComplete() {
            return this.parseState == 1;
        }

        @Override
        public void recycle() {
            this.parseState = 0;
            ThreadCache.putToCache(CACHE_IDX, this);
        }
    }
}

