/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.io.CharConversionException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.utils.Charsets;

public class HttpUtils {
    private static final float[] MULTIPLIERS = new float[]{0.1f, 0.01f, 0.001f};

    public static String composeContentType(String contentType, String characterEncoding) {
        String newContentType;
        if (characterEncoding == null) {
            return contentType;
        }
        boolean hasCharset = false;
        int semicolonIndex = -1;
        int index = contentType.indexOf(59);
        while (index != -1) {
            int len = contentType.length();
            semicolonIndex = index++;
            while (index < len && contentType.charAt(index) == ' ') {
                ++index;
            }
            if (index + 8 < len && contentType.charAt(index) == 'c' && contentType.charAt(index + 1) == 'h' && contentType.charAt(index + 2) == 'a' && contentType.charAt(index + 3) == 'r' && contentType.charAt(index + 4) == 's' && contentType.charAt(index + 5) == 'e' && contentType.charAt(index + 6) == 't' && contentType.charAt(index + 7) == '=') {
                hasCharset = true;
                break;
            }
            index = contentType.indexOf(59, index);
        }
        if (hasCharset) {
            newContentType = contentType.substring(0, semicolonIndex);
            String tail = contentType.substring(index + 8);
            int nextParam = tail.indexOf(59);
            if (nextParam != -1) {
                newContentType = newContentType + tail.substring(nextParam);
            }
        } else {
            newContentType = contentType;
        }
        StringBuilder sb = new StringBuilder(newContentType.length() + characterEncoding.length() + 9);
        return sb.append(newContentType).append(";charset=").append(characterEncoding).toString();
    }

    public static float convertQValueToFloat(DataChunk dc, int startIdx, int stopIdx) {
        float qvalue = 0.0f;
        DataChunk.Type type2 = dc.getType();
        try {
            switch (type2) {
                case String: {
                    qvalue = HttpUtils.convertQValueToFloat(dc.toString(), startIdx, stopIdx);
                    break;
                }
                case Buffer: {
                    BufferChunk bc = dc.getBufferChunk();
                    int offs = bc.getStart();
                    qvalue = HttpUtils.convertQValueToFloat(bc.getBuffer(), offs + startIdx, offs + stopIdx);
                    break;
                }
                case Chars: {
                    CharChunk cc = dc.getCharChunk();
                    int offs = cc.getStart();
                    qvalue = HttpUtils.convertQValueToFloat(cc.getChars(), offs + startIdx, offs + stopIdx);
                }
            }
        }
        catch (Exception e) {
            qvalue = 0.0f;
        }
        return qvalue;
    }

    public static float convertQValueToFloat(Buffer buffer, int startIdx, int stopIdx) {
        float result = 0.0f;
        boolean firstDigitProcessed = false;
        int multIdx = -1;
        int len = stopIdx - startIdx;
        for (int i = 0; i < len; ++i) {
            char c = (char)buffer.get(i + startIdx);
            if (multIdx == -1) {
                if (firstDigitProcessed && c != '.') {
                    throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
                }
                if (c == '.') {
                    multIdx = 0;
                    continue;
                }
            }
            if (Character.isDigit(c)) {
                if (multIdx == -1) {
                    result += (float)Character.digit(c, 10);
                    firstDigitProcessed = true;
                    if (!(result > 1.0f)) continue;
                    throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
                }
                if (multIdx >= MULTIPLIERS.length) {
                    throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
                }
                result += (float)Character.digit(c, 10) * MULTIPLIERS[multIdx++];
                continue;
            }
            throw new IllegalArgumentException("Invalid qvalue, " + buffer.toStringContent(Constants.DEFAULT_HTTP_CHARSET, startIdx, stopIdx) + ", detected");
        }
        return result;
    }

    public static float convertQValueToFloat(String string, int startIdx, int stopIdx) {
        float result = 0.0f;
        boolean firstDigitProcessed = false;
        int multIdx = -1;
        int len = stopIdx - startIdx;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i + startIdx);
            if (multIdx == -1) {
                if (firstDigitProcessed && c != '.') {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
                }
                if (c == '.') {
                    multIdx = 0;
                    continue;
                }
            }
            if (Character.isDigit(c)) {
                if (multIdx == -1) {
                    result += (float)Character.digit(c, 10);
                    firstDigitProcessed = true;
                    if (!(result > 1.0f)) continue;
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
                }
                if (multIdx >= MULTIPLIERS.length) {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
                }
                result += (float)Character.digit(c, 10) * MULTIPLIERS[multIdx++];
                continue;
            }
            throw new IllegalArgumentException("Invalid qvalue, " + new String(string.toCharArray(), startIdx, stopIdx) + ", detected");
        }
        return result;
    }

    public static float convertQValueToFloat(char[] chars, int startIdx, int stopIdx) {
        float result = 0.0f;
        boolean firstDigitProcessed = false;
        int multIdx = -1;
        int len = stopIdx - startIdx;
        for (int i = 0; i < len; ++i) {
            char c = chars[i + startIdx];
            if (multIdx == -1) {
                if (firstDigitProcessed && c != '.') {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
                }
                if (c == '.') {
                    multIdx = 0;
                    continue;
                }
            }
            if (Character.isDigit(c)) {
                if (multIdx == -1) {
                    result += (float)Character.digit(c, 10);
                    firstDigitProcessed = true;
                    if (!(result > 1.0f)) continue;
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
                }
                if (multIdx >= MULTIPLIERS.length) {
                    throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
                }
                result += (float)Character.digit(c, 10) * MULTIPLIERS[multIdx++];
                continue;
            }
            throw new IllegalArgumentException("Invalid qvalue, " + new String(chars, startIdx, stopIdx) + ", detected");
        }
        return result;
    }

    public static int longToBuffer(long value, byte[] buffer) {
        boolean negative;
        int i = buffer.length;
        if (value == 0L) {
            buffer[--i] = 48;
            return i;
        }
        int radix = 10;
        if (value < 0L) {
            negative = true;
            value = -value;
        } else {
            negative = false;
        }
        do {
            int ch = 48 + (int)(value % 10L);
            buffer[--i] = (byte)ch;
        } while ((value /= 10L) != 0L);
        if (negative) {
            buffer[--i] = 45;
        }
        return i;
    }

    public static void longToBuffer(long value, Buffer buffer) {
        boolean negative;
        if (value == 0L) {
            buffer.put(0, (byte)48);
            buffer.limit(1);
            return;
        }
        int radix = 10;
        if (value < 0L) {
            negative = true;
            value = -value;
        } else {
            negative = false;
        }
        int position = buffer.limit();
        do {
            int ch = 48 + (int)(value % 10L);
            buffer.put(--position, (byte)ch);
        } while ((value /= 10L) != 0L);
        if (negative) {
            buffer.put(--position, (byte)45);
        }
        buffer.position(position);
    }

    public static DataChunk filterNonPrintableCharacters(DataChunk message) {
        if (message == null || message.isNull()) {
            return null;
        }
        try {
            message.toChars(Charsets.ASCII_CHARSET);
        }
        catch (CharConversionException ignored) {
            // empty catch block
        }
        CharChunk charChunk = message.getCharChunk();
        char[] content = charChunk.getChars();
        int start = charChunk.getStart();
        int end = charChunk.getEnd();
        for (int i = start; i < end; ++i) {
            char c = content[i];
            if ((c > '\u001f' || c == '\t') && c != '\u007f' && c <= '\u00ff') continue;
            content[i] = 32;
        }
        return message;
    }

    public static DataChunk filter(DataChunk message) {
        if (message == null || message.isNull()) {
            return null;
        }
        try {
            message.toChars(Charsets.ASCII_CHARSET);
        }
        catch (CharConversionException ignored) {
            // empty catch block
        }
        CharChunk charChunk = message.getCharChunk();
        char[] content = charChunk.getChars();
        StringBuilder result = null;
        int end = charChunk.getEnd();
        block8: for (int i = charChunk.getStart(); i < end; ++i) {
            switch (content[i]) {
                case '<': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i);
                    }
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i);
                    }
                    result.append("&gt;");
                    continue block8;
                }
                case '&': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i);
                    }
                    result.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    if (result == null) {
                        result = new StringBuilder(content.length + 50);
                        result.append(content, 0, i);
                    }
                    result.append("&quot;");
                    continue block8;
                }
                default: {
                    char c = content[i];
                    if (c <= '\u001f' && c != '\t' || c == '\u007f' || c > '\u00ff') {
                        if (result == null) {
                            result = new StringBuilder(content.length + 50);
                            result.append(content, 0, i);
                        }
                        result.append("&#").append((int)c).append(';');
                        continue block8;
                    }
                    if (result == null) continue block8;
                    result.append(c);
                }
            }
        }
        if (result != null) {
            int len = result.length();
            char[] finalResult = new char[len];
            result.getChars(0, len, finalResult, 0);
            message.setChars(finalResult, 0, finalResult.length);
        }
        return message;
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        StringBuilder result = null;
        int len = message.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = message.charAt(i);
            switch (c) {
                case '<': {
                    if (result == null) {
                        result = new StringBuilder(len + 50);
                        result.append(message, 0, i);
                    }
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    if (result == null) {
                        result = new StringBuilder(len + 50);
                        result.append(message, 0, i);
                    }
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    if (result == null) {
                        result = new StringBuilder(len + 50);
                        result.append(message, 0, i);
                    }
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (result == null) {
                        result = new StringBuilder(len + 50);
                        result.append(message, 0, i);
                    }
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    if (c <= '\u001f' && c != '\t' || c == '\u007f' || c > '\u00ff') {
                        if (result == null) {
                            result = new StringBuilder(len + 50);
                            result.append(message, 0, i);
                        }
                        result.append("&#").append((int)c).append(';');
                        continue block6;
                    }
                    if (result == null) continue block6;
                    result.append(c);
                }
            }
        }
        return result == null ? message : result.toString();
    }
}

