/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.external.org.objectweb.asm.AnnotationVisitor;
import org.glassfish.hk2.external.org.objectweb.asm.Attribute;
import org.glassfish.hk2.external.org.objectweb.asm.ClassReader;
import org.glassfish.hk2.external.org.objectweb.asm.ClassVisitor;
import org.glassfish.hk2.external.org.objectweb.asm.FieldVisitor;
import org.glassfish.hk2.external.org.objectweb.asm.MethodVisitor;

class NodeInfo
extends ClassVisitor {
    private int nodeId;
    private int access;
    private String className;
    private String superClassName;
    private List<String> classLevelAnnotations;
    private String[] interfaces;
    private boolean parsed;
    private Set<String> directSubClasses;
    private Set<String> directImplementors;
    private Set<NodeInfo> directSubClassesNodeInfos;
    private Set<NodeInfo> directImplementorsNodeInfos;
    private int classType;
    private String classTypeAsString;
    private static final List<String> EMPTY_STRING_LIST = new ArrayList<String>(0);
    private static final Set<NodeInfo> EMPTY_NODEINFO_SET = new HashSet<NodeInfo>();

    NodeInfo(byte[] classData) {
        super(327680);
        ClassReader cr = new ClassReader(classData);
        cr.accept(this, 1);
    }

    void load(byte[] classData) {
        ClassReader cr = new ClassReader(classData);
        cr.accept(this, 1);
    }

    void markAsAnnotaionType() {
        if (this.parsed) {
            throw new IllegalStateException("Cannot mark as AnnotationType. Already marked as " + this.classTypeAsString);
        }
        this.classType = 8192;
    }

    void markAsClassType() {
        if (this.parsed) {
            throw new IllegalStateException("Cannot mark as Class Type. Already marked as " + this.classTypeAsString);
        }
        this.classType = 0;
    }

    void markAsInterfaceType() {
        if (this.parsed) {
            throw new IllegalStateException("Cannot mark as Interface Type. Already marked as " + this.classTypeAsString);
        }
        this.classType = 512;
    }

    void markAsEnumType() {
        if (this.parsed) {
            throw new IllegalStateException("Cannot mark as Enum Type. Already marked as " + this.classTypeAsString);
        }
        this.classType = 16384;
    }

    NodeInfo(String className) {
        super(327680);
        this.className = className;
    }

    int getNodeId() {
        return this.nodeId;
    }

    void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    String getClassName() {
        return this.className;
    }

    String getSuperClassName() {
        return this.superClassName;
    }

    List<String> getClassLevelAnnotations() {
        return this.classLevelAnnotations == null ? EMPTY_STRING_LIST : this.classLevelAnnotations;
    }

    String[] getInterfaces() {
        return this.interfaces == null ? new String[]{} : this.interfaces;
    }

    void addDirectSubClass(NodeInfo ni) {
        String subClass = ni.getClassName();
        if (this.directSubClasses == null) {
            this.directSubClasses = new HashSet<String>();
            this.directSubClassesNodeInfos = new HashSet<NodeInfo>();
        }
        this.directSubClasses.add(subClass);
        this.directSubClassesNodeInfos.add(ni);
    }

    void addDirectImplementor(NodeInfo ni) {
        String implementor = ni.getClassName();
        if (this.directImplementors == null) {
            this.directImplementors = new HashSet<String>();
            this.directImplementorsNodeInfos = new HashSet<NodeInfo>();
        }
        this.directImplementors.add(implementor);
        this.directImplementorsNodeInfos.add(ni);
    }

    Set<NodeInfo> getDirectImplementors() {
        return this.directImplementorsNodeInfos == null ? EMPTY_NODEINFO_SET : this.directImplementorsNodeInfos;
    }

    Set<NodeInfo> getDirectSubClass() {
        return this.directSubClassesNodeInfos == null ? EMPTY_NODEINFO_SET : this.directSubClassesNodeInfos;
    }

    boolean isInterface() {
        return this.classType == 512;
    }

    boolean isAnnotation() {
        return this.classType == 8192;
    }

    boolean isClass() {
        return this.classType == 0;
    }

    @Override
    public void visit(int version, int access, String className, String signature, String superName, String[] interfaces) {
        if (this.className != null && !this.className.equals(className)) {
            throw new IllegalStateException("Internal error: " + className + " != " + this.className);
        }
        this.access = access;
        this.className = className;
        this.superClassName = superName;
        this.interfaces = interfaces == null ? new String[]{} : interfaces;
        this.determineClassType();
    }

    public void determineClassType() {
        if ((this.access & 0x2000) != 0) {
            this.classType = 8192;
            this.classTypeAsString = "ANNOTATION";
        } else if ((this.access & 0x200) != 0) {
            this.classType = 512;
            this.classTypeAsString = "INTERFACE";
        } else if ((this.access & 0x4000) != 0) {
            this.classType = 16384;
            this.classTypeAsString = "ENUM";
        } else {
            this.classType = 0;
            this.classTypeAsString = "CLASS";
        }
    }

    public String getClassTypeAsString() {
        return this.classTypeAsString;
    }

    @Override
    public void visitSource(String s, String s1) {
    }

    @Override
    public void visitOuterClass(String s, String s1, String s2) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String s, boolean b) {
        if (this.classLevelAnnotations == null) {
            this.classLevelAnnotations = new ArrayList<String>(2);
        }
        int len = s.length();
        s = s.substring(1, len - 1);
        this.classLevelAnnotations.add(s);
        return null;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitInnerClass(String s, String s1, String s2, int i) {
    }

    @Override
    public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
        return null;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    @Override
    public void visitEnd() {
        this.parsed = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.className).append(": ");
        if (this.classLevelAnnotations != null) {
            for (String ann : this.classLevelAnnotations) {
                sb.append("\n  @").append(ann).append(" ");
            }
        }
        sb.append(this.className).append(":");
        if (this.superClassName != null) {
            sb.append(" -> ").append(this.superClassName);
        }
        if (this.interfaces != null) {
            String delim = " & ";
            for (String inter : this.interfaces) {
                sb.append(delim).append(inter);
                delim = ", ";
            }
        }
        if (this.directSubClasses != null) {
            for (String sub : this.directSubClasses) {
                sb.append("\n\tdirect subclass => ").append(sub);
            }
        }
        if (this.directImplementors != null) {
            for (String impl : this.directImplementors) {
                sb.append("\n\tdirect implementor => ").append(impl);
            }
        }
        sb.append("\n**********************");
        return sb.toString();
    }
}

