/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.admin.InterceptorNotifier;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTargetResolver;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="undeploy")
@I18n(value="undeploy.command")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Applications.class, opType=RestEndpoint.OpType.DELETE, path="undeploy", description="Undeploy an application")})
public class UndeployCommand
extends UndeployCommandParameters
implements AdminCommand,
DeploymentTargetResolver,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UndeployCommand.class);
    @Inject
    Deployment deployment;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Applications apps;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    VersioningService versioningService;
    @Inject
    ServerEnvironment env;
    @Inject
    Domain domain;
    @Inject
    CommandRunner commandRunner;
    @Inject
    ServiceLocator habitat;
    @Inject
    Events events;
    private ActionReport report;
    private Logger logger;
    private List<String> matchedVersions;

    public UndeployCommand() {
        this.origin = OpsParams.Origin.undeploy;
        this.command = OpsParams.Command.undeploy;
    }

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        this.deployment.validateSpecifiedTarget(this.target);
        if (this.target == null) {
            this.target = this.deployment.getDefaultTarget(this._classicstyle);
        }
        this.name = new File(this.name).getName();
        this.matchedVersions = null;
        try {
            this.matchedVersions = this.versioningService.getMatchedVersions(this.name, this.target);
        }
        catch (VersioningException e) {
            if (this.env.isDas()) {
                this.report.failure(this.logger, e.getMessage());
            } else {
                this.logger.fine(e.getMessage());
            }
            return false;
        }
        if (this.matchedVersions.isEmpty()) {
            if (this.env.isDas()) {
                this.report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", this.name, this.target));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                this.logger.fine(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", this.name, this.target));
            }
            return false;
        }
        for (String appName : this.matchedVersions) {
            Application application;
            if (this.target == null) {
                this.target = this.deployment.getDefaultTarget(appName, this.origin, this._classicstyle);
            }
            if ((application = this.apps.getModule(Application.class, appName)) != null) continue;
            this.report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", appName));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        return DeploymentCommandUtils.getAccessChecksForExistingApp(this.domain, this.apps, this.target, this.matchedVersions, "delete", "delete");
    }

    @Override
    public void execute(AdminCommandContext context) {
        for (String appName : this.matchedVersions) {
            ApplicationRef ref;
            if (this.target == null) {
                this.target = this.deployment.getDefaultTarget(appName, this.origin, this._classicstyle);
            }
            ApplicationInfo info = this.deployment.get(appName);
            Application application = this.apps.getModule(Application.class, appName);
            if (application == null) {
                this.report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", appName));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            this.deployment.validateUndeploymentTarget(this.target, appName);
            if (!DeploymentUtils.isDomainTarget(this.target) && (ref = this.domain.getApplicationRefInTarget(appName, this.target)) == null) {
                this.report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", appName, this.target));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ReadableArchive source = null;
            if (info == null) {
                URI uri = null;
                try {
                    uri = new URI(application.getLocation());
                }
                catch (URISyntaxException e) {
                    this.logger.severe("Cannot determine original location for application : " + e.getMessage());
                }
                if (uri != null) {
                    File location = new File(uri);
                    if (location.exists()) {
                        try {
                            source = this.archiveFactory.openArchive(location);
                        }
                        catch (IOException e) {
                            this.logger.log(Level.INFO, e.getMessage(), e);
                        }
                    } else {
                        this.logger.warning("Originally deployed application at " + location + " not found");
                    }
                }
            } else {
                source = info.getSource();
            }
            if (source == null) {
                this.logger.fine("Cannot get source archive for undeployment");
                try {
                    this.deployment.unregisterAppFromDomainXML(appName, this.target);
                }
                catch (TransactionFailure e) {
                    this.logger.warning("Module " + appName + " not found in configuration");
                }
                if (info != null) {
                    this.appRegistry.remove(appName);
                }
                return;
            }
            File sourceFile = new File(source.getURI());
            if (!source.exists()) {
                this.logger.log(Level.WARNING, "Cannot find application bits at " + sourceFile.getPath() + ". Please restart server to ensure server is in a consistent state before redeploy the application.");
                try {
                    this.deployment.unregisterAppFromDomainXML(appName, this.target);
                }
                catch (TransactionFailure e) {
                    this.logger.warning("Module " + appName + " not found in configuration");
                }
                if (info != null) {
                    this.appRegistry.remove(appName);
                }
                return;
            }
            this.name = appName;
            this._type = application.archiveType();
            ExtendedDeploymentContext deploymentContext = null;
            try {
                deploymentContext = this.deployment.getBuilder(this.logger, this, this.report).source(source).build();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Cannot create context for undeployment ", e);
                this.report.setMessage(localStrings.getLocalString("undeploy.contextcreation.failed", "Cannot create context for undeployment : {0} ", e.getMessage()));
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            InterceptorNotifier notifier = new InterceptorNotifier(this.habitat, deploymentContext);
            DeployCommandSupplementalInfo suppInfo = new DeployCommandSupplementalInfo();
            suppInfo.setDeploymentContext(deploymentContext);
            this.report.setResultType(DeployCommandSupplementalInfo.class, suppInfo);
            Properties appProps = deploymentContext.getAppProps();
            appProps.putAll((Map<?, ?>)application.getDeployProperties());
            if (this.properties != null) {
                appProps.putAll((Map<?, ?>)this.properties);
            }
            deploymentContext.setModulePropsMap(application.getModulePropertiesMap());
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.UNDEPLOYMENT_VALIDATION, deploymentContext), false);
            if (this.report.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
                return;
            }
            if (this.env.isDas() && !DeploymentUtils.isDASTarget(this.target)) {
                ActionReport subReport = this.report.addSubActionsReport();
                CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("disable", subReport, context.getSubject());
                try {
                    ParameterMapExtractor extractor = new ParameterMapExtractor(this);
                    ParameterMap parameters = extractor.extract(Collections.EMPTY_LIST);
                    parameters.set("DEFAULT", appName);
                    parameters.add("isundeploy", Boolean.TRUE.toString());
                    inv.parameters(parameters).execute();
                    if (subReport.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                        this.report.setMessage(localStrings.getLocalString("disable.command.failed", "{0} disabled failed", appName));
                        return;
                    }
                    if (DeploymentUtils.isDomainTarget(this.target)) {
                        List<String> targets = this.domain.getAllReferencedTargetsForApplication(appName);
                        parameters.remove("isUndeploy");
                        notifier.ensureBeforeReported(ExtendedDeploymentContext.Phase.REPLICATION);
                        ClusterOperationUtil.replicateCommand("undeploy", FailurePolicy.Error, FailurePolicy.Warn, FailurePolicy.Ignore, targets, context, parameters, this.habitat);
                    }
                }
                catch (Exception e) {
                    this.report.failure(this.logger, e.getMessage());
                    return;
                }
            }
            Artifacts generatedArtifacts = DeploymentUtils.generatedArtifacts(application);
            generatedArtifacts.record(deploymentContext);
            if (info != null) {
                this.deployment.undeploy(appName, deploymentContext);
            }
            boolean isDirectoryDeployed = Boolean.valueOf(application.getDirectoryDeployed());
            if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) continue;
            try {
                this.deployment.unregisterAppFromDomainXML(appName, this.target);
            }
            catch (TransactionFailure e) {
                this.logger.warning("Module " + appName + " not found in configuration");
            }
            deploymentContext.clean();
            try {
                Field[] fields;
                Class<?> clazz = Class.forName("sun.net.www.protocol.jar.JarFileFactory", true, URL.class.getClassLoader());
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (!"fileCache".equals(field.getName())) continue;
                    field.setAccessible(true);
                    HashMap files = (HashMap)field.get(null);
                    HashSet jars = new HashSet();
                    jars.addAll(files.values());
                    for (JarFile file : jars) {
                        file.close();
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | SecurityException ex) {
                this.logger.log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                this.logger.log(Level.SEVERE, null, ex);
            }
            System.gc();
            if (this.keepreposdir.booleanValue() || isDirectoryDeployed || !source.exists()) continue;
            source.delete();
        }
    }

    @Override
    public String getTarget(ParameterMap parameters) {
        return DeploymentCommandUtils.getTarget(parameters, this.origin, this.deployment);
    }
}

