/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_list-app-refs")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_list-app-refs", description="_list-app-refs")})
public class ListAppRefsCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    @Param(optional=true)
    String target = "server";
    @Param(optional=true)
    String type = null;
    @Param(optional=true, defaultValue="all")
    String state;
    @Inject
    Domain domain;
    @Inject
    Applications applications;
    private List<ApplicationRef> appRefs;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListAppRefsCommand.class);

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList accessChecks = new ArrayList();
        this.appRefs = this.domain.getApplicationRefsInTarget(this.target);
        for (ApplicationRef appRef : this.appRefs) {
            accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy(appRef), "read"));
        }
        return accessChecks;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        part.setMessage(this.target);
        part.setChildrenType("application");
        for (ApplicationRef appRef : this.appRefs) {
            if (!this.state.equals("all") && (!this.state.equals("running") || !Boolean.valueOf(appRef.getEnabled()).booleanValue()) && (!this.state.equals("non-running") || Boolean.valueOf(appRef.getEnabled()).booleanValue()) || !this.isApplicationOfThisType(appRef.getRef(), this.type)) continue;
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(appRef.getRef());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isApplicationOfThisType(String name, String type2) {
        if (type2 == null) {
            return true;
        }
        Application app = this.applications.getApplication(name);
        if (app != null) {
            if (!app.isStandaloneModule()) {
                return type2.equals("ear");
            }
            for (Module module : app.getModule()) {
                List<Engine> engineList = module.getEngines();
                for (Engine engine : engineList) {
                    if (!engine.getSniffer().equals(type2)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

