/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.ConstructorReportItem;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQueryResult;

public class ReportQuery
extends ReadAllQuery {
    public static final int ShouldReturnReportResult = 0;
    public static final int ShouldReturnSingleResult = 1;
    public static final int ShouldReturnSingleValue = 2;
    public static final int ShouldReturnSingleAttribute = 3;
    public static final int ShouldReturnWithoutReportQueryResult = 4;
    public static final int ShouldReturnArray = 5;
    public static final int ShouldSelectValue1 = 6;
    public static final int FULL_PRIMARY_KEY = 2;
    public static final int FIRST_PRIMARY_KEY = 1;
    public static final int NO_PRIMARY_KEY = 0;
    protected static final Boolean RESULT_IGNORED = Boolean.TRUE;
    protected int shouldRetrievePrimaryKeys;
    protected List<String> names;
    protected List<ReportItem> items;
    protected List<Expression> groupByExpressions;
    protected Expression havingExpression;
    protected int returnChoice;
    protected boolean addToConstructorItem;
    protected Set<Object> returnedKeys;

    public ReportQuery() {
        this.queryMechanism = new ExpressionQueryMechanism(this);
        this.items = new ArrayList<ReportItem>();
        this.shouldRetrievePrimaryKeys = 0;
        this.addToConstructorItem = false;
        this.setLockMode((short)0);
        this.shouldUseSerializedObjectPolicy = false;
    }

    public ReportQuery(Class javaClass, Expression expression) {
        this();
        this.defaultBuilder = expression.getBuilder();
        this.setReferenceClass(javaClass);
        this.setSelectionCriteria(expression);
    }

    public ReportQuery(Class javaClass, ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
        this.setReferenceClass(javaClass);
    }

    public ReportQuery(ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
    }

    public void addAttribute(String itemName) {
        this.addItem(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addAttribute(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression);
    }

    public void addAttribute(String itemName, Expression attributeExpression, Class type2) {
        this.addItem(itemName, attributeExpression, type2);
    }

    public void addAverage(String itemName) {
        this.addAverage(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addAverage(String itemName, Class resultType) {
        this.addAverage(itemName, this.getExpressionBuilder().get(itemName), resultType);
    }

    public void addAverage(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.average());
    }

    public void addAverage(String itemName, Expression attributeExpression, Class resultType) {
        this.addItem(itemName, attributeExpression.average(), resultType);
    }

    public void addConstructorReportItem(ConstructorReportItem item) {
        this.addItem(item);
    }

    public void addCount() {
        this.addCount("COUNT", this.getExpressionBuilder());
    }

    public void addCount(String attributeName) {
        this.addCount(attributeName, this.getExpressionBuilder().get(attributeName));
    }

    public void addCount(String attributeName, Class resultType) {
        this.addCount(attributeName, this.getExpressionBuilder().get(attributeName), resultType);
    }

    public void addCount(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.count());
    }

    public void addCount(String itemName, Expression attributeExpression, Class resultType) {
        this.addItem(itemName, attributeExpression.count(), resultType);
    }

    public void addFunctionItem(String itemName, Expression attributeExpression, String functionName) {
        Expression functionExpression = attributeExpression;
        functionExpression = attributeExpression.getFunction(functionName);
        ReportItem item = new ReportItem(itemName, functionExpression);
        this.addItem(item);
        this.setIsPrepared(false);
    }

    public void addGrouping(String attributeName) {
        this.addGrouping(this.getExpressionBuilder().get(attributeName));
    }

    public void addGrouping(Expression expression) {
        this.getGroupByExpressions().add(expression);
        this.setIsPrepared(false);
    }

    public void setHavingExpression(Expression expression) {
        this.havingExpression = expression;
        this.setIsPrepared(false);
    }

    private void addItem(ReportItem item) {
        if (this.addToConstructorItem && this.getItems().size() > 0 && this.getItems().get(this.getItems().size() - 1).isConstructorItem()) {
            ((ConstructorReportItem)this.getItems().get(this.getItems().size() - 1)).addItem(item);
        } else {
            this.getItems().add(item);
        }
        this.setIsPrepared(false);
    }

    public void addItem(String itemName, Expression attributeExpression) {
        ReportItem item = new ReportItem(itemName, attributeExpression);
        this.addItem(item);
        this.setIsPrepared(false);
    }

    public void addItem(String itemName, Expression attributeExpression, List joinedExpressions) {
        ReportItem item = new ReportItem(itemName, attributeExpression);
        if (joinedExpressions != null && !joinedExpressions.isEmpty()) {
            item.getJoinedAttributeManager().setJoinedAttributeExpressions_(joinedExpressions);
        }
        this.addItem(item);
    }

    protected void addItem(String itemName, Expression attributeExpression, Class resultType) {
        ReportItem item = new ReportItem(itemName, attributeExpression);
        item.setResultType(resultType);
        this.addItem(item);
    }

    public void addMaximum(String itemName) {
        this.addMaximum(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addMaximum(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.maximum());
    }

    public void addMinimum(String itemName) {
        this.addMinimum(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addMinimum(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.minimum());
    }

    public void addStandardDeviation(String itemName) {
        this.addStandardDeviation(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addStandardDeviation(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.standardDeviation());
    }

    public void addSum(String itemName) {
        this.addSum(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addSum(String itemName, Class resultType) {
        this.addSum(itemName, this.getExpressionBuilder().get(itemName), resultType);
    }

    public void addSum(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.sum());
    }

    public void addSum(String itemName, Expression attributeExpression, Class resultType) {
        this.addItem(itemName, attributeExpression.sum(), resultType);
    }

    public void addVariance(String itemName) {
        this.addVariance(itemName, this.getExpressionBuilder().get(itemName));
    }

    public void addVariance(String itemName, Expression attributeExpression) {
        this.addItem(itemName, attributeExpression.variance());
    }

    public ConstructorReportItem beginAddingConstructorArguments(Class constructorClass) {
        ConstructorReportItem citem = new ConstructorReportItem(constructorClass.getName());
        citem.setResultType(constructorClass);
        this.getItems().add(citem);
        this.setIsPrepared(false);
        this.addToConstructorItem = true;
        return citem;
    }

    public ConstructorReportItem beginAddingConstructorArguments(Class constructorClass, Class[] constructorArgTypes) {
        ConstructorReportItem citem = this.beginAddingConstructorArguments(constructorClass);
        citem.setConstructorArgTypes(constructorArgTypes);
        return citem;
    }

    @Override
    public Object buildObject(AbstractRecord row) {
        Vector<AbstractRecord> v = new Vector<AbstractRecord>();
        v.add(row);
        return this.buildObject(row, v);
    }

    public Object buildObject(AbstractRecord row, Vector toManyJoinData) {
        ReportQueryResult reportQueryResult = new ReportQueryResult(this, row, toManyJoinData);
        if (this.returnedKeys != null) {
            if (this.returnedKeys.contains(reportQueryResult.getResultKey())) {
                return RESULT_IGNORED;
            }
            this.returnedKeys.add(reportQueryResult.getResultKey());
        }
        if (this.shouldReturnSingleAttribute()) {
            return reportQueryResult.getResults().get(0);
        }
        if (this.shouldReturnArray()) {
            return reportQueryResult.toArray();
        }
        if (this.shouldReturnWithoutReportQueryResult()) {
            if (reportQueryResult.size() == 1) {
                return reportQueryResult.getResults().get(0);
            }
            return reportQueryResult.toArray();
        }
        if (this.shouldReturnSingleValue()) {
            return reportQueryResult.getResults().get(0);
        }
        return reportQueryResult;
    }

    public Object buildObjects(Vector rows) {
        if (this.shouldReturnSingleResult() || this.shouldReturnSingleValue()) {
            if (rows.isEmpty()) {
                return null;
            }
            return this.buildObject((AbstractRecord)rows.get(0), rows);
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        int size = rows.size();
        Object reportResults = containerPolicy.containerInstance(size);
        if (this.shouldDistinctBeUsed()) {
            this.returnedKeys = new HashSet<Object>(size);
        }
        int index = 0;
        while (index < size) {
            Object result = this.buildObject((AbstractRecord)rows.get(index), rows);
            if (result != RESULT_IGNORED) {
                containerPolicy.addInto(result, reportResults, this.session);
            }
            ++index;
        }
        if (this.shouldCacheQueryResults()) {
            this.setTemporaryCachedQueryResults(reportResults);
        }
        return reportResults;
    }

    @Override
    protected Object checkEarlyReturnLocal(AbstractSession session, AbstractRecord translationRow) {
        if (this.shouldCheckCacheOnly()) {
            throw QueryException.cannotSetShouldCheckCacheOnlyOnReportQuery();
        }
        return null;
    }

    @Override
    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        return null;
    }

    @Override
    public Object clone() {
        ReportQuery cloneQuery = (ReportQuery)super.clone();
        cloneQuery.items = new ArrayList<ReportItem>(this.items.size());
        for (ReportItem item : this.items) {
            ReportItem newItem = (ReportItem)item.clone();
            if (item.getJoinedAttributeManagerInternal() != null) {
                JoinedAttributeManager manager = item.getJoinedAttributeManager().clone();
                manager.setBaseQuery(cloneQuery);
                newItem.setJoinedAttributeManager(manager);
            }
            cloneQuery.addItem(newItem);
        }
        if (this.groupByExpressions != null) {
            cloneQuery.groupByExpressions = new ArrayList<Expression>(this.groupByExpressions);
        }
        return cloneQuery;
    }

    public void copyReportItems(Map alreadyDone) {
        Cloneable item;
        this.items = new ArrayList<ReportItem>(this.items);
        int i = this.items.size() - 1;
        while (i >= 0) {
            item = this.items.get(i);
            Expression expression = ((ReportItem)item).getAttributeExpression();
            if (expression != null && alreadyDone.get(expression.getBuilder()) != null) {
                expression = expression.copiedVersionFrom(alreadyDone);
            }
            this.items.set(i, new ReportItem(((ReportItem)item).getName(), expression));
            --i;
        }
        if (this.groupByExpressions != null) {
            this.groupByExpressions = new ArrayList<Expression>(this.groupByExpressions);
            i = this.groupByExpressions.size() - 1;
            while (i >= 0) {
                item = this.groupByExpressions.get(i);
                if (alreadyDone.get(((Expression)item).getBuilder()) != null) {
                    this.groupByExpressions.set(i, ((Expression)item).copiedVersionFrom(alreadyDone));
                }
                --i;
            }
        }
        if (this.havingExpression != null) {
            this.havingExpression = this.havingExpression.copiedVersionFrom(alreadyDone);
        }
        if (this.orderByExpressions != null) {
            i = this.orderByExpressions.size() - 1;
            while (i >= 0) {
                item = (Expression)this.orderByExpressions.get(i);
                if (alreadyDone.get(((Expression)item).getBuilder()) != null) {
                    this.orderByExpressions.set(i, ((Expression)item).copiedVersionFrom(alreadyDone));
                }
                --i;
            }
        }
    }

    public void dontRetrievePrimaryKeys() {
        this.setShouldRetrievePrimaryKeys(false);
        this.setIsPrepared(false);
    }

    public void dontReturnSingleAttribute() {
        if (this.shouldReturnSingleAttribute()) {
            this.returnChoice = 0;
        }
    }

    public void dontReturnSingleResult() {
        if (this.shouldReturnSingleResult()) {
            this.returnChoice = 0;
        }
    }

    public void dontReturnSingleValue() {
        if (this.shouldReturnSingleValue()) {
            this.returnChoice = 0;
        }
    }

    public void dontReturnWithoutReportQueryResult() {
        if (this.shouldReturnWithoutReportQueryResult()) {
            this.returnChoice = 0;
        }
    }

    public void endAddingToConstructorItem() {
        this.addToConstructorItem = false;
    }

    @Override
    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.isLockQuery() && this.getSession().isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
            if (this.isLockQuery() && !unitOfWork.getCommitManager().isActive() && !unitOfWork.wasTransactionBegunPrematurely()) {
                unitOfWork.beginTransaction();
                unitOfWork.setWasTransactionBegunPrematurely(true);
            }
        }
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        if (this.getQueryId() == 0L) {
            this.setQueryId(this.getSession().getNextQueryId());
        }
        this.setExecutionTime(System.currentTimeMillis());
        if (this.getDescriptor().isDescriptorForInterface()) {
            return this.getDescriptor().getInterfacePolicy().selectAllObjectsUsingMultipleTableSubclassRead(this);
        }
        return this.buildObjects(this.getQueryMechanism().selectAllReportQueryRows());
    }

    @Override
    public Object extractRemoteResult(Transporter transporter) {
        return transporter.getObject();
    }

    public List<Expression> getGroupByExpressions() {
        if (this.groupByExpressions == null) {
            this.groupByExpressions = new ArrayList<Expression>();
        }
        return this.groupByExpressions;
    }

    public boolean hasGroupByExpressions() {
        return this.groupByExpressions != null && !this.groupByExpressions.isEmpty();
    }

    public void setGroupByExpressions(List<Expression> groupByExpressions) {
        this.groupByExpressions = groupByExpressions;
    }

    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public Vector getQueryExpressions() {
        NonSynchronizedVector fieldExpressions = NonSynchronizedVector.newInstance(this.getItems().size());
        if (this.shouldSelectValue1()) {
            ConstantExpression one = new ConstantExpression(new Integer(1), new ExpressionBuilder());
            this.addItem("one", one);
            this.dontUseDistinct();
            ((Vector)fieldExpressions).addElement(one);
        } else if (this.shouldRetrieveFirstPrimaryKey() && !this.getDescriptor().getPrimaryKeyFields().isEmpty()) {
            ((Vector)fieldExpressions).addElement(this.getDescriptor().getPrimaryKeyFields().get(0));
        }
        if (this.shouldRetrievePrimaryKeys()) {
            ((Vector)fieldExpressions).addAll(this.getDescriptor().getPrimaryKeyFields());
        }
        return fieldExpressions;
    }

    @Override
    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultReportQueryRedirector();
    }

    public List<ReportItem> getItems() {
        return this.items;
    }

    public ReportItem getItem(String name) {
        for (ReportItem item : this.items) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public void setItems(List<ReportItem> items) {
        this.items = items;
    }

    @Override
    public boolean setLockModeType(String lockModeType, AbstractSession session) {
        if (lockModeType != null) {
            if (super.setLockModeType(lockModeType, session)) {
                return true;
            }
            if (!(lockModeType.equals("PESSIMISTIC_READ") || lockModeType.equals("PESSIMISTIC_WRITE") || lockModeType.equals("NONE"))) {
                for (ReportItem reportItem : this.getItems()) {
                    OptimisticLockingPolicy lockingPolicy;
                    if (reportItem.getAttributeExpression() == null || !reportItem.getAttributeExpression().isExpressionBuilder() || (lockingPolicy = reportItem.getDescriptor().getOptimisticLockingPolicy()) != null && lockingPolicy instanceof VersionLockingPolicy) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void clearItems() {
        this.items = new ArrayList<ReportItem>();
        this.setIsPrepared(false);
    }

    public List<String> getNames() {
        if (this.names == null) {
            this.names = new ArrayList<String>();
            for (ReportItem item : this.getItems()) {
                this.names.add(item.getName());
            }
        }
        return this.names;
    }

    protected void setNames(List<String> names) {
        this.names = names;
    }

    @Override
    public boolean isReportQuery() {
        return true;
    }

    @Override
    protected void prepare() throws QueryException {
        if (this.prepareFromCachedQuery()) {
            return;
        }
        if (this.getItems().size() > 0) {
            try {
                for (ReportItem item : this.getItems()) {
                    item.initialize(this);
                }
            }
            catch (QueryException exception) {
                exception.setQuery(this);
                throw exception;
            }
        } else if (!(this.shouldRetrievePrimaryKeys() || this.shouldRetrieveFirstPrimaryKey() || this.shouldSelectValue1())) {
            throw QueryException.noAttributesForReportQuery(this);
        }
        super.prepare();
    }

    @Override
    public void prepareFetchGroup() throws QueryException {
        if (this.fetchGroup != null || this.fetchGroupName != null) {
            throw QueryException.fetchGroupNotSupportOnReportQuery();
        }
    }

    @Override
    public void prepareFromQuery(DatabaseQuery query) {
        super.prepareFromQuery(query);
        if (query.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)query;
            this.names = reportQuery.names;
            this.items = reportQuery.items;
            this.groupByExpressions = reportQuery.groupByExpressions;
            this.havingExpression = reportQuery.havingExpression;
            this.returnChoice = reportQuery.returnChoice;
            this.returnedKeys = reportQuery.returnedKeys;
            this.shouldRetrievePrimaryKeys = reportQuery.shouldRetrievePrimaryKeys;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ReportQuery query = (ReportQuery)object;
        List<ReportItem> items = this.getItems();
        List<ReportItem> otherItems = query.getItems();
        int size = items.size();
        if (size != otherItems.size()) {
            return false;
        }
        int index = 0;
        while (index < size) {
            if (!items.get(index).equals(otherItems.get(index))) {
                return false;
            }
            ++index;
        }
        if (this.hasGroupByExpressions() && query.hasGroupByExpressions()) {
            List<Expression> groupBys = this.getGroupByExpressions();
            List<Expression> otherGroupBys = query.getGroupByExpressions();
            size = groupBys.size();
            if (size != otherGroupBys.size()) {
                return false;
            }
            int index2 = 0;
            while (index2 < size) {
                if (!((Object)groupBys.get(index2)).equals(otherGroupBys.get(index2))) {
                    return false;
                }
                ++index2;
            }
        } else if (this.hasGroupByExpressions() || query.hasGroupByExpressions()) {
            return false;
        }
        if (this.getHavingExpression() != query.getHavingExpression() && this.getHavingExpression() != null && !this.getHavingExpression().equals(query.getHavingExpression())) {
            return false;
        }
        if (this.returnChoice != query.returnChoice) {
            return false;
        }
        return this.shouldRetrievePrimaryKeys == query.shouldRetrievePrimaryKeys;
    }

    protected void prepareObjectAttributeCount(Map clonedExpressions) {
        this.prepareObjectAttributeCount(this.getItems(), clonedExpressions);
    }

    private void prepareObjectAttributeCount(List items, Map clonedExpressions) {
        int numOfReportItems = items.size();
        int i = 0;
        while (i < numOfReportItems) {
            ReportItem item = (ReportItem)items.get(i);
            if (item != null) {
                if (item instanceof ConstructorReportItem) {
                    this.prepareObjectAttributeCount(((ConstructorReportItem)item).getReportItems(), clonedExpressions);
                } else if (item.getAttributeExpression() instanceof FunctionExpression) {
                    FunctionExpression count = (FunctionExpression)item.getAttributeExpression();
                    count.prepareObjectAttributeCount(null, item, this, clonedExpressions);
                }
            }
            ++i;
        }
    }

    @Override
    protected void prepareSelectAllRows() {
        this.prepareObjectAttributeCount(null);
        this.getQueryMechanism().prepareReportQuerySelectAllRows();
    }

    public synchronized void prepareSubSelect(AbstractSession session, AbstractRecord translationRow, Map clonedExpressions) throws QueryException {
        if (this.isPrepared()) {
            return;
        }
        this.setIsPrepared(true);
        this.setSession(session);
        this.setTranslationRow(translationRow);
        this.checkDescriptor(this.getSession());
        if (this.descriptor.isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.descriptor, this);
        }
        try {
            for (ReportItem item : this.getItems()) {
                item.initialize(this);
            }
        }
        catch (QueryException exception) {
            exception.setQuery(this);
            throw exception;
        }
        this.prepareObjectAttributeCount(clonedExpressions);
        this.getQueryMechanism().prepareReportQuerySubSelect();
        this.setSession(null);
        this.setTranslationRow(null);
    }

    @Override
    public Map replaceValueHoldersIn(Object object, RemoteSessionController controller) {
        return null;
    }

    public void retrievePrimaryKeys() {
        this.setShouldRetrievePrimaryKeys(true);
        this.setIsPrepared(false);
    }

    public int getReturnType() {
        return this.returnChoice;
    }

    public void setReturnType(int returnChoice) {
        this.returnChoice = returnChoice;
    }

    public void returnSingleAttribute() {
        this.returnChoice = 3;
    }

    public void returnSingleResult() {
        this.returnChoice = 1;
    }

    public void returnSingleValue() {
        this.returnChoice = 2;
    }

    public void returnWithoutReportQueryResult() {
        this.returnChoice = 4;
    }

    public void selectValue1() {
        this.returnChoice = 6;
    }

    public void setShouldRetrievePrimaryKeys(boolean shouldRetrievePrimaryKeys) {
        this.shouldRetrievePrimaryKeys = shouldRetrievePrimaryKeys ? 2 : 0;
    }

    public void setShouldRetrieveFirstPrimaryKey(boolean shouldRetrieveFirstPrimaryKey) {
        this.shouldRetrievePrimaryKeys = shouldRetrieveFirstPrimaryKey ? 1 : 0;
    }

    public void setShouldReturnSingleAttribute(boolean newChoice) {
        if (newChoice) {
            this.returnSingleAttribute();
        } else {
            this.dontReturnSingleAttribute();
        }
    }

    public void setShouldReturnSingleResult(boolean newChoice) {
        if (newChoice) {
            this.returnSingleResult();
        } else {
            this.dontReturnSingleResult();
        }
    }

    public void setShouldReturnSingleValue(boolean newChoice) {
        if (newChoice) {
            this.returnSingleValue();
        } else {
            this.dontReturnSingleValue();
        }
    }

    public void setShouldReturnWithoutReportQueryResult(boolean newChoice) {
        if (newChoice) {
            this.returnWithoutReportQueryResult();
        } else {
            this.dontReturnWithoutReportQueryResult();
        }
    }

    public boolean shouldRetrievePrimaryKeys() {
        return this.shouldRetrievePrimaryKeys == 2;
    }

    public boolean shouldRetrieveFirstPrimaryKey() {
        return this.shouldRetrievePrimaryKeys == 1;
    }

    public boolean shouldReturnSingleAttribute() {
        return this.returnChoice == 3;
    }

    public boolean shouldReturnSingleResult() {
        return this.returnChoice == 1;
    }

    public boolean shouldReturnSingleValue() {
        return this.returnChoice == 2;
    }

    public boolean shouldReturnWithoutReportQueryResult() {
        return this.returnChoice == 4;
    }

    public boolean shouldReturnArray() {
        return this.returnChoice == 5;
    }

    public boolean shouldSelectValue1() {
        return this.returnChoice == 6;
    }
}

