/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree.analysis;

import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.AnalyzerException;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.BasicValue;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.BasicVerifier;

public class SimpleVerifier
extends BasicVerifier {
    private final Type currentClass;
    private final Type currentSuperClass;
    private final List<Type> currentClassInterfaces;
    private final boolean isInterface;
    private ClassLoader loader = this.getClass().getClassLoader();

    public SimpleVerifier() {
        this(null, null, false);
    }

    public SimpleVerifier(Type type2, Type type3, boolean bl) {
        this(type2, type3, null, bl);
    }

    public SimpleVerifier(Type type2, Type type3, List<Type> list, boolean bl) {
        this(327680, type2, type3, list, bl);
    }

    protected SimpleVerifier(int n, Type type2, Type type3, List<Type> list, boolean bl) {
        super(n);
        this.currentClass = type2;
        this.currentSuperClass = type3;
        this.currentClassInterfaces = list;
        this.isInterface = bl;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    @Override
    public BasicValue newValue(Type type2) {
        BasicValue basicValue;
        boolean bl;
        if (type2 == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        boolean bl2 = bl = type2.getSort() == 9;
        if (bl) {
            switch (type2.getElementType().getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return new BasicValue(type2);
                }
            }
        }
        if (BasicValue.REFERENCE_VALUE.equals(basicValue = super.newValue(type2))) {
            if (bl) {
                basicValue = this.newValue(type2.getElementType());
                String string = basicValue.getType().getDescriptor();
                for (int i = 0; i < type2.getDimensions(); ++i) {
                    string = '[' + string;
                }
                basicValue = new BasicValue(Type.getType(string));
            } else {
                basicValue = new BasicValue(type2);
            }
        }
        return basicValue;
    }

    @Override
    protected boolean isArrayValue(BasicValue basicValue) {
        Type type2 = basicValue.getType();
        return type2 != null && ("Lnull;".equals(type2.getDescriptor()) || type2.getSort() == 9);
    }

    @Override
    protected BasicValue getElementValue(BasicValue basicValue) throws AnalyzerException {
        Type type2 = basicValue.getType();
        if (type2 != null) {
            if (type2.getSort() == 9) {
                return this.newValue(Type.getType(type2.getDescriptor().substring(1)));
            }
            if ("Lnull;".equals(type2.getDescriptor())) {
                return basicValue;
            }
        }
        throw new Error("Internal error");
    }

    @Override
    protected boolean isSubTypeOf(BasicValue basicValue, BasicValue basicValue2) {
        Type type2 = basicValue2.getType();
        Type type3 = basicValue.getType();
        switch (type2.getSort()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type3.equals(type2);
            }
            case 9: 
            case 10: {
                if ("Lnull;".equals(type3.getDescriptor())) {
                    return true;
                }
                if (type3.getSort() == 10 || type3.getSort() == 9) {
                    return this.isAssignableFrom(type2, type3);
                }
                return false;
            }
        }
        throw new Error("Internal error");
    }

    @Override
    public BasicValue merge(BasicValue basicValue, BasicValue basicValue2) {
        if (!basicValue.equals(basicValue2)) {
            Type type2 = basicValue.getType();
            Type type3 = basicValue2.getType();
            if (!(type2 == null || type2.getSort() != 10 && type2.getSort() != 9 || type3 == null || type3.getSort() != 10 && type3.getSort() != 9)) {
                if ("Lnull;".equals(type2.getDescriptor())) {
                    return basicValue2;
                }
                if ("Lnull;".equals(type3.getDescriptor())) {
                    return basicValue;
                }
                if (this.isAssignableFrom(type2, type3)) {
                    return basicValue;
                }
                if (this.isAssignableFrom(type3, type2)) {
                    return basicValue2;
                }
                do {
                    if (type2 != null && !this.isInterface(type2)) continue;
                    return BasicValue.REFERENCE_VALUE;
                } while (!this.isAssignableFrom(type2 = this.getSuperClass(type2), type3));
                return this.newValue(type2);
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return basicValue;
    }

    protected boolean isInterface(Type type2) {
        if (this.currentClass != null && type2.equals(this.currentClass)) {
            return this.isInterface;
        }
        return this.getClass(type2).isInterface();
    }

    protected Type getSuperClass(Type type2) {
        if (this.currentClass != null && type2.equals(this.currentClass)) {
            return this.currentSuperClass;
        }
        Class<?> clazz = this.getClass(type2).getSuperclass();
        return clazz == null ? null : Type.getType(clazz);
    }

    protected boolean isAssignableFrom(Type type2, Type type3) {
        if (type2.equals(type3)) {
            return true;
        }
        if (this.currentClass != null && type2.equals(this.currentClass)) {
            if (this.getSuperClass(type3) == null) {
                return false;
            }
            if (this.isInterface) {
                return type3.getSort() == 10 || type3.getSort() == 9;
            }
            return this.isAssignableFrom(type2, this.getSuperClass(type3));
        }
        if (this.currentClass != null && type3.equals(this.currentClass)) {
            if (this.isAssignableFrom(type2, this.currentSuperClass)) {
                return true;
            }
            if (this.currentClassInterfaces != null) {
                for (int i = 0; i < this.currentClassInterfaces.size(); ++i) {
                    Type type4 = this.currentClassInterfaces.get(i);
                    if (!this.isAssignableFrom(type2, type4)) continue;
                    return true;
                }
            }
            return false;
        }
        Class<Object> clazz = this.getClass(type2);
        if (clazz.isInterface()) {
            clazz = Object.class;
        }
        return clazz.isAssignableFrom(this.getClass(type3));
    }

    protected Class<?> getClass(Type type2) {
        try {
            if (type2.getSort() == 9) {
                return Class.forName(type2.getDescriptor().replace('/', '.'), false, this.loader);
            }
            return Class.forName(type2.getClassName(), false, this.loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.toString());
        }
    }
}

