/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.beanvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.Constraint;
import org.eclipse.persistence.internal.jpa.metadata.beanvalidation.ReflectionUtils;
import org.eclipse.persistence.internal.jpa.metadata.beanvalidation.ValidationXMLReader;

public final class BeanValidationHelper {
    private static final Logger LOGGER = Logger.getLogger(BeanValidationHelper.class.getName());
    private Future<Map<Class<?>, Boolean>> future;
    private final Set<String> KNOWN_CONSTRAINTS = new HashSet<String>();
    private Map<Class<?>, Boolean> CONSTRAINTS_ON_CLASSES = null;

    public BeanValidationHelper() {
        this.initializeKnownConstraints();
        if (ValidationXMLReader.isValidationXmlPresent()) {
            this.parseValidationXmlAsync();
        } else {
            this.CONSTRAINTS_ON_CLASSES = new HashMap();
        }
    }

    public boolean isConstrained(Class<?> clazz) {
        Boolean annotated = this.getConstraintsMap().get(clazz);
        if (annotated == null) {
            annotated = this.detectConstraints(clazz);
            this.getConstraintsMap().put(clazz, annotated);
        }
        return annotated;
    }

    public Map<Class<?>, Boolean> getConstraintsMap() {
        if (this.CONSTRAINTS_ON_CLASSES == null) {
            if (this.future == null) {
                this.CONSTRAINTS_ON_CLASSES = this.parseValidationXml();
            } else {
                try {
                    this.CONSTRAINTS_ON_CLASSES = this.future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.log(Level.WARNING, "Error parsing validation.xml the async way", e);
                    this.CONSTRAINTS_ON_CLASSES = this.parseValidationXml();
                }
            }
        }
        return this.CONSTRAINTS_ON_CLASSES;
    }

    private void parseValidationXmlAsync() {
        Executor executor = null;
        try {
            try {
                executor = this.createExecutor();
                this.future = executor.executorService.submit(new ValidationXMLReader());
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "Error creating/submitting async validation.xml parsing task.", e);
                this.future = null;
                if (executor != null && executor.shutdownNeeded) {
                    executor.executorService.shutdown();
                }
            }
        }
        finally {
            if (executor != null && executor.shutdownNeeded) {
                executor.executorService.shutdown();
            }
        }
    }

    private Map<Class<?>, Boolean> parseValidationXml() {
        HashMap result;
        ValidationXMLReader reader = new ValidationXMLReader();
        try {
            result = reader.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error parsing validation.xml synchronously", e);
            result = new HashMap();
        }
        return result;
    }

    private Boolean detectConstraints(Class<?> clazz) {
        Class<? extends Annotation> classAnnotationType;
        Annotation typesClassAnnotation;
        int n;
        int n2;
        Annotation[] annotationArray;
        Class<? extends Annotation> type2;
        Annotation a;
        int n3;
        int n4;
        Annotation[] annotationArray2;
        AccessibleObject[] accessibleObjectArray = ReflectionUtils.getDeclaredFields(clazz);
        int n5 = accessibleObjectArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Field f = accessibleObjectArray[n6];
            annotationArray2 = f.getDeclaredAnnotations();
            n4 = annotationArray2.length;
            n3 = 0;
            while (n3 < n4) {
                a = annotationArray2[n3];
                type2 = a.annotationType();
                if (this.KNOWN_CONSTRAINTS.contains(type2.getName())) {
                    return true;
                }
                annotationArray = type2.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    typesClassAnnotation = annotationArray[n];
                    classAnnotationType = typesClassAnnotation.annotationType();
                    if (Constraint.class == classAnnotationType) {
                        this.KNOWN_CONSTRAINTS.add(type2.getName());
                        return true;
                    }
                    ++n;
                }
                ++n3;
            }
            ++n6;
        }
        accessibleObjectArray = ReflectionUtils.getDeclaredMethods(clazz);
        n5 = accessibleObjectArray.length;
        n6 = 0;
        while (n6 < n5) {
            AccessibleObject m = accessibleObjectArray[n6];
            annotationArray2 = ((Method)m).getDeclaredAnnotations();
            n4 = annotationArray2.length;
            n3 = 0;
            while (n3 < n4) {
                a = annotationArray2[n3];
                type2 = a.annotationType();
                if (this.KNOWN_CONSTRAINTS.contains(type2.getName())) {
                    return true;
                }
                annotationArray = type2.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    typesClassAnnotation = annotationArray[n];
                    classAnnotationType = typesClassAnnotation.annotationType();
                    if (Constraint.class == classAnnotationType) {
                        this.KNOWN_CONSTRAINTS.add(type2.getName());
                        return true;
                    }
                    ++n;
                }
                ++n3;
            }
            ++n6;
        }
        accessibleObjectArray = ReflectionUtils.getDeclaredConstructors(clazz);
        n5 = accessibleObjectArray.length;
        n6 = 0;
        while (n6 < n5) {
            AccessibleObject c = accessibleObjectArray[n6];
            annotationArray2 = ((Constructor)c).getDeclaredAnnotations();
            n4 = annotationArray2.length;
            n3 = 0;
            while (n3 < n4) {
                a = annotationArray2[n3];
                type2 = a.annotationType();
                if (this.KNOWN_CONSTRAINTS.contains(type2.getName())) {
                    return true;
                }
                annotationArray = type2.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    typesClassAnnotation = annotationArray[n];
                    classAnnotationType = typesClassAnnotation.annotationType();
                    if (Constraint.class == classAnnotationType) {
                        this.KNOWN_CONSTRAINTS.add(type2.getName());
                        return true;
                    }
                    ++n;
                }
                ++n3;
            }
            ++n6;
        }
        return false;
    }

    private Executor createExecutor() {
        try {
            InitialContext jndiCtx = new InitialContext();
            return new Executor((ExecutorService)jndiCtx.lookup("java:comp/env/concurrent/ThreadPool"), false);
        }
        catch (NamingException namingException) {
            return new Executor(Executors.newFixedThreadPool(1), true);
        }
    }

    private void initializeKnownConstraints() {
        this.KNOWN_CONSTRAINTS.add("javax.validation.Valid");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Max");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Min");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.DecimalMax");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.DecimalMin");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Digits");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.NotNull");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Pattern");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Size");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.AssertTrue");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.AssertFalse");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Future");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Past");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Max.List");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Min.List");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.DecimalMax.List");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.DecimalMin.List");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Digits.List");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.NotNull.List");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Pattern.List");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Size.List");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.AssertTrue.List");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.AssertFalse.List");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Future.List");
        this.KNOWN_CONSTRAINTS.add("javax.validation.constraints.Past.List");
    }

    private static class Executor {
        ExecutorService executorService;
        boolean shutdownNeeded;

        Executor(ExecutorService executorService, boolean shutdownNeeded) {
            this.executorService = executorService;
            this.shutdownNeeded = shutdownNeeded;
        }
    }
}

