/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveBase;
import org.eclipse.persistence.internal.jpa.deployment.DirectoryArchive;
import org.eclipse.persistence.internal.jpa.deployment.DirectoryInsideJarURLArchive;
import org.eclipse.persistence.internal.jpa.deployment.JarFileArchive;
import org.eclipse.persistence.internal.jpa.deployment.JarInputStreamURLArchive;
import org.eclipse.persistence.internal.jpa.deployment.URLArchive;
import org.eclipse.persistence.jpa.Archive;
import org.eclipse.persistence.jpa.ArchiveFactory;

public class ArchiveFactoryImpl
implements ArchiveFactory {
    protected Logger logger;

    public ArchiveFactoryImpl() {
        this(Logger.global);
    }

    public ArchiveFactoryImpl(Logger logger2) {
        this.logger = logger2;
    }

    @Override
    public Archive createArchive(URL rootUrl, Map properties) throws URISyntaxException, IOException {
        return this.createArchive(rootUrl, null, properties);
    }

    @Override
    public Archive createArchive(URL rootUrl, String descriptorLocation, Map properties) throws URISyntaxException, IOException {
        this.logger.entering("ArchiveFactoryImpl", "createArchive", new Object[]{rootUrl, descriptorLocation});
        if (rootUrl == null) {
            return null;
        }
        ArchiveBase result = null;
        String protocol = rootUrl.getProtocol();
        this.logger.logp(Level.FINER, "ArchiveFactoryImpl", "createArchive", "protocol = {0}", protocol);
        if ("file".equals(protocol)) {
            File f;
            URI uri = Helper.toURI(rootUrl);
            try {
                f = new File(uri);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                f = new File(rootUrl.getPath());
            }
            result = f.isDirectory() ? new DirectoryArchive(f, descriptorLocation) : new JarFileArchive(rootUrl, new JarFile(f), descriptorLocation);
        } else if ("jar".equals(protocol)) {
            JarURLConnection conn = (JarURLConnection)JarURLConnection.class.cast(rootUrl.openConnection());
            conn.setUseCaches(false);
            JarEntry je = conn.getJarEntry();
            result = je == null ? new JarFileArchive(rootUrl, conn.getJarFile(), descriptorLocation) : (je.isDirectory() ? new DirectoryInsideJarURLArchive(rootUrl, descriptorLocation) : new JarInputStreamURLArchive(rootUrl, descriptorLocation));
        } else {
            result = this.isJarInputStream(rootUrl) ? new JarInputStreamURLArchive(rootUrl, descriptorLocation) : new URLArchive(rootUrl, descriptorLocation);
        }
        this.logger.exiting("ArchiveFactoryImpl", "createArchive", result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isJarInputStream(URL url) throws IOException {
        InputStream in = null;
        try {
            in = url.openStream();
            if (in == null) {
                return false;
            }
            try (JarInputStream jis = null;){
                jis = new JarInputStream(in);
                if (jis.getNextEntry() != null) return true;
                return false;
            }
        }
        catch (IOException iOException) {
            if (in == null) return false;
            in.close();
            return false;
        }
    }
}

