/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast.admin;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-cache-keys")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list-cache-keys")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-cache-keys", description="Lists Hazelcast caches keys")})
public class ListCacheKeys
implements AdminCommand {
    @Inject
    HazelcastCore hazelcast;
    @Inject
    protected Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Param(name="name", optional=true, defaultValue="")
    protected String cacheName;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        if (this.hazelcast.isEnabled()) {
            HazelcastInstance instance = this.hazelcast.getInstance();
            if (instance != null) {
                StringBuilder builder = new StringBuilder();
                builder.append("{ \n");
                for (DistributedObject dobject : instance.getDistributedObjects()) {
                    if (!(dobject instanceof IMap) || this.cacheName != null && !this.cacheName.isEmpty() && !this.cacheName.equals(((IMap)dobject).getName())) continue;
                    builder.append("Cache " + ((IMap)dobject).getName()).append("\n{");
                    for (ActionReport actionReport2 : ((IMap)dobject).keySet()) {
                        try {
                            builder.append(actionReport2.toString()).append(",\n");
                        }
                        catch (Exception cnfe) {
                            builder.append(cnfe.getMessage()).append(",\n");
                        }
                    }
                    builder.append("}\n");
                }
                builder.append("}\n");
                actionReport.setMessage(builder.toString());
                Properties extraProps = new Properties();
                StringBuilder extraBuilder = new StringBuilder(actionReport.getMessage());
                extraBuilder.append("<br/>");
                for (ActionReport actionReport3 : actionReport.getSubActionsReport()) {
                    extraBuilder.append(actionReport3.getMessage()).append("<br/>");
                }
                extraProps.put("Cache", extraBuilder.toString());
                actionReport.setExtraProperties(extraProps);
            } else {
                Properties extraProps = new Properties();
                extraProps.put("Caches", "Hazelcast is not enabled");
                actionReport.setExtraProperties(extraProps);
                actionReport.setMessage("Hazelcast is not enabled");
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
        } else {
            Properties extraProps = new Properties();
            extraProps.put("Caches", "Hazelcast is not enabled");
            actionReport.setExtraProperties(extraProps);
            actionReport.setMessage("Hazelcast is not enabled");
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

