/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import fish.payara.nucleus.hazelcast.MulticastConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.cache.spi.CachingProvider;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Service;

@Service(name="hazelcast-core")
@RunLevel(value=10)
public class HazelcastCore
implements EventListener {
    public static final String INSTANCE_ATTRIBUTE = "GLASSFISH-INSTANCE";
    private static HazelcastCore theCore;
    private static MulticastConfiguration overrideConfiguration;
    private HazelcastInstance theInstance;
    private CachingProvider hazelcastCachingProvider;
    private boolean enabled;
    private String memberName;
    @Inject
    Events events;
    @Inject
    ServerContext context;
    @Inject
    @Named(value="default-instance-name")
    HazelcastRuntimeConfiguration configuration;

    public static HazelcastCore getCore() {
        return theCore;
    }

    public static void setMulticastOverride(MulticastConfiguration config) {
        overrideConfiguration = config;
    }

    @PostConstruct
    public void postConstruct() {
        theCore = this;
        this.enabled = Boolean.valueOf(this.configuration.getEnabled());
        this.events.register(this);
        if (Boolean.valueOf(this.configuration.getEnabled()).booleanValue()) {
            this.bootstrapHazelcast();
        }
    }

    public HazelcastInstance getInstance() {
        return this.theInstance;
    }

    public CachingProvider getCachingProvider() {
        return this.hazelcastCachingProvider;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.shutdownHazelcast();
        } else if (event.is(EventTypes.SERVER_READY) && this.enabled) {
            this.bindToJNDI();
        }
    }

    public void setEnabled(Boolean enabled) {
        if (this.enabled || enabled.booleanValue()) {
            if (this.enabled && !enabled.booleanValue()) {
                this.enabled = false;
                this.shutdownHazelcast();
            } else if (!this.enabled && enabled.booleanValue()) {
                this.enabled = true;
                this.bootstrapHazelcast();
                this.bindToJNDI();
            } else if (this.enabled && enabled.booleanValue()) {
                this.shutdownHazelcast();
                this.bootstrapHazelcast();
                this.bindToJNDI();
            }
        }
    }

    private Config buildConfiguration() {
        Config config = new Config();
        String hazelcastFilePath = "";
        try {
            if (overrideConfiguration != null && overrideConfiguration.getAlternateConfigFile() != null) {
                XmlConfigBuilder builder = new XmlConfigBuilder(overrideConfiguration.getAlternateConfigFile().toURL());
                config = builder.build();
                return config;
            }
            URL serverConfigURL = new URL(this.context.getServerConfigURL());
            File serverConfigFile = new File(serverConfigURL.getPath());
            hazelcastFilePath = serverConfigFile.getParentFile().getAbsolutePath() + File.separator + this.configuration.getHazelcastConfigurationFile();
            File file = new File(hazelcastFilePath);
            if (file.exists()) {
                config = ConfigLoader.load(hazelcastFilePath);
                if (config == null) {
                    Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Hazelcast Core could not find configuration file {0} using default configuration", hazelcastFilePath);
                    config = new Config();
                }
            } else {
                this.memberName = this.context.getInstanceName();
                MulticastConfig mcConfig = config.getNetworkConfig().getJoin().getMulticastConfig();
                config.getNetworkConfig().setPortAutoIncrement(true);
                mcConfig.setEnabled(true);
                if (overrideConfiguration != null) {
                    mcConfig.setMulticastGroup(overrideConfiguration.getMulticastGroup());
                    mcConfig.setMulticastPort(overrideConfiguration.getMulticastPort());
                    config.getNetworkConfig().setPort(overrideConfiguration.getStartPort());
                    if (overrideConfiguration.getMemberName() != null) {
                        this.memberName = overrideConfiguration.getMemberName();
                    }
                    config.setLiteMember(overrideConfiguration.isLite());
                    GroupConfig gc = config.getGroupConfig();
                    gc.setName(overrideConfiguration.getClusterGroupName());
                    gc.setPassword(overrideConfiguration.getClusterGroupPassword());
                } else {
                    mcConfig.setMulticastGroup(this.configuration.getMulticastGroup());
                    mcConfig.setMulticastPort(Integer.valueOf(this.configuration.getMulticastPort()));
                    config.getNetworkConfig().setPort(Integer.valueOf(this.configuration.getStartPort()));
                    config.setLiteMember(Boolean.parseBoolean(this.configuration.getLite()));
                    GroupConfig gc = config.getGroupConfig();
                    gc.setName(this.configuration.getClusterGroupName());
                    gc.setPassword(this.configuration.getClusterGroupPassword());
                }
                config.setProperty("hazelcast.jmx", "true");
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Unable to parse server config URL", ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Hazelcast Core could not load configuration file " + hazelcastFilePath + " using default configuration", ex);
        }
        return config;
    }

    private void shutdownHazelcast() {
        if (this.theInstance != null) {
            this.unbindFromJNDI();
            this.hazelcastCachingProvider.getCacheManager().close();
            this.hazelcastCachingProvider.close();
            this.theInstance.shutdown();
            this.theInstance = null;
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Shutdown Hazelcast");
        }
    }

    private void bootstrapHazelcast() {
        Config config = this.buildConfiguration();
        this.theInstance = Hazelcast.newHazelcastInstance(config);
        if (this.memberName == null) {
            this.memberName = this.context.getInstanceName();
        }
        this.theInstance.getCluster().getLocalMember().setStringAttribute(INSTANCE_ATTRIBUTE, this.memberName);
        this.hazelcastCachingProvider = HazelcastServerCachingProvider.createCachingProvider(this.theInstance);
    }

    private void bindToJNDI() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.bind(this.configuration.getJNDIName(), (Object)this.theInstance);
            ctx.bind(this.configuration.getCachingProviderJNDIName(), (Object)this.hazelcastCachingProvider);
            ctx.bind(this.configuration.getCacheManagerJNDIName(), (Object)this.hazelcastCachingProvider.getCacheManager());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast Instance Bound to JNDI at {0}", this.configuration.getJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Caching Provider Bound to JNDI at {0}", this.configuration.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Default Cache Manager Bound to JNDI at {0}", this.configuration.getCacheManagerJNDIName());
        }
        catch (NamingException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void unbindFromJNDI() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(this.configuration.getJNDIName());
            ctx.unbind(this.configuration.getCacheManagerJNDIName());
            ctx.unbind(this.configuration.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast Instance Unbound from JNDI at {0}", this.configuration.getJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Caching Provider Unbound from JNDI at {0}", this.configuration.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Cache Manager Unbound from JNDI at {0}", this.configuration.getCacheManagerJNDIName());
        }
        catch (NamingException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

