/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.security.web.GlassFishSingleSignOn;
import com.sun.enterprise.server.logging.GFFileHandler;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.enterprise.v3.services.impl.GrizzlyProxy;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.web.ContextFacade;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.PEWebContainerFeatureFactoryImpl;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.VirtualServerPipeline;
import com.sun.enterprise.web.WebConnector;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.logger.CatalinaLogger;
import com.sun.enterprise.web.logger.FileLoggerHandler;
import com.sun.enterprise.web.logger.FileLoggerHandlerFactory;
import com.sun.enterprise.web.pluggable.WebContainerFeatureFactory;
import com.sun.web.security.RealmAdapter;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.web.ConfigException;
import org.glassfish.embeddable.web.Context;
import org.glassfish.embeddable.web.WebListener;
import org.glassfish.embeddable.web.config.VirtualServerConfig;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.config.GenericGrizzlyListener;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.admin.monitor.RequestProbeProvider;
import org.glassfish.web.deployment.archivist.WebArchivist;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.glassfish.web.loader.WebappClassLoader;
import org.glassfish.web.valve.GlassFishValve;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualServer
extends StandardHost
implements org.glassfish.embeddable.web.VirtualServer {
    private static final String STATE = "state";
    private static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    private static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    private static final String SSO_COOKIE_SECURE = "sso-cookie-secure";
    private static final String DISABLED = "disabled";
    private static final String OFF = "off";
    private static final String ON = "on";
    private static final Logger DEFAULT_LOGGER = WebContainer.logger;
    protected static final ResourceBundle rb = DEFAULT_LOGGER.getResourceBundle();
    @LogMessageInfo(message="The web module {0} has been designated as the default-web-module for virtual server {1}", level="FINE")
    public static final String VS_DEFAULT_WEB_MODULE = "AS-WEB-GLUE-00135";
    @LogMessageInfo(message="Error looking up the configuration information of the default-web-module {0} for virtual server {1}", level="SEVERE", cause="The web module specified is either not found or disabled or does not specify this virtual server, or there was an error loading its deployment descriptors", action="Verify if the virtual server's default web module is valid")
    public static final String VS_DEFAULT_WEB_MODULE_NOT_FOUND = "AS-WEB-GLUE-00136";
    @LogMessageInfo(message="The default-web-module {0} is either disabled or does not specify virtual server {1}", level="SEVERE", cause="The default web module is disabled or does not specify virtual server", action="Verify if the default web module is enabled and specify virtual server")
    public static final String VS_DEFAULT_WEB_MODULE_DISABLED = "AS-WEB-GLUE-00137";
    @LogMessageInfo(message="Virtual server {0} has invalid authentication realm {1}", level="SEVERE", cause="The realm {1} could not be found", action="Verify if the realm {1} exits for virtual server {0}")
    public static final String INVALID_AUTH_REALM = "AS-WEB-GLUE-00138";
    @LogMessageInfo(message="Invalid sso-cookie-secure configuration {0} for virtual server {1}", level="INFO")
    public static final String INVALID_SSO_COOKIE_SECURE = "AS-WEB-GLUE-00139";
    @LogMessageInfo(message="Realm {0} is not an instance of {1}, and will be ignored", level="SEVERE", cause="The realm {0} is either NULL or is not an instance of {1}", action="Verify if the realm {0} is an instance of {1}")
    public static final String IGNORE_INVALID_REALM = "AS-WEB-GLUE-00140";
    @LogMessageInfo(message="Virtual server {0} has a property with missing name or value", level="WARNING")
    public static final String NULL_VIRTUAL_SERVER_PROPERTY = "AS-WEB-GLUE-00141";
    @LogMessageInfo(message="Invalid redirect property value {0} for virtual server {1}: More than one {2} component", level="WARNING")
    public static final String REDIRECT_MULTIPLE_ELEMENT = "AS-WEB-GLUE-00142";
    @LogMessageInfo(message="Invalid redirect property value {0} for virtual server {1}: Missing url or url-prefix component", level="WARNING")
    public static final String REDIRECT_MISSING_URL_OR_URL_PREFIX = "AS-WEB-GLUE-00143";
    @LogMessageInfo(message="Invalid redirect property value {0} for virtual server {1}: Both url and url-prefix specified", level="WARNING")
    public static final String REDIRECT_BOTH_URL_AND_URL_PREFIX = "AS-WEB-GLUE-00144";
    @LogMessageInfo(message="Invalid redirect property value {0} for virtual server {1}: escape must be equal to yes or no", level="WARNING")
    public static final String REDIRECT_INVALID_ESCAPE = "AS-WEB-GLUE-00145";
    @LogMessageInfo(message="Invalid send-error property value {0} for virtual server {1}: More than one {2} component", level="WARNING")
    public static final String SEND_ERROR_MULTIPLE_ELEMENT = "AS-WEB-GLUE-00146";
    @LogMessageInfo(message="Invalid send-error property value {0} for virtual server {1}: Missing path component", level="WARNING")
    public static final String SEND_ERROR_MISSING_PATH = "AS-WEB-GLUE-00147";
    @LogMessageInfo(message="Unable to add listener of type {0} to virtual server {1}", level="SEVERE", cause="The listener is not an instance of ContainerListener or LifecycleListener", action="Verify if the listener type is supported")
    public static final String INVALID_LISTENER = "AS-WEB-GLUE-00148";
    @LogMessageInfo(message=" Unable to load extension class {0} from web module {1}", level="SEVERE", cause="An exception occurred loading extension class", action="Check the exception for the error")
    public static final String UNABLE_TO_LOAD_EXTENSION = "AS-WEB-GLUE-00149";
    @LogMessageInfo(message="Object of type classname {0} not an instance of Valve or GlassFishValve", level="WARNING")
    public static final String NOT_A_VALVE = "AS-WEB-GLUE-00150";
    @LogMessageInfo(message="Error adding HttpProbes. NetworkListener {0}'s HttpCodecFilter is {1}", level="SEVERE", cause="HttpCodecFilter is either NULL or empty", action="Verify the NetworkListener is valid")
    public static final String CODE_FILTERS_NULL = "AS-WEB-GLUE-00151";
    @LogMessageInfo(message="Error adding HttpProbes", level="SEVERE", cause="An exception occurred adding HttpProbes", action="Check the exception for the error")
    public static final String ADD_HTTP_PROBES_ERROR = "AS-WEB-GLUE-00152";
    @LogMessageInfo(message="Disabling Single Sign On (SSO) for virtual server {0} as configured", level="FINE")
    public static final String DISABLE_SSO = "AS-WEB-GLUE-00153";
    @LogMessageInfo(message="Enabling Single Sign On (SSO) for virtual server {0} as configured", level="FINE")
    public static final String ENABLE_SSO = "AS-WEB-GLUE-00154";
    @LogMessageInfo(message="SSO entry max idle time set to {0} for virtual server {1}", level="FINE")
    public static final String SSO_MAX_INACTIVE_SET = "AS-WEB-GLUE-00155";
    @LogMessageInfo(message="SSO expire thread interval set to {0} for virtual server {1}", level="FINE")
    public static final String SSO_REAP_INTERVAL_SET = "AS-WEB-GLUE-00156";
    @LogMessageInfo(message="Allowing access to {0} from {1}", level="FINE")
    public static final String ALLOW_ACCESS = "AS-WEB-GLUE-00157";
    @LogMessageInfo(message="Denying access to {0} from {1}", level="FINE")
    public static final String DENY_ACCESS = "AS-WEB-GLUE-00158";
    @LogMessageInfo(message="Virtual server {0} enabled context {1}", level="FINE")
    public static final String VS_ENABLED_CONTEXT = "AS-WEB-GLUE-00159";
    @LogMessageInfo(message="Unable to delete {0}", level="WARNING")
    public static final String UNABLE_TO_DELETE = "AS-WEB-GLUE-00160";
    @LogMessageInfo(message="Unable to reconfigure access log valve", level="SEVERE", cause="An exception occurred during access log valve reconfiguration", action="Check the exception for error")
    public static final String UNABLE_RECONFIGURE_ACCESS_LOG = "AS-WEB-GLUE-00161";
    @LogMessageInfo(message="Virtual server {0} added context {1}", level="FINE")
    public static final String VS_ADDED_CONTEXT = "AS-WEB-GLUE-00162";
    @LogMessageInfo(message="Application {0} is not found", level="SEVERE", cause="The deployed application is not found", action="Check if the application is valid")
    public static final String APP_NOT_FOUND = "AS-WEB-GLUE-00163";
    @LogMessageInfo(message="Cannot create context for undeployment", level="SEVERE", cause="An IOException occurred during undeployment", action="Check the exception for error")
    public static final String REMOVE_CONTEXT_ERROR = "AS-WEB-GLUE-00164";
    @LogMessageInfo(message="Successfully removed context {0}", level="FINE")
    public static final String REMOVED_CONTEXT = "AS-WEB-GLUE-00165";
    @LogMessageInfo(message="Modifying web.xml {0}", level="FINE")
    public static final String MODIFYING_WEB_XML = "AS-WEB-GLUE-00166";
    @LogMessageInfo(message="Error adding HttpProbes. NetworkListener {0}'s GrizzlyProxy is NULL", level="SEVERE", cause="GrizzlyProxy is NULL", action="Verify the NetworkListener is valid")
    public static final String PROXY_NULL = "AS-WEB-GLUE-00167";
    private VirtualServerPipeline vsPipeline;
    private Pipeline origPipeline;
    private String _id = null;
    protected Logger _logger = DEFAULT_LOGGER;
    private static final String _info = "com.sun.enterprise.web.VirtualServer/1.0";
    private com.sun.enterprise.config.serverbeans.VirtualServer vsBean;
    private MimeMap mimeMap;
    private boolean allowLinking = false;
    private String[] cacheControls;
    private ClassLoaderHierarchy clh;
    private Domain domain;
    private ServiceLocator services;
    private boolean isActive;
    private String authRealmName;
    private PEAccessLogValve accessLogValve;
    private String ssoCookieSecure = null;
    private boolean ssoCookieHttpOnly = false;
    private String defaultContextPath = null;
    private ServerContext serverContext;
    private Config serverConfig;
    private GrizzlyService grizzlyService;
    private WebContainer webContainer;
    private boolean ssoFailoverEnabled = false;
    private volatile FileLoggerHandler fileLoggerHandler = null;
    private volatile FileLoggerHandlerFactory fileLoggerHandlerFactory = null;
    private Deployment deployment = null;
    private ArchiveFactory factory = null;
    private ActionReport report = null;
    private HttpProbeImpl httpProbe = null;
    private VirtualServerConfig config;
    private List<WebListener> listeners = new ArrayList<WebListener>();

    public VirtualServer() {
        this.origPipeline = this.pipeline;
        this.vsPipeline = new VirtualServerPipeline(this);
        this.accessLogValve = new PEAccessLogValve();
        this.accessLogValve.setContainer(this);
    }

    @Override
    public String getID() {
        return this._id;
    }

    @Override
    public void setID(String id) {
        this._id = id;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
        if (isActive) {
            this.vsPipeline.setIsDisabled(false);
            this.vsPipeline.setIsOff(false);
            if (this.pipeline == this.vsPipeline && !this.vsPipeline.hasRedirects()) {
                this.setPipeline(this.origPipeline);
            }
        }
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public com.sun.enterprise.config.serverbeans.VirtualServer getBean() {
        return this.vsBean;
    }

    public void setBean(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        this.vsBean = vsBean;
    }

    public MimeMap getMimeMap() {
        return this.mimeMap;
    }

    public void setMimeMap(MimeMap mimeMap) {
        this.mimeMap = mimeMap;
    }

    public String[] getCacheControls() {
        return this.cacheControls;
    }

    public void setCacheControls(String[] cacheControls) {
        this.cacheControls = cacheControls;
    }

    public void setServices(ServiceLocator services) {
        this.services = services;
    }

    @Override
    public String getInfo() {
        return _info;
    }

    public void setDefaultContextPath(String defaultContextPath) {
        this.defaultContextPath = defaultContextPath;
    }

    public void setFileLoggerHandlerFactory(FileLoggerHandlerFactory factory) {
        this.fileLoggerHandlerFactory = factory;
    }

    public void setClassLoaderHierarchy(ClassLoaderHierarchy clh) {
        this.clh = clh;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    @Override
    public Container findChild(String contextRoot) {
        if (this.defaultContextPath != null && "/".equals(contextRoot)) {
            return super.findChild(this.defaultContextPath);
        }
        return super.findChild(contextRoot);
    }

    @Override
    public void configureSingleSignOnCookieSecure(Cookie ssoCookie, HttpServletRequest hreq) {
        super.configureSingleSignOnCookieSecure(ssoCookie, hreq);
        if (this.ssoCookieSecure != null && !this.ssoCookieSecure.equals("dynamic")) {
            ssoCookie.setSecure(Boolean.parseBoolean(this.ssoCookieSecure));
        }
    }

    @Override
    public void configureSingleSignOnCookieHttpOnly(Cookie ssoCookie) {
        ssoCookie.setHttpOnly(this.ssoCookieHttpOnly);
    }

    @Override
    public synchronized void addValve(GlassFishValve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    @Override
    public synchronized void addValve(Valve valve) {
        super.addValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.addValve(valve);
        } else {
            this.vsPipeline.addValve(valve);
        }
    }

    @Override
    public synchronized void removeValve(GlassFishValve valve) {
        super.removeValve(valve);
        if (this.pipeline == this.vsPipeline) {
            this.origPipeline.removeValve(valve);
        } else {
            this.vsPipeline.removeValve(valve);
        }
    }

    private ConfigBeansUtilities getConfigBeansUtilities() {
        if (this.services == null) {
            return null;
        }
        return this.services.getService(ConfigBeansUtilities.class, new Annotation[0]);
    }

    protected String getDefaultContextPath(Domain domain, ApplicationRegistry appRegistry) {
        Object contextRoot = null;
        String wmID = this.getDefaultWebModuleID();
        if (wmID != null) {
            ConfigBeansUtilities cbu;
            Applications appsBean = domain.getApplications();
            WebModuleConfig wmInfo = this.findWebModuleInJ2eeApp(appsBean, wmID, appRegistry);
            contextRoot = wmInfo == null ? ((cbu = this.getConfigBeansUtilities()) == null ? null : cbu.getContextRoot(wmID)) : wmInfo.getContextPath();
            if (contextRoot == null) {
                Object[] params = new Object[]{wmID, this.getID()};
                this._logger.log(Level.SEVERE, VS_DEFAULT_WEB_MODULE_NOT_FOUND, params);
            }
        }
        return contextRoot;
    }

    protected WebModuleConfig getDefaultWebModule(Domain domain, WebArchivist webArchivist, ApplicationRegistry appRegistry) {
        WebModuleConfig wmInfo = null;
        String wmID = this.getDefaultWebModuleID();
        if (wmID != null) {
            Applications appsBean = domain.getApplications();
            wmInfo = this.findWebModuleInJ2eeApp(appsBean, wmID, appRegistry);
            if (wmInfo == null) {
                ConfigBeansUtilities cbu = this.getConfigBeansUtilities();
                String contextRoot = null;
                String location = null;
                if (cbu != null) {
                    contextRoot = cbu.getContextRoot(wmID);
                    location = cbu.getLocation(wmID);
                }
                if (contextRoot != null && location != null) {
                    File docroot = new File(location);
                    WebBundleDescriptorImpl wbd = webArchivist.getDefaultWebXmlBundleDescriptor();
                    wmInfo = new WebModuleConfig();
                    wbd.setName("__default-web-module");
                    wbd.setContextRoot(contextRoot);
                    wmInfo.setLocation(docroot);
                    wmInfo.setDescriptor(wbd);
                    wmInfo.setParentLoader(EmbeddedWebContainer.class.getClassLoader());
                    WebappClassLoader cloader = AccessController.doPrivileged(new PrivilegedAction<WebappClassLoader>(){

                        @Override
                        public WebappClassLoader run() {
                            return new WebappClassLoader(EmbeddedWebContainer.class.getClassLoader());
                        }
                    });
                    wmInfo.setAppClassLoader(cloader);
                }
            }
            if (wmInfo == null) {
                this._logger.log(Level.SEVERE, VS_DEFAULT_WEB_MODULE_NOT_FOUND, new Object[]{wmID, this.getID()});
            }
        }
        return wmInfo;
    }

    public WebModuleConfig createSystemDefaultWebModuleIfNecessary(WebArchivist webArchivist) {
        WebModuleConfig wmInfo = null;
        String docroot = this.getAppBase();
        if (this.getDefaultWebModuleID() == null && this.findChild("") == null && docroot != null) {
            WebBundleDescriptorImpl wbd = webArchivist.getDefaultWebXmlBundleDescriptor();
            wmInfo = new WebModuleConfig();
            wbd.setModuleID("__default-web-module");
            wbd.setContextRoot("");
            wmInfo.setLocation(new File(docroot));
            wmInfo.setDescriptor(wbd);
            wmInfo.setParentLoader(this.serverContext.getCommonClassLoader());
            WebappClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<WebappClassLoader>(){

                @Override
                public WebappClassLoader run() {
                    return new WebappClassLoader(VirtualServer.this.serverContext.getCommonClassLoader());
                }
            });
            loader.start();
            wmInfo.setAppClassLoader(loader);
            if (wbd.getApplication() == null) {
                Application application = Application.createApplication();
                application.setVirtual(true);
                application.setName("__default-web-module");
                wbd.setApplication(application);
            }
        }
        return wmInfo;
    }

    protected String getDefaultWebModuleID() {
        String wmID = this.vsBean.getDefaultWebModule();
        if ("".equals(wmID)) {
            wmID = null;
        }
        if (wmID != null && this._logger.isLoggable(Level.FINE)) {
            Object[] params = new Object[]{wmID, this._id};
            this._logger.log(Level.FINE, VS_DEFAULT_WEB_MODULE, params);
        }
        return wmID;
    }

    protected WebModuleConfig findWebModuleInJ2eeApp(Applications appsBean, String id, ApplicationRegistry appRegistry) {
        WebModuleConfig wmInfo = null;
        int separatorIndex = id.indexOf(":");
        if (separatorIndex == -1) {
            separatorIndex = id.indexOf(35);
        }
        if (separatorIndex != -1) {
            String appID = id.substring(0, separatorIndex);
            String moduleID = id.substring(separatorIndex + 1);
            com.sun.enterprise.config.serverbeans.Application appBean = appsBean.getModule(com.sun.enterprise.config.serverbeans.Application.class, appID);
            if (appBean != null && Boolean.valueOf(appBean.getEnabled()).booleanValue()) {
                String location = appBean.getLocation();
                String moduleDir = DeploymentUtils.getRelativeEmbeddedModulePath(location, moduleID);
                ApplicationInfo appInfo = appRegistry.get(appID);
                Application app = null;
                if (appInfo == null) {
                    Object[] params = new Object[]{id, this.getID()};
                    this._logger.log(Level.SEVERE, VS_DEFAULT_WEB_MODULE_DISABLED, params);
                    return wmInfo;
                }
                app = appInfo.getMetaData(Application.class);
                WebBundleDescriptorImpl wbd = app.getModuleByTypeAndUri(WebBundleDescriptorImpl.class, moduleID);
                String webUri = wbd.getModuleDescriptor().getArchiveUri();
                String contextRoot = wbd.getModuleDescriptor().getContextRoot();
                if (moduleID.equals(webUri)) {
                    StringBuilder dir = new StringBuilder(location);
                    dir.append(File.separator);
                    dir.append(moduleDir);
                    File docroot = new File(dir.toString());
                    wmInfo = new WebModuleConfig();
                    wbd.setName(moduleID);
                    wbd.setContextRoot(contextRoot);
                    wmInfo.setDescriptor(wbd);
                    wmInfo.setLocation(docroot);
                    wmInfo.setParentLoader(EmbeddedWebContainer.class.getClassLoader());
                    WebappClassLoader cloader = AccessController.doPrivileged(new PrivilegedAction<WebappClassLoader>(){

                        @Override
                        public WebappClassLoader run() {
                            return new WebappClassLoader(EmbeddedWebContainer.class.getClassLoader());
                        }
                    });
                    wmInfo.setAppClassLoader(cloader);
                }
            } else {
                Object[] params = new Object[]{id, this.getID()};
                this._logger.log(Level.SEVERE, VS_DEFAULT_WEB_MODULE_DISABLED, params);
            }
        }
        return wmInfo;
    }

    public void clearAliases() {
        this.aliases = new String[0];
    }

    private void setIsDisabled(boolean isDisabled) {
        this.vsPipeline.setIsDisabled(isDisabled);
        this.vsPipeline.setIsOff(false);
        if (isDisabled && this.pipeline != this.vsPipeline) {
            this.setPipeline(this.vsPipeline);
        }
    }

    private void setIsOff(boolean isOff) {
        this.vsPipeline.setIsOff(isOff);
        this.vsPipeline.setIsDisabled(false);
        if (isOff && this.pipeline != this.vsPipeline) {
            this.setPipeline(this.vsPipeline);
        }
    }

    private void close(FileLoggerHandler handler) {
        if (handler != null && !handler.isAssociated()) {
            if (this.fileLoggerHandlerFactory != null) {
                this.fileLoggerHandlerFactory.removeHandler(handler.getLogFile());
            }
            handler.flush();
            handler.close();
        }
    }

    private void setLogger(Logger newLogger, String logLevel) {
        this._logger = newLogger;
        CatalinaLogger catalinaLogger = new CatalinaLogger(newLogger);
        catalinaLogger.setLevel(logLevel);
        this.setLogger(catalinaLogger);
    }

    List<Property> getProperties() {
        return this.vsBean.getProperty();
    }

    public void configure(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String vsDocroot, String vsLogFile, MimeMap vsMimeMap, String logServiceFile, String logLevel) {
        this.setDebug(this.debug);
        this.setAppBase(vsDocroot);
        this.setName(vsID);
        this.setID(vsID);
        this.setBean(vsBean);
        this.setMimeMap(vsMimeMap);
        String defaultContextXmlLocation = "config/context.xml";
        String defaultWebXmlLocation = "config/default-web.xml";
        Property prop = vsBean.getProperty("default-web-xml");
        if (prop != null) {
            defaultWebXmlLocation = prop.getValue();
        }
        boolean allowLinking = false;
        prop = vsBean.getProperty("allowLinking");
        if (prop != null) {
            allowLinking = Boolean.parseBoolean(prop.getValue());
        }
        this.setAllowLinking(allowLinking);
        prop = vsBean.getProperty("contextXmlDefault");
        if (prop != null) {
            defaultContextXmlLocation = prop.getValue();
        }
        this.setDefaultWebXmlLocation(defaultWebXmlLocation);
        this.setDefaultContextXmlLocation(defaultContextXmlLocation);
        String state = vsBean.getState();
        if (state == null) {
            state = ON;
        }
        if (DISABLED.equalsIgnoreCase(state)) {
            this.setIsActive(false);
        } else {
            this.setIsActive(Boolean.parseBoolean(state));
        }
        this.setLogFile(vsLogFile, logLevel, logServiceFile);
    }

    protected void configureCatalinaProperties() {
        List<Property> props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                this._logger.log(Level.WARNING, NULL_VIRTUAL_SERVER_PROPERTY, this.getName());
            }
            if (propName == null) continue;
            if (propName.startsWith("valve_")) {
                this.addValve(propValue);
                continue;
            }
            if (propName.startsWith("listener_")) {
                this.addListener(propValue);
                continue;
            }
            if (!propName.equals("securePagesWithPragma")) continue;
            this.setSecurePagesWithPragma(Boolean.valueOf(propValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    synchronized void setLogFile(String logFile, String logLevel, String logServiceFile) {
        boolean noCustomLog;
        boolean bl = noCustomLog = logFile == null || logServiceFile != null && new File(logFile).equals(new File(logServiceFile));
        if (this.fileLoggerHandler == null) {
            if (noCustomLog) return;
        }
        if (this.fileLoggerHandler != null && logFile != null && logFile.equals(this.fileLoggerHandler.getLogFile())) {
            return;
        }
        Logger newLogger = null;
        FileLoggerHandler oldHandler = this.fileLoggerHandler;
        if (oldHandler != null) {
            this._logger.removeHandler(oldHandler);
        }
        if (noCustomLog) {
            this.fileLoggerHandler = null;
            newLogger = this._logger;
        } else {
            Handler[] rootHandlers;
            Logger rootLogger;
            Handler[] handlers;
            String lname = this._logger.getName() + "._vs." + this.getID();
            newLogger = LogManager.getLogManager().getLogger(lname);
            if (newLogger == null) {
                newLogger = new Logger(lname, null){

                    @Override
                    public void log(LogRecord record) {
                        ResourceBundle bundle2;
                        if (record.getResourceBundle() == null && (bundle2 = this.getResourceBundle()) != null) {
                            record.setResourceBundle(bundle2);
                        }
                        record.setThreadID((int)Thread.currentThread().getId());
                        super.log(record);
                    }

                    @Override
                    public ResourceBundle getResourceBundle() {
                        return rb;
                    }

                    @Override
                    public synchronized void addHandler(Handler handler) {
                        super.addHandler(handler);
                        if (handler instanceof FileLoggerHandler) {
                            ((FileLoggerHandler)handler).associate();
                        }
                    }

                    @Override
                    public synchronized void removeHandler(Handler handler) {
                        if (!(handler instanceof FileLoggerHandler)) {
                            super.removeHandler(handler);
                        } else {
                            boolean hasHandler = false;
                            Handler[] hs = this.getHandlers();
                            if (hs != null) {
                                for (Handler h : hs) {
                                    if (h != handler) continue;
                                    hasHandler = true;
                                    break;
                                }
                            }
                            if (hasHandler) {
                                super.removeHandler(handler);
                                ((FileLoggerHandler)handler).disassociate();
                            }
                        }
                    }
                };
                Class<Logger> clazz = Logger.class;
                // MONITORENTER : java.util.logging.Logger.class
                LogManager.getLogManager().addLogger(newLogger);
                // MONITOREXIT : clazz
            }
            if ((handlers = newLogger.getHandlers()) != null) {
                for (Handler h : handlers) {
                    newLogger.removeHandler(h);
                }
            }
            if ((rootLogger = Logger.global.getParent()) != null && (rootHandlers = rootLogger.getHandlers()) != null) {
                for (Handler h : rootHandlers) {
                    if (h instanceof GFFileHandler) continue;
                    newLogger.addHandler(h);
                }
            }
            this.fileLoggerHandler = this.fileLoggerHandlerFactory.getHandler(logServiceFile);
            newLogger.addHandler(this.fileLoggerHandler);
            newLogger.setUseParentHandlers(false);
        }
        this.setLogger(newLogger, logLevel);
        this.close(oldHandler);
    }

    void configureAliases() {
        List<String> hosts = StringUtils.parseStringList(this.vsBean.getHosts(), ",");
        for (int i = 0; i < hosts.size(); ++i) {
            String alias = hosts.get(i).toString();
            if (alias.equalsIgnoreCase("localhost") || alias.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(alias);
        }
    }

    void configureAliases(String ... hosts) {
        for (String host : hosts) {
            if (host.equalsIgnoreCase("localhost") || host.equalsIgnoreCase("localhost.localdomain")) continue;
            this.addAlias(host);
        }
    }

    void configureAuthRealm(SecurityService securityService) {
        List<Property> properties = this.vsBean.getProperty();
        if (properties != null && properties.size() > 0) {
            for (Property p : properties) {
                if (p == null || !"authRealm".equals(p.getName())) continue;
                this.authRealmName = p.getValue();
                if (this.authRealmName == null) break;
                AuthRealm realm = null;
                List<AuthRealm> rs = securityService.getAuthRealm();
                if (rs != null && rs.size() > 0) {
                    for (AuthRealm r : rs) {
                        if (r == null || !r.getName().equals(this.authRealmName)) continue;
                        realm = r;
                        break;
                    }
                }
                if (realm != null) break;
                this._logger.log(Level.SEVERE, INVALID_AUTH_REALM, new Object[]{this.getID(), this.authRealmName});
                break;
            }
        }
    }

    String getAuthRealmName() {
        return this.authRealmName;
    }

    protected void addValve(String valveName) {
        Object valve = this.safeLoadInstance(valveName);
        if (valve instanceof Valve) {
            this.addValve((Valve)valve);
        } else if (valve instanceof GlassFishValve) {
            this.addValve((GlassFishValve)valve);
        } else {
            this._logger.log(Level.WARNING, NOT_A_VALVE, valveName);
        }
    }

    protected void addListener(String listenerName) {
        Object listener = this.safeLoadInstance(listenerName);
        if (listener == null) {
            return;
        }
        if (listener instanceof ContainerListener) {
            this.addContainerListener((ContainerListener)listener);
        } else if (listener instanceof LifecycleListener) {
            this.addLifecycleListener((LifecycleListener)listener);
        } else {
            this._logger.log(Level.SEVERE, INVALID_LISTENER, new Object[]{listenerName, this.getID()});
        }
    }

    @Override
    protected Object loadInstance(String className) throws Exception {
        Class<?> clazz = this.serverContext.getCommonClassLoader().loadClass(className);
        return clazz.newInstance();
    }

    private Object safeLoadInstance(String className) {
        try {
            return this.loadInstance(className);
        }
        catch (Throwable ex) {
            this._logger.log(Level.SEVERE, UNABLE_TO_LOAD_EXTENSION, ex);
            return null;
        }
    }

    void configureErrorPage() {
        ErrorPage errorPage = null;
        List<Property> props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                this._logger.log(Level.WARNING, NULL_VIRTUAL_SERVER_PROPERTY, this.getID());
                continue;
            }
            if (!propName.startsWith("send-error_")) continue;
            String path = null;
            String reason = null;
            String status = null;
            String[] errorParams = propValue.split(" ");
            for (int j = 0; j < errorParams.length; ++j) {
                if (errorParams[j].startsWith("path=")) {
                    if (path != null) {
                        this._logger.log(Level.WARNING, SEND_ERROR_MULTIPLE_ELEMENT, new Object[]{propValue, this.getID(), "path"});
                    }
                    path = errorParams[j].substring("path=".length());
                }
                if (errorParams[j].startsWith("reason=")) {
                    if (reason != null) {
                        this._logger.log(Level.WARNING, SEND_ERROR_MULTIPLE_ELEMENT, new Object[]{propValue, this.getID(), "reason"});
                    }
                    reason = errorParams[j].substring("reason=".length());
                }
                if (!errorParams[j].startsWith("code=")) continue;
                if (status != null) {
                    this._logger.log(Level.WARNING, SEND_ERROR_MULTIPLE_ELEMENT, new Object[]{propValue, this.getID(), "code"});
                }
                status = errorParams[j].substring("code=".length());
            }
            if (path == null || path.length() == 0) {
                this._logger.log(Level.WARNING, SEND_ERROR_MISSING_PATH, new Object[]{propValue, this.getID()});
            }
            errorPage = new ErrorPage();
            errorPage.setLocation(path);
            errorPage.setErrorCode(status);
            errorPage.setReason(reason);
            this.addErrorPage(errorPage);
        }
    }

    void configureRedirect() {
        this.vsPipeline.clearRedirects();
        List<Property> props = this.vsBean.getProperty();
        if (props == null) {
            return;
        }
        for (Property prop : props) {
            String propName = prop.getName();
            String propValue = prop.getValue();
            if (propName == null || propValue == null) {
                this._logger.log(Level.WARNING, NULL_VIRTUAL_SERVER_PROPERTY, this.getID());
                continue;
            }
            if (!propName.startsWith("redirect_")) continue;
            String from = null;
            String url = null;
            String urlPrefix = null;
            String escape = null;
            String[] redirectParams = propValue.split(" ");
            for (int j = 0; j < redirectParams.length; ++j) {
                if (redirectParams[j].startsWith("from=")) {
                    if (from != null) {
                        this._logger.log(Level.WARNING, REDIRECT_MULTIPLE_ELEMENT, new Object[]{propValue, this.getID(), "from"});
                    }
                    from = redirectParams[j].substring("from=".length());
                }
                if (redirectParams[j].startsWith("url=")) {
                    if (url != null) {
                        this._logger.log(Level.WARNING, REDIRECT_MULTIPLE_ELEMENT, new Object[]{propValue, this.getID(), "url"});
                    }
                    url = redirectParams[j].substring("url=".length());
                }
                if (redirectParams[j].startsWith("url-prefix=")) {
                    if (urlPrefix != null) {
                        this._logger.log(Level.WARNING, REDIRECT_MULTIPLE_ELEMENT, new Object[]{propValue, this.getID(), "url-prefix"});
                    }
                    urlPrefix = redirectParams[j].substring("url-prefix=".length());
                }
                if (!redirectParams[j].startsWith("escape=")) continue;
                if (escape != null) {
                    this._logger.log(Level.WARNING, REDIRECT_MULTIPLE_ELEMENT, new Object[]{propValue, this.getID(), "escape"});
                }
                escape = redirectParams[j].substring("escape=".length());
            }
            if (from == null || from.length() == 0) {
                this._logger.log(Level.WARNING, REDIRECT_MULTIPLE_ELEMENT, new Object[]{propValue, this.getID()});
            }
            if (!(url != null && url.length() != 0 || urlPrefix != null && urlPrefix.length() != 0)) {
                this._logger.log(Level.WARNING, REDIRECT_MISSING_URL_OR_URL_PREFIX, new Object[]{propValue, this.getID()});
            }
            if (url != null && url.length() > 0 && urlPrefix != null && urlPrefix.length() > 0) {
                this._logger.log(Level.WARNING, REDIRECT_BOTH_URL_AND_URL_PREFIX, new Object[]{propValue, this.getID()});
            }
            boolean escapeURI = true;
            if (escape != null) {
                if ("yes".equalsIgnoreCase(escape)) {
                    escapeURI = true;
                } else if ("no".equalsIgnoreCase(escape)) {
                    escapeURI = false;
                } else {
                    this._logger.log(Level.WARNING, REDIRECT_INVALID_ESCAPE, new Object[]{propValue, this.getID()});
                }
            }
            this.vsPipeline.addRedirect(from, url, urlPrefix, escapeURI);
        }
        if (this.vsPipeline.hasRedirects()) {
            if (this.pipeline != this.vsPipeline) {
                this.setPipeline(this.vsPipeline);
            }
        } else if (this.isActive && this.pipeline != this.origPipeline) {
            this.setPipeline(this.origPipeline);
        }
    }

    void configureSingleSignOn(boolean globalSSOEnabled, WebContainerFeatureFactory webContainerFeatureFactory, boolean ssoFailoverEnabled) {
        if (!this.isSSOEnabled(globalSSOEnabled)) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, DISABLE_SSO, this.getID());
            }
            boolean hasExistingSSO = false;
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.removeValve(valves[i]);
                hasExistingSSO = true;
                break;
            }
            this.ssoFailoverEnabled = ssoFailoverEnabled;
            if (hasExistingSSO) {
                this.setSingleSignOnForChildren(null);
            }
        } else {
            Property expireTime;
            Property idle;
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, ENABLE_SSO, this.getID());
            }
            GlassFishSingleSignOn sso = null;
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof GlassFishSingleSignOn)) continue;
                sso = (GlassFishSingleSignOn)valves[i];
                break;
            }
            if (sso != null && this.ssoFailoverEnabled != ssoFailoverEnabled) {
                this.removeValve(sso);
                sso = null;
            }
            if (sso == null) {
                SSOFactory ssoFactory = webContainerFeatureFactory.getSSOFactory();
                sso = ssoFactory.createSingleSignOnValve(this.getName());
                this.ssoFailoverEnabled = ssoFailoverEnabled;
                this.setSingleSignOnForChildren(sso);
                this.addValve(sso);
            }
            if ((idle = this.vsBean.getProperty(SSO_MAX_IDLE)) != null && idle.getValue() != null) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, SSO_MAX_INACTIVE_SET, new Object[]{idle.getValue(), this.getID()});
                }
                sso.setMaxInactive(Integer.parseInt(idle.getValue()));
            }
            if ((expireTime = this.vsBean.getProperty(SSO_REAP_INTERVAL)) != null && expireTime.getValue() != null) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, SSO_REAP_INTERVAL_SET);
                }
                sso.setReapInterval(Integer.parseInt(expireTime.getValue()));
            }
            this.configureSingleSignOnCookieSecure();
            this.configureSingleSignOnCookieHttpOnly();
        }
    }

    void configureState() {
        String stateValue = this.vsBean.getState();
        if (!stateValue.equalsIgnoreCase(ON) && this.getName().equalsIgnoreCase("__asadmin")) {
            throw new IllegalArgumentException("virtual-server __asadmin state property cannot be modified");
        }
        if (stateValue.equalsIgnoreCase(DISABLED)) {
            this.setIsDisabled(true);
        } else if (!ConfigBeansUtilities.toBoolean(stateValue)) {
            this.setIsOff(true);
        } else {
            this.setIsActive(true);
        }
    }

    void configureRemoteAddressFilterValve() {
        Property allow = this.vsBean.getProperty("allowRemoteAddress");
        Property deny = this.vsBean.getProperty("denyRemoteAddress");
        String allowStr = null;
        String denyStr = null;
        if (allow != null) {
            allowStr = allow.getValue();
        }
        if (deny != null) {
            denyStr = deny.getValue();
        }
        this.configureRemoteAddressFilterValve(allowStr, denyStr);
    }

    protected void configureRemoteAddressFilterValve(String allow, String deny) {
        RemoteAddrValve remoteAddrValve = null;
        if (allow != null || deny != null) {
            remoteAddrValve = new RemoteAddrValve();
        }
        if (allow != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, ALLOW_ACCESS, new Object[]{this.getID(), allow});
            }
            remoteAddrValve.setAllow(allow);
        }
        if (deny != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, DENY_ACCESS, new Object[]{this.getID(), deny});
            }
            remoteAddrValve.setDeny(deny);
        }
        if (remoteAddrValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteAddrValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve(remoteAddrValve);
        }
    }

    void configureRemoteHostFilterValve() {
        Property allow = this.vsBean.getProperty("allowRemoteHost");
        Property deny = this.vsBean.getProperty("denyRemoteHost");
        String allowStr = null;
        String denyStr = null;
        if (allow != null) {
            allowStr = allow.getValue();
        }
        if (deny != null) {
            denyStr = deny.getValue();
        }
        this.configureRemoteHostFilterValve(allowStr, denyStr);
    }

    void configureRemoteHostFilterValve(String allow, String deny) {
        RemoteHostValve remoteHostValve = null;
        if (allow != null || deny != null) {
            remoteHostValve = new RemoteHostValve();
        }
        if (allow != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, ALLOW_ACCESS, new Object[]{this.getID(), allow});
            }
            remoteHostValve.setAllow(allow);
        }
        if (deny != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, DENY_ACCESS, new Object[]{this.getID(), deny});
            }
            remoteHostValve.setDeny(deny);
        }
        if (remoteHostValve != null) {
            GlassFishValve[] valves = this.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteHostValve)) continue;
                this.removeValve(valves[i]);
                break;
            }
            this.addValve(remoteHostValve);
        }
    }

    void addProbes(boolean globalAccessLoggingEnabled) {
        List<String> listenerList = StringUtils.parseStringList(this.vsBean.getNetworkListeners(), ",");
        String[] listeners = listenerList != null ? listenerList.toArray(new String[listenerList.size()]) : new String[]{};
        ArrayList<NetworkListener> networkListeners = new ArrayList<NetworkListener>();
        for (String listener : listeners) {
            for (NetworkListener networkListener : this.serverConfig.getNetworkConfig().getNetworkListeners().getNetworkListener()) {
                if (!networkListener.getName().equals(listener)) continue;
                networkListeners.add(networkListener);
            }
        }
        for (NetworkListener listener : networkListeners) {
            try {
                GrizzlyProxy proxy = (GrizzlyProxy)this.grizzlyService.lookupNetworkProxy(listener);
                if (proxy != null) {
                    GenericGrizzlyListener grizzlyListener = (GenericGrizzlyListener)proxy.getUnderlyingListener();
                    List<HttpCodecFilter> codecFilters = grizzlyListener.getFilters(HttpCodecFilter.class);
                    if (codecFilters == null || codecFilters.isEmpty()) {
                        if (grizzlyListener.isAjpEnabled()) continue;
                        this._logger.log(Level.SEVERE, CODE_FILTERS_NULL, new Object[]{listener.getName(), codecFilters});
                    } else {
                        for (HttpCodecFilter codecFilter : codecFilters) {
                            if (codecFilter.getMonitoringConfig().getProbes().length != 0) continue;
                            this.httpProbe = new HttpProbeImpl(listener, this.isAccessLoggingEnabled(globalAccessLoggingEnabled));
                            codecFilter.getMonitoringConfig().addProbes((HttpProbe[])new HttpProbe[]{this.httpProbe});
                        }
                    }
                    grizzlyListener.getTransport().getConnectionMonitoringConfig().addProbes((ConnectionProbe[])new ConnectionProbe[]{new ConnectionProbe.Adapter(){
                        RequestProbeProvider requestProbeProvider;
                        {
                            this.requestProbeProvider = VirtualServer.this.webContainer.getRequestProbeProvider();
                        }

                        @Override
                        public void onReadEvent(Connection connection, Buffer data, int size) {
                            if (this.requestProbeProvider != null) {
                                this.requestProbeProvider.dataReceivedEvent(size);
                            }
                        }

                        @Override
                        public void onWriteEvent(Connection connection, Buffer data, long size) {
                            if (this.requestProbeProvider != null) {
                                this.requestProbeProvider.dataSentEvent(size);
                            }
                        }
                    }});
                    continue;
                }
                this._logger.log(Level.SEVERE, PROXY_NULL, new Object[]{listener.getName()});
            }
            catch (Exception ex) {
                this._logger.log(Level.SEVERE, ADD_HTTP_PROBES_ERROR, ex);
            }
        }
    }

    void reconfigureAccessLog(String globalAccessLogBufferSize, String globalAccessLogWriteInterval, ServiceLocator services, Domain domain, boolean globalAccessLoggingEnabled) {
        try {
            boolean start;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
            }
            if ((start = this.accessLogValve.updateVirtualServerProperties(this.vsBean.getId(), this.vsBean, domain, services, globalAccessLogBufferSize, globalAccessLogWriteInterval)) && this.isAccessLoggingEnabled(globalAccessLoggingEnabled)) {
                this.enableAccessLogging();
            } else {
                this.disableAccessLogging();
            }
        }
        catch (LifecycleException le) {
            this._logger.log(Level.SEVERE, UNABLE_RECONFIGURE_ACCESS_LOG, le);
        }
    }

    void reconfigureAccessLog(HttpService httpService, WebContainerFeatureFactory webcontainerFeatureFactory) {
        try {
            boolean restart = false;
            if (this.accessLogValve.isStarted()) {
                this.accessLogValve.stop();
                restart = true;
            }
            this.accessLogValve.updateAccessLogAttributes(httpService, webcontainerFeatureFactory);
            if (restart) {
                this.accessLogValve.start();
                if (this.httpProbe != null) {
                    this.httpProbe.enableAccessLogging();
                }
            }
        }
        catch (LifecycleException le) {
            this._logger.log(Level.SEVERE, UNABLE_RECONFIGURE_ACCESS_LOG, le);
        }
    }

    PEAccessLogValve getAccessLogValve() {
        return this.accessLogValve;
    }

    void enableAccessLogging() {
        if (!this.isAccessLogValveActivated()) {
            this.addValve(this.accessLogValve);
        } else {
            try {
                if (this.accessLogValve.isStarted()) {
                    this.accessLogValve.stop();
                }
                this.accessLogValve.start();
                if (this.httpProbe != null) {
                    this.httpProbe.enableAccessLogging();
                }
            }
            catch (LifecycleException le) {
                this._logger.log(Level.SEVERE, UNABLE_RECONFIGURE_ACCESS_LOG, le);
            }
        }
    }

    void disableAccessLogging() {
        this.removeValve(this.accessLogValve);
        if (this.httpProbe != null) {
            this.httpProbe.disableAccessLogging();
        }
    }

    private boolean isAccessLogValveActivated() {
        GlassFishValve[] valves;
        Pipeline p = this.getPipeline();
        if (p != null && (valves = p.getValves()) != null) {
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof PEAccessLogValve)) continue;
                return true;
            }
        }
        return false;
    }

    void configureCacheControl(String cacheControl) {
        List<String> values;
        if (cacheControl != null && (values = StringUtils.parseStringList(cacheControl, ",")) != null && !values.isEmpty()) {
            this.setCacheControls(values.toArray(new String[values.size()]));
        }
    }

    private boolean isSSOEnabled(boolean globalSSOEnabled) {
        String ssoEnabled = "inherit";
        if (this.vsBean != null) {
            ssoEnabled = this.vsBean.getSsoEnabled();
        }
        return "inherit".equals(ssoEnabled) && globalSSOEnabled || ConfigBeansUtilities.toBoolean(ssoEnabled);
    }

    private void setSingleSignOnForChildren(SingleSignOn sso) {
        block0: for (Container container : this.findChildren()) {
            if (!(container instanceof StandardContext)) continue;
            StandardContext context = (StandardContext)container;
            for (GlassFishValve valve : context.getValves()) {
                if (!(valve instanceof AuthenticatorBase)) continue;
                ((AuthenticatorBase)valve).setSingleSignOn(sso);
                continue block0;
            }
        }
    }

    boolean isAccessLoggingEnabled(boolean globalAccessLoggingEnabled) {
        String enabled = this.vsBean.getAccessLoggingEnabled();
        return "inherit".equals(enabled) && globalAccessLoggingEnabled || ConfigBeansUtilities.toBoolean(enabled);
    }

    @Override
    public void setRealm(Realm realm) {
        if (realm != null && !(realm instanceof RealmAdapter)) {
            this._logger.log(Level.SEVERE, IGNORE_INVALID_REALM, new Object[]{realm.getClass().getName(), RealmAdapter.class.getName()});
        } else {
            super.setRealm(realm);
        }
    }

    private void configureSingleSignOnCookieSecure() {
        String cookieSecure = this.vsBean.getSsoCookieSecure();
        if (!("true".equalsIgnoreCase(cookieSecure) || "false".equalsIgnoreCase(cookieSecure) || cookieSecure.equalsIgnoreCase("dynamic"))) {
            this._logger.log(Level.WARNING, INVALID_SSO_COOKIE_SECURE, new Object[]{cookieSecure, this.getID()});
        } else {
            this.ssoCookieSecure = cookieSecure;
        }
    }

    private void configureSingleSignOnCookieHttpOnly() {
        this.ssoCookieHttpOnly = Boolean.parseBoolean(this.vsBean.getSsoCookieHttpOnly());
    }

    void configureErrorReportValve() {
        Property prop = this.vsBean.getProperty("errorReportValve");
        if (prop != null) {
            this.setErrorReportValveClass(prop.getValue());
        }
    }

    void setServerContext(ServerContext serverContext) {
        this.serverContext = serverContext;
    }

    void setServerConfig(Config serverConfig) {
        this.serverConfig = serverConfig;
    }

    void setGrizzlyService(GrizzlyService grizzlyService) {
        this.grizzlyService = grizzlyService;
    }

    void setWebContainer(WebContainer webContainer) {
        this.webContainer = webContainer;
    }

    @Override
    public void setDocRoot(File docRoot) {
        this.setAppBase(docRoot.getPath());
    }

    @Override
    public File getDocRoot() {
        return new File(this.getAppBase());
    }

    public void setWebListeners(WebListener ... webListeners) {
        if (webListeners != null) {
            this.listeners = Arrays.asList(webListeners);
        }
    }

    @Override
    public Collection<WebListener> getWebListeners() {
        return this.listeners;
    }

    @Override
    public void addContext(Context context, String contextRoot) throws ConfigException, GlassFishException {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, VS_ADDED_CONTEXT);
        }
        if (!(context instanceof ContextFacade)) {
            return;
        }
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        ExtendedDeploymentContext deploymentContext = null;
        try {
            WebModule wm;
            ArchiveHandler archiveHandler;
            if (this.factory == null) {
                this.factory = this.services.getService(ArchiveFactory.class, new Annotation[0]);
            }
            ContextFacade facade = (ContextFacade)context;
            File docRoot = facade.getDocRoot();
            ClassLoader classLoader = facade.getClassLoader();
            ReadableArchive archive = this.factory.openArchive(docRoot);
            if (this.report == null) {
                this.report = new PlainTextActionReporter();
            }
            ServerEnvironment env = this.services.getService(ServerEnvironment.class, new Annotation[0]);
            DeployCommandParameters params = new DeployCommandParameters();
            params.contextroot = contextRoot;
            params.enabled = Boolean.FALSE;
            params.origin = OpsParams.Origin.deploy;
            params.virtualservers = this.getName();
            params.target = "server";
            DeploymentContextImpl initialContext = new DeploymentContextImpl(this.report, archive, params, env);
            if (this.deployment == null) {
                this.deployment = this.services.getService(Deployment.class, new Annotation[0]);
            }
            if ((archiveHandler = this.deployment.getArchiveHandler(archive)) == null) {
                throw new RuntimeException("Cannot find archive handler for source archive");
            }
            params.name = archiveHandler.getDefaultApplicationName(archive, initialContext);
            Applications apps = this.domain.getApplications();
            ApplicationInfo appInfo = this.deployment.get(params.name);
            ApplicationRef appRef = this.domain.getApplicationRefInServer(params.target, params.name);
            if (appInfo != null && appRef != null) {
                if (appRef.getVirtualServers().contains(this.getName())) {
                    throw new ConfigException("Context with name " + params.name + " is already registered on virtual server " + this.getName());
                }
                String virtualServers = appRef.getVirtualServers();
                params.virtualservers = virtualServers = virtualServers + "," + this.getName();
                params.force = Boolean.TRUE;
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Virtual server " + this.getName() + " added to context " + params.name);
                }
                return;
            }
            deploymentContext = this.deployment.getBuilder(this._logger, params, this.report).source(archive).archiveHandler(archiveHandler).build(initialContext);
            Properties properties = new Properties();
            deploymentContext.getAppProps().putAll((Map<?, ?>)properties);
            if (classLoader != null) {
                ClassLoader parentCL = this.clh.createApplicationParentCL(classLoader, deploymentContext);
                ClassLoader cl = archiveHandler.getClassLoader(parentCL, deploymentContext);
                deploymentContext.setClassLoader(cl);
            }
            ApplicationConfigInfo savedAppConfig = new ApplicationConfigInfo(apps.getModule(com.sun.enterprise.config.serverbeans.Application.class, params.name));
            Properties appProps = deploymentContext.getAppProps();
            String appLocation = DeploymentUtils.relativizeWithinDomainIfPossible(deploymentContext.getSource().getURI());
            appProps.setProperty("location", appLocation);
            appProps.setProperty("object-type", "user");
            appProps.setProperty("context-root", contextRoot);
            savedAppConfig.store(appProps);
            Transaction t = this.deployment.prepareAppConfigChanges(deploymentContext);
            appInfo = this.deployment.deploy(deploymentContext);
            if (appInfo != null) {
                facade.setAppName(appInfo.getName());
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, VS_ADDED_CONTEXT, new Object[]{this.getName(), appInfo.getName()});
                }
                this.deployment.registerAppInDomainXML(appInfo, deploymentContext, t);
            } else if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                throw new ConfigException(this.report.getMessage());
            }
            File file = null;
            boolean delete = true;
            com.sun.enterprise.config.serverbeans.Application appBean = apps.getApplication(params.name);
            if (appBean != null) {
                file = new File(deploymentContext.getSource().getURI().getPath(), "/WEB-INF/web.xml");
                if (file.exists()) {
                    delete = false;
                }
                this.updateWebXml(facade, file);
            } else {
                this._logger.log(Level.SEVERE, APP_NOT_FOUND);
            }
            ReadableArchive source = appInfo.getSource();
            UndeployCommandParameters undeployParams = new UndeployCommandParameters(params.name);
            undeployParams.origin = OpsParams.Origin.undeploy;
            undeployParams.target = "server";
            ExtendedDeploymentContext undeploymentContext = this.deployment.getBuilder(this._logger, undeployParams, this.report).source(source).build();
            this.deployment.undeploy(params.name, undeploymentContext);
            params.origin = OpsParams.Origin.load;
            params.enabled = Boolean.TRUE;
            archive = this.factory.openArchive(docRoot);
            deploymentContext = this.deployment.getBuilder(this._logger, params, this.report).source(archive).build();
            if (classLoader != null) {
                ClassLoader parentCL = this.clh.createApplicationParentCL(classLoader, deploymentContext);
                archiveHandler = this.deployment.getArchiveHandler(archive);
                ClassLoader cl = archiveHandler.getClassLoader(parentCL, deploymentContext);
                deploymentContext.setClassLoader(cl);
            }
            this.deployment.deploy(deploymentContext);
            this.deployment.updateAppEnabledAttributeInDomainXML(params.name, params.target, true);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, VS_ENABLED_CONTEXT, new Object[]{this.getName(), params.name()});
            }
            if (delete && file != null && file.exists() && !file.delete()) {
                String path = file.toString();
                this._logger.log(Level.WARNING, UNABLE_TO_DELETE, path);
            }
            if (contextRoot.equals("/")) {
                contextRoot = "";
            }
            if ((wm = (WebModule)this.findChild(contextRoot)) != null) {
                facade.setUnwrappedContext(wm);
                wm.setEmbedded(true);
                if (this.config != null) {
                    wm.setDefaultWebXml(this.config.getDefaultWebXml());
                }
            } else {
                throw new ConfigException("Deployed app not found " + contextRoot);
            }
            if (deploymentContext != null) {
                deploymentContext.postDeployClean(true);
            }
        }
        catch (Exception ex) {
            if (this.deployment != null && deploymentContext != null) {
                deploymentContext.clean();
            }
            throw new GlassFishException(ex);
        }
    }

    @Override
    public void removeContext(Context context) throws GlassFishException {
        String name;
        ActionReport report = this.services.getService(ActionReport.class, "plain", new Annotation[0]);
        Deployment deployment = this.services.getService(Deployment.class, new Annotation[0]);
        ApplicationInfo appInfo = deployment.get(name = context instanceof ContextFacade ? ((ContextFacade)context).getAppName() : context.getPath());
        if (appInfo == null) {
            report.setMessage("Cannot find deployed application of name " + name);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new GlassFishException("Cannot find deployed application of name " + name);
        }
        ReadableArchive source = appInfo.getSource();
        if (source == null) {
            report.setMessage("Cannot get source archive for undeployment");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new GlassFishException("Cannot get source archive for undeployment");
        }
        UndeployCommandParameters params = new UndeployCommandParameters(name);
        params.origin = OpsParams.Origin.undeploy;
        params.target = "server";
        ExtendedDeploymentContext deploymentContext = null;
        try {
            deploymentContext = deployment.getBuilder(this._logger, params, report).source(source).build();
            deployment.undeploy(name, deploymentContext);
            deployment.unregisterAppFromDomainXML(name, "server");
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, REMOVE_CONTEXT_ERROR, e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new GlassFishException("Cannot create context for undeployment ", e);
        }
        catch (TransactionFailure e) {
            throw new GlassFishException(e);
        }
        finally {
            if (deploymentContext != null) {
                deploymentContext.clean();
            }
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, REMOVED_CONTEXT, name);
        }
    }

    @Override
    public Context getContext(String contextRoot) {
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        return (Context)((Object)this.findChild(contextRoot));
    }

    @Override
    public Collection<Context> getContexts() {
        ArrayList<Context> ctxs = new ArrayList<Context>();
        for (Container container : this.findChildren()) {
            if (!(container instanceof Context)) continue;
            ctxs.add((Context)((Object)container));
        }
        return ctxs;
    }

    @Override
    public void setConfig(VirtualServerConfig config) throws ConfigException {
        this.config = config;
        this.configureSingleSignOn(config.isSsoEnabled(), Globals.getDefaultHabitat().getService(PEWebContainerFeatureFactoryImpl.class, new Annotation[0]), false);
        if (config.isAccessLoggingEnabled()) {
            this.enableAccessLogging();
        } else {
            this.disableAccessLogging();
        }
        this.setDefaultWebXmlLocation(config.getDefaultWebXml());
        this.setDefaultContextXmlLocation(config.getContextXmlDefault());
        this.setAllowLinking(config.isAllowLinking());
        this.configureRemoteAddressFilterValve(config.getAllowRemoteAddress(), config.getDenyRemoteAddress());
        this.configureRemoteHostFilterValve(config.getAllowRemoteHost(), config.getAllowRemoteHost());
        this.configureAliases(config.getHostNames());
    }

    @Override
    public VirtualServerConfig getConfig() {
        return this.config;
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        if (this.fileLoggerHandler != null) {
            this._logger.removeHandler(this.fileLoggerHandler);
            this.close(this.fileLoggerHandler);
            this.fileLoggerHandler = null;
        }
        this.setLogger(this._logger, "INFO");
        super.stop();
    }

    public void updateWebXml(ContextFacade facade, File file) throws Exception {
        Map<String, String> servlets = facade.getAddedServlets();
        Map<String, String[]> mappings = facade.getServletMappings();
        List<String> listeners = facade.getListeners();
        Map<String, String> filters = facade.getAddedFilters();
        Map<String, String> servletNameFilterMappings = facade.getServletNameFilterMappings();
        Map<String, String> urlPatternFilterMappings = facade.getUrlPatternFilterMappings();
        if (!(filters.isEmpty() && listeners.isEmpty() && servlets.isEmpty())) {
            Node servletNode;
            NodeList servletList;
            Element servletName;
            Element filterMapping;
            Element paramValue;
            Element paramName;
            Element initParam;
            NodeList children;
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, MODIFYING_WEB_XML, file.getAbsolutePath());
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = null;
            Element webapp = null;
            if (file != null && file.exists()) {
                doc = dBuilder.parse(file);
                webapp = doc.getDocumentElement();
            } else {
                doc = dBuilder.newDocument();
                webapp = doc.createElement("web-app");
                webapp.setAttribute("xmln", "http://java.sun.com/xml/ns/j2ee");
                webapp.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                webapp.setAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd");
                webapp.setAttribute("version", "2.4");
                doc.appendChild(webapp);
            }
            boolean entryFound = false;
            for (Map.Entry<String, String> entry : filters.entrySet()) {
                NodeList filterList = doc.getElementsByTagName("filter-name");
                block1: for (int i = 0; i < filterList.getLength(); ++i) {
                    Node filterNode = filterList.item(i);
                    if (!entry.getKey().equals(filterNode.getTextContent()) || !filterNode.getParentNode().getNodeName().equals("filter")) continue;
                    children = filterNode.getParentNode().getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node filterClass = children.item(j);
                        if (!filterClass.getNodeName().equals("filter-class")) continue;
                        filterClass.setTextContent(entry.getValue().toString());
                        entryFound = true;
                        continue block1;
                    }
                }
                if (entryFound) continue;
                Element filter = doc.createElement("filter");
                Element filterName = doc.createElement("filter-name");
                filterName.setTextContent(entry.getKey().toString());
                filter.appendChild(filterName);
                Element filterClass = doc.createElement("filter-class");
                filterClass.setTextContent(entry.getValue().toString());
                filter.appendChild(filterClass);
                Map<String, String> initParams = facade.getFilterRegistration(entry.getKey().toString()).getInitParameters();
                if (initParams != null && !initParams.isEmpty()) {
                    initParam = doc.createElement("init-param");
                    for (Map.Entry<String, String> param : initParams.entrySet()) {
                        paramName = doc.createElement("param-name");
                        paramName.setTextContent(param.getKey().toString());
                        initParam.appendChild(paramName);
                        paramValue = doc.createElement("param-value");
                        paramValue.setTextContent(param.getValue().toString());
                        initParam.appendChild(paramValue);
                    }
                    filter.appendChild(initParam);
                }
                webapp.appendChild(filter);
            }
            for (Map.Entry<String, String> entry : servletNameFilterMappings.entrySet()) {
                filterMapping = doc.createElement("filter-mapping");
                Element filterName = doc.createElement("filter-name");
                filterName.setTextContent(entry.getKey().toString());
                filterMapping.appendChild(filterName);
                servletName = doc.createElement("servlet-name");
                servletName.setTextContent(entry.getValue().toString());
                filterMapping.appendChild(servletName);
                webapp.appendChild(filterMapping);
            }
            for (Map.Entry<String, String> entry : urlPatternFilterMappings.entrySet()) {
                filterMapping = doc.createElement("filter-mapping");
                Element filterName = doc.createElement("filter-name");
                filterName.setTextContent(entry.getKey().toString());
                filterMapping.appendChild(filterName);
                Element urlPattern = doc.createElement("url-pattern");
                urlPattern.setTextContent(entry.getValue().toString());
                filterMapping.appendChild(urlPattern);
                webapp.appendChild(filterMapping);
            }
            entryFound = false;
            for (Map.Entry<String, String> entry : servlets.entrySet()) {
                servletList = doc.getElementsByTagName("servlet-name");
                block7: for (int i = 0; i < servletList.getLength(); ++i) {
                    servletNode = servletList.item(i);
                    if (!entry.getKey().equals(servletNode.getTextContent()) || !servletNode.getParentNode().getNodeName().equals("servlet")) continue;
                    children = servletNode.getParentNode().getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node servletClass = children.item(j);
                        if (!servletClass.getNodeName().equals("servlet-class")) continue;
                        servletClass.setTextContent(entry.getValue().toString());
                        entryFound = true;
                        continue block7;
                    }
                }
                if (entryFound) continue;
                Element servlet = doc.createElement("servlet");
                servletName = doc.createElement("servlet-name");
                servletName.setTextContent(entry.getKey().toString());
                servlet.appendChild(servletName);
                Element servletClass = doc.createElement("servlet-class");
                servletClass.setTextContent(entry.getValue().toString());
                servlet.appendChild(servletClass);
                Map<String, String> initParams = facade.getServletRegistration(entry.getKey().toString()).getInitParameters();
                if (initParams != null && !initParams.isEmpty()) {
                    initParam = doc.createElement("init-param");
                    for (Map.Entry<String, String> param : initParams.entrySet()) {
                        paramName = doc.createElement("param-name");
                        paramName.setTextContent(param.getKey().toString());
                        initParam.appendChild(paramName);
                        paramValue = doc.createElement("param-value");
                        paramValue.setTextContent(param.getValue().toString());
                        initParam.appendChild(paramValue);
                    }
                    servlet.appendChild(initParam);
                }
                webapp.appendChild(servlet);
            }
            entryFound = false;
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                servletList = doc.getElementsByTagName("servlet-name");
                block11: for (int i = 0; i < servletList.getLength(); ++i) {
                    servletNode = servletList.item(i);
                    if (!entry.getKey().equals(servletNode.getTextContent()) || !servletNode.getParentNode().getNodeName().equals("servlet-mapping")) continue;
                    NodeList children2 = servletNode.getParentNode().getChildNodes();
                    for (int j = 0; j < children2.getLength(); ++j) {
                        Node urlPattern = children2.item(j);
                        if (!urlPattern.getNodeName().equals("url-pattern")) continue;
                        entryFound = true;
                        continue block11;
                    }
                }
                if (entryFound) continue;
                Element servletMapping = doc.createElement("servlet-mapping");
                for (String pattern : mappings.get(entry.getKey())) {
                    Element servletName2 = doc.createElement("servlet-name");
                    servletName2.setTextContent(entry.getKey().toString());
                    servletMapping.appendChild(servletName2);
                    Element urlPattern = doc.createElement("url-pattern");
                    urlPattern.setTextContent(pattern);
                    servletMapping.appendChild(urlPattern);
                }
                webapp.appendChild(servletMapping);
            }
            for (String string : listeners) {
                Element listener = doc.createElement("listener");
                Element listenerClass = doc.createElement("listener-class");
                listenerClass.setTextContent(string);
                listener.appendChild(listenerClass);
                webapp.appendChild(listener);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            if (file != null) {
                DOMSource dOMSource = new DOMSource(doc);
                StreamResult result = new StreamResult(file);
                transformer.transform(dOMSource, result);
            }
        }
    }

    private final class HttpProbeImpl
    extends HttpProbe.Adapter {
        boolean accessLoggingEnabled = false;
        NetworkListener listener = null;

        public HttpProbeImpl(NetworkListener listener, boolean accessLoggingEnabled) {
            this.listener = listener;
            this.accessLoggingEnabled = accessLoggingEnabled;
        }

        public void enableAccessLogging() {
            this.accessLoggingEnabled = true;
        }

        public void disableAccessLogging() {
            this.accessLoggingEnabled = false;
        }

        @Override
        public void onErrorEvent(Connection connection, HttpPacket packet, Throwable error) {
            if (this.accessLoggingEnabled) {
                if (packet instanceof HttpRequestPacket) {
                    HttpRequestPacket requestPacket = (HttpRequestPacket)packet;
                    HttpResponsePacket responsePacket = requestPacket.getResponse();
                    responsePacket.setStatus(HttpStatus.BAD_REQUEST_400);
                    Request request = Request.create();
                    org.glassfish.grizzly.http.server.Response response = request.getResponse();
                    request.initialize(requestPacket, FilterChainContext.create(connection), null);
                    response.initialize(request, responsePacket, FilterChainContext.create(connection), null, null);
                    Response res = new Response();
                    res.setCoyoteResponse(response);
                    WebConnector connector = VirtualServer.this.webContainer.getConnectorMap().get(this.listener.getName());
                    if (connector != null) {
                        org.apache.catalina.connector.Request req = new org.apache.catalina.connector.Request();
                        req.setCoyoteRequest(request);
                        req.setConnector(connector);
                        try {
                            VirtualServer.this.accessLogValve.postInvoke(req, res);
                        }
                        catch (IOException ex) {
                            VirtualServer.this._logger.log(Level.SEVERE, VirtualServer.UNABLE_RECONFIGURE_ACCESS_LOG, ex);
                        }
                    } else {
                        VirtualServer.this._logger.log(Level.SEVERE, VirtualServer.UNABLE_RECONFIGURE_ACCESS_LOG);
                    }
                } else {
                    VirtualServer.this._logger.log(Level.SEVERE, VirtualServer.UNABLE_RECONFIGURE_ACCESS_LOG);
                }
            }
        }
    }
}

