/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.stats.KeepAliveStatsProvider;
import java.io.IOException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.http.KeepAliveProbe;

public class KeepAliveMonitor
implements KeepAliveProbe {
    private final GrizzlyMonitoring grizzlyMonitoring;
    private final String monitoringId;

    public KeepAliveMonitor(GrizzlyMonitoring grizzlyMonitoring, String monitoringId, KeepAlive config) {
        this.grizzlyMonitoring = grizzlyMonitoring;
        this.monitoringId = monitoringId;
        if (grizzlyMonitoring != null) {
            KeepAliveStatsProvider statsProvider = grizzlyMonitoring.getKeepAliveStatsProvider(monitoringId);
            statsProvider.setStatsObject(config);
            statsProvider.reset();
        }
    }

    @Override
    public void onConnectionAcceptEvent(Connection connection) {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountConnectionsEvent(this.monitoringId);
        connection.addCloseListener(new Connection.CloseListener(){

            @Override
            public void onClosed(Connection connection, Connection.CloseType closeType) throws IOException {
                KeepAliveMonitor.this.grizzlyMonitoring.getKeepAliveProbeProvider().decrementCountConnectionsEvent(KeepAliveMonitor.this.monitoringId);
            }
        });
    }

    @Override
    public void onHitEvent(Connection connection, int requestNumber) {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountHitsEvent(this.monitoringId);
    }

    @Override
    public void onRefuseEvent(Connection connection) {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountRefusalsEvent(this.monitoringId);
    }

    @Override
    public void onTimeoutEvent(Connection connection) {
        this.grizzlyMonitoring.getKeepAliveProbeProvider().incrementCountTimeoutsEvent(this.monitoringId);
    }
}

