/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ManagedJobConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CompletedJob;
import com.sun.enterprise.v3.admin.JobManagerService;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.ObservableBean;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="job-cleanup")
@RunLevel(value=10)
public class JobCleanUpService
implements PostConstruct,
ConfigListener {
    @Inject
    JobManagerService jobManagerService;
    @Inject
    Domain domain;
    private ManagedJobConfig managedJobConfig;
    private static final Logger logger = KernelLoggerInfo.getLogger();
    private ScheduledExecutorService scheduler;
    private static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(JobCleanUpService.class);

    @Override
    public void postConstruct() {
        logger.log(Level.FINE, "NCLS-CORE-00073");
        this.managedJobConfig = this.domain.getExtensionByType(ManagedJobConfig.class);
        ObservableBean bean = (ObservableBean)((Object)ConfigSupport.getImpl(this.managedJobConfig));
        logger.fine("NCLS-CORE-00074");
        bean.addListener(this);
        this.scheduler = Executors.newScheduledThreadPool(10, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r);
                result.setDaemon(true);
                return result;
            }
        });
        this.scheduleCleanUp();
    }

    private void scheduleCleanUp() {
        logger.fine("NCLS-CORE-00075");
        long delayBetweenRuns = 1200000L;
        long initialDelay = 1200000L;
        delayBetweenRuns = this.jobManagerService.convert(this.managedJobConfig.getPollInterval());
        initialDelay = this.jobManagerService.convert(this.managedJobConfig.getInitialDelay());
        ScheduledFuture<?> cleanupFuture = this.scheduler.scheduleAtFixedRate(new JobCleanUpTask(), initialDelay, delayBetweenRuns, TimeUnit.MILLISECONDS);
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch(events, new PropertyChangeHandler(), logger);
    }

    private void cleanUpExpiredJobs(File file) {
        ArrayList<JobInfo> expiredJobs = this.jobManagerService.getExpiredJobs(file);
        if (expiredJobs.size() > 0) {
            for (JobInfo job : expiredJobs) {
                this.jobManagerService.purgeJob(job.jobId);
                this.jobManagerService.purgeCompletedJobForId(job.jobId, file);
                this.jobManagerService.removeFromCompletedJobs(job.jobId);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "NCLS-CORE-00072", job.jobId);
            }
        }
    }

    class PropertyChangeHandler
    implements Changed {
        PropertyChangeHandler() {
        }

        @Override
        public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> changedType, T changedInstance) {
            NotProcessed np = null;
            switch (type2) {
                case CHANGE: {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "NCLS-CORE-00071", new Object[]{changedType.getName(), changedInstance.toString()});
                    }
                    np = this.handleChangeEvent(changedInstance);
                    break;
                }
            }
            return np;
        }

        private <T extends ConfigBeanProxy> NotProcessed handleChangeEvent(T instance) {
            JobCleanUpService.this.scheduleCleanUp();
            return null;
        }
    }

    private final class JobCleanUpTask
    implements Runnable {
        private JobCleanUpTask() {
        }

        @Override
        public void run() {
            try {
                ConcurrentHashMap<String, CompletedJob> completedJobsMap = JobCleanUpService.this.jobManagerService.getCompletedJobsInfo();
                for (CompletedJob completedJob : new HashSet<CompletedJob>(completedJobsMap.values())) {
                    logger.log(Level.FINE, "NCLS-CORE-00072", new Object[]{completedJob.getId()});
                    JobCleanUpService.this.cleanUpExpiredJobs(completedJob.getJobsFile());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("NCLS-CORE-00076", e);
            }
        }
    }
}

