/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac;

import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.jmac.config.GFServerConfigProvider;
import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=10)
public class MessageSecurityConfigEventListenerImpl
implements ConfigListener {
    private static Logger logger = LogDomains.getLogger(MessageSecurityConfigEventListenerImpl.class, "javax.enterprise.system.core.security", false);
    @Inject
    @Named(value="default-instance-name")
    private SecurityService service;

    public <T extends ConfigBeanProxy> NotProcessed handleUpdate(T instance) {
        NotProcessed np = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "MessageSecurityConfigEventListenerImpl - handleUpdate called");
        }
        if (instance instanceof MessageSecurityConfig) {
            GFServerConfigProvider.loadConfigContext(this.service);
        } else {
            np = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
        }
        return np;
    }

    public <T extends ConfigBeanProxy> NotProcessed handleDelete(T instance) {
        NotProcessed np = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "MessageSecurityConfigEventListenerImpl - handleDelete called");
        }
        if (instance instanceof MessageSecurityConfig) {
            GFServerConfigProvider.loadConfigContext(this.service);
        } else {
            np = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
        }
        return np;
    }

    public <T extends ConfigBeanProxy> NotProcessed handleCreate(T instance) {
        NotProcessed np = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "MessageSecurityConfigEventListenerImpl - handleCreate called");
        }
        if (instance instanceof MessageSecurityConfig) {
            GFServerConfigProvider.loadConfigContext(this.service);
        } else {
            np = new NotProcessed("unimplemented: unknown instance: " + instance.getClass().getName());
        }
        return np;
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> changedType, T changedInstance) {
                NotProcessed np = null;
                switch (type2) {
                    case ADD: {
                        logger.fine("A new " + changedType.getName() + " was added : " + " " + changedInstance);
                        np = MessageSecurityConfigEventListenerImpl.this.handleCreate(changedInstance);
                        break;
                    }
                    case CHANGE: {
                        logger.fine("A " + changedType.getName() + " was changed : " + changedInstance);
                        np = MessageSecurityConfigEventListenerImpl.this.handleUpdate(changedInstance);
                        break;
                    }
                    case REMOVE: {
                        logger.fine("A " + changedType.getName() + " was removed : " + changedInstance);
                        np = MessageSecurityConfigEventListenerImpl.this.handleDelete(changedInstance);
                    }
                }
                return np;
            }
        }, logger);
        return null;
    }
}

