/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.pool.ConnectionLeakListener;
import com.sun.enterprise.resource.pool.ConnectionPool;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class ConnectionLeakDetector {
    private HashMap<ResourceHandle, StackTraceElement[]> connectionLeakThreadStackHashMap;
    private HashMap<ResourceHandle, ConnectionLeakTask> connectionLeakTimerTaskHashMap;
    private boolean connectionLeakTracing;
    private long connectionLeakTimeoutInMillis;
    private boolean connectionLeakReclaim;
    private PoolInfo connectionPoolInfo;
    private Map<ResourceHandle, ConnectionLeakListener> listeners;
    private final Object connectionLeakLock;
    private static final Logger _logger = LogDomains.getLogger(ConnectionLeakDetector.class, "javax.enterprise.resource.resourceadapter");
    private static final StringManager localStrings = StringManager.getManager(ConnectionPool.class);

    public ConnectionLeakDetector(PoolInfo poolInfo, boolean leakTracing, long leakTimeoutInMillis, boolean leakReclaim) {
        this.connectionPoolInfo = poolInfo;
        this.connectionLeakThreadStackHashMap = new HashMap();
        this.connectionLeakTimerTaskHashMap = new HashMap();
        this.listeners = new HashMap<ResourceHandle, ConnectionLeakListener>();
        this.connectionLeakLock = new Object();
        this.connectionLeakTracing = leakTracing;
        this.connectionLeakTimeoutInMillis = leakTimeoutInMillis;
        this.connectionLeakReclaim = leakReclaim;
    }

    public void reset(boolean leakTracing, long leakTimeoutInMillis, boolean leakReclaim) {
        if (!this.connectionLeakTracing && leakTracing) {
            this.clearAllConnectionLeakTasks();
        }
        this.connectionLeakTracing = leakTracing;
        this.connectionLeakTimeoutInMillis = leakTimeoutInMillis;
        this.connectionLeakReclaim = leakReclaim;
    }

    private void registerListener(ResourceHandle handle, ConnectionLeakListener listener) {
        this.listeners.put(handle, listener);
    }

    private void unRegisterListener(ResourceHandle handle) {
        this.listeners.remove(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConnectionLeakTracing(ResourceHandle resourceHandle, ConnectionLeakListener listener) {
        if (this.connectionLeakTracing) {
            Object object = this.connectionLeakLock;
            synchronized (object) {
                if (!this.connectionLeakThreadStackHashMap.containsKey(resourceHandle)) {
                    this.connectionLeakThreadStackHashMap.put(resourceHandle, Thread.currentThread().getStackTrace());
                    ConnectionLeakTask connectionLeakTask = new ConnectionLeakTask(resourceHandle);
                    this.connectionLeakTimerTaskHashMap.put(resourceHandle, connectionLeakTask);
                    this.registerListener(resourceHandle, listener);
                    if (this.getTimer() != null) {
                        this.getTimer().schedule((TimerTask)connectionLeakTask, this.connectionLeakTimeoutInMillis);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopConnectionLeakTracing(ResourceHandle resourceHandle, ConnectionLeakListener listener) {
        if (this.connectionLeakTracing) {
            Object object = this.connectionLeakLock;
            synchronized (object) {
                if (this.connectionLeakThreadStackHashMap.containsKey(resourceHandle)) {
                    this.connectionLeakThreadStackHashMap.remove(resourceHandle);
                    ConnectionLeakTask connectionLeakTask = this.connectionLeakTimerTaskHashMap.remove(resourceHandle);
                    connectionLeakTask.cancel();
                    this.getTimer().purge();
                    this.unRegisterListener(resourceHandle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void potentialConnectionLeakFound(ResourceHandle resourceHandle) {
        Object object = this.connectionLeakLock;
        synchronized (object) {
            if (this.connectionLeakThreadStackHashMap.containsKey(resourceHandle)) {
                StackTraceElement[] threadStack = this.connectionLeakThreadStackHashMap.remove(resourceHandle);
                ConnectionLeakListener connLeakListener = this.listeners.get(resourceHandle);
                connLeakListener.potentialConnectionLeakFound();
                this.printConnectionLeakTrace(threadStack, connLeakListener);
                this.connectionLeakTimerTaskHashMap.remove(resourceHandle);
                if (this.connectionLeakReclaim) {
                    resourceHandle.markForReclaim(true);
                    connLeakListener.reclaimConnection(resourceHandle);
                }
                this.unRegisterListener(resourceHandle);
            }
        }
    }

    private void printConnectionLeakTrace(StackTraceElement[] threadStackTrace, ConnectionLeakListener connLeakListener) {
        StringBuffer stackTrace = new StringBuffer();
        String msg = localStrings.getStringWithDefault("potential.connection.leak.msg", "A potential connection leak detected for connection pool " + this.connectionPoolInfo + ". The stack trace of the thread is provided below : ", new Object[]{this.connectionPoolInfo});
        stackTrace.append(msg);
        stackTrace.append("\n");
        for (int i = 2; i < threadStackTrace.length; ++i) {
            stackTrace.append(threadStackTrace[i].toString());
            stackTrace.append("\n");
        }
        connLeakListener.printConnectionLeakTrace(stackTrace);
        _logger.log(Level.WARNING, stackTrace.toString(), "ConnectionPoolName=" + this.connectionPoolInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAllConnectionLeakTasks() {
        Object object = this.connectionLeakLock;
        synchronized (object) {
            for (ResourceHandle resourceHandle : this.connectionLeakTimerTaskHashMap.keySet()) {
                ConnectionLeakTask connectionLeakTask = this.connectionLeakTimerTaskHashMap.get(resourceHandle);
                connectionLeakTask.cancel();
            }
            if (this.getTimer() != null) {
                this.getTimer().purge();
            }
            this.connectionLeakThreadStackHashMap.clear();
            this.connectionLeakTimerTaskHashMap.clear();
        }
    }

    private Timer getTimer() {
        return ConnectorRuntime.getRuntime().getTimer();
    }

    private class ConnectionLeakTask
    extends TimerTask {
        private ResourceHandle resourceHandle;

        ConnectionLeakTask(ResourceHandle resourceHandle) {
            this.resourceHandle = resourceHandle;
        }

        @Override
        public void run() {
            ConnectionLeakDetector.this.potentialConnectionLeakFound(this.resourceHandle);
        }
    }
}

