/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceConstants;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.resources.api.GlobalResourceDeployer;

public abstract class AbstractConnectorResourceDeployer
extends GlobalResourceDeployer
implements ResourceDeployer {
    @Override
    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        if (this.handles(resource)) {
            if (postApplicationDeployment && ConnectorsUtil.isEmbeddedRarResource(resource, allResources) == ResourceConstants.TriState.TRUE) {
                return true;
            }
            if (!postApplicationDeployment && ConnectorsUtil.isEmbeddedRarResource(resource, allResources) == ResourceConstants.TriState.FALSE) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
        ArrayList<Module> oldRARModules = new ArrayList<Module>();
        List<Module> oldModules = oldApp.getModule();
        for (Module oldModule : oldModules) {
            if (oldModule.getEngine("connector") == null) continue;
            oldRARModules.add(oldModule);
        }
        List<Module> newRARModules = newApp.getModule();
        ArrayList<Module> staleRars = new ArrayList<Module>();
        for (Module oldRARModule : oldRARModules) {
            String oldRARModuleName = oldRARModule.getName();
            boolean found = false;
            for (Module newRARModule : newRARModules) {
                String newRARModuleName = newRARModule.getName();
                if (!newRARModuleName.equals(oldRARModuleName)) continue;
                found = true;
            }
            if (found) continue;
            staleRars.add(oldRARModule);
        }
        String appName = newApp.getName();
        if (staleRars.size() > 0) {
            AbstractConnectorResourceDeployer.validateResourcesForStaleReference(appName, staleRars, allResources);
        }
    }

    public static void validateResourcesForStaleReference(String appName, List<Module> staleRars, Resources resources) throws ResourceConflictException {
        boolean found = false;
        for (Resource resource : resources.getResources()) {
            String rarNameOfResource;
            if (!ConnectorsUtil.isRARResource(resource) || !(rarNameOfResource = ConnectorsUtil.getRarNameOfResource(resource, resources)).contains("#")) continue;
            String embeddedRARName = ConnectorsUtil.getRarNameFromApplication(rarNameOfResource);
            for (Module module : staleRars) {
                if (!ResourceUtil.getActualModuleNameWithExtension(module.getName()).equals(embeddedRARName)) continue;
                throw new ResourceConflictException("Existing resources refer RAR [ " + embeddedRARName + " ] which is" + "not present in the re-deployed application [" + appName + "] anymore. " + "re-deploy the application after resolving the conflicts");
            }
        }
    }
}

