/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt;

import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.core.RejoinSubevent;
import com.sun.enterprise.ee.cms.impl.base.CustomTagNames;
import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.ee.cms.impl.client.RejoinSubeventImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.mgmt.ClusterManager;
import com.sun.enterprise.mgmt.ClusterView;
import com.sun.enterprise.mgmt.ClusterViewEvent;
import com.sun.enterprise.mgmt.ClusterViewEventListener;
import com.sun.enterprise.mgmt.ClusterViewEvents;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterViewManager {
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    private TreeMap<PeerID<?>, SystemAdvertisement> view = new TreeMap();
    private SystemAdvertisement advertisement = null;
    private SystemAdvertisement masterAdvertisement = null;
    private List<ClusterViewEventListener> cvListeners = new ArrayList<ClusterViewEventListener>();
    private long viewId = 0L;
    private AtomicLong masterViewID = new AtomicLong(0L);
    private ClusterManager manager;
    private ReentrantLock viewLock = new ReentrantLock();
    private GMSContext gmsCtxt = null;

    public ClusterViewManager(SystemAdvertisement advertisement, ClusterManager manager, List<ClusterViewEventListener> listeners) {
        this.advertisement = advertisement;
        this.manager = manager;
        this.cvListeners.addAll(listeners);
        this.gmsCtxt = GMSContextFactory.getGMSContext(manager.getGroupName());
    }

    public void start() {
        this.setMaster(this.advertisement, true);
    }

    public void addClusterViewEventListener(ClusterViewEventListener listener) {
        this.cvListeners.add(listener);
    }

    public void removeClusterViewEventListener(ClusterViewEventListener listener) {
        this.cvListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(SystemAdvertisement advertisement) {
        boolean added;
        boolean result = false;
        this.lockLog("add()");
        this.viewLock.lock();
        try {
            if (!this.view.containsKey(advertisement.getID())) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, new StringBuffer().append("Adding ").append(advertisement.getName()).append("   ").append(advertisement.getID().toString()).toString());
                }
                this.manager.getNetworkManager().addRemotePeer(advertisement.getID());
                this.view.put(advertisement.getID(), advertisement);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "add " + advertisement.getName() + " newViewSize=" + this.view.size());
                }
                result = true;
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, MessageFormat.format("Cluster view now contains {0} entries", this.getViewSize()));
                }
            } else {
                SystemAdvertisement existingAdv = this.view.get(advertisement.getID());
                if (this.manager.getMasterNode().confirmInstanceHasRestarted(existingAdv, advertisement)) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("ClusterViewManager .add() : Instance " + advertisement.getName() + " has restarted. Adding it to the view.");
                    }
                    this.manager.getNetworkManager().removePeerID(existingAdv.getID());
                    this.manager.getNetworkManager().addRemotePeer(advertisement.getID());
                    this.view.put(advertisement.getID(), advertisement);
                    RejoinSubeventImpl rsi = new RejoinSubeventImpl(Utility.getStartTime(existingAdv));
                    RejoinSubevent previous = this.gmsCtxt.getInstanceRejoins().put(existingAdv.getName(), rsi);
                    if (previous != null && LOG.isLoggable(Level.INFO)) {
                        Object[] params = new String[]{existingAdv.getName(), previous.toString()};
                        LOG.log(Level.INFO, "rejoin.subevent.replaced", params);
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.format("Added rejoin subevent for '%s' to context map", existingAdv.getName()));
                    }
                    result = true;
                }
            }
        }
        finally {
            this.viewLock.unlock();
        }
        if (result && (added = this.manager.getHealthMonitor().addHealthEntryIfMissing(advertisement)) && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "ensured ClusterViewManager and HealthMonitor both aware of member: " + advertisement.getName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setMaster(SystemAdvertisement advertisement, boolean notify) {
        if (advertisement.equals(this.masterAdvertisement)) {
            return false;
        }
        this.masterAdvertisement = advertisement;
        this.lockLog("setMaster()");
        this.viewLock.lock();
        try {
            this.view.put(this.masterAdvertisement.getID(), this.masterAdvertisement);
        }
        finally {
            this.viewLock.unlock();
        }
        if (notify) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "setMaster master:" + advertisement.getName());
            }
            this.notifyListeners(new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, advertisement));
        }
        if (LOG.isLoggable(Level.FINE)) {
            if (advertisement.getID().equals(this.advertisement.getID())) {
                LOG.log(Level.FINE, "Setting MasterNode Role");
            } else {
                LOG.log(Level.FINE, new StringBuffer().append("Setting Master Node :").append(advertisement.getName()).append(' ').append(advertisement.getID()).toString());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setMaster(List<SystemAdvertisement> newView, SystemAdvertisement advertisement) {
        if (advertisement.equals(this.masterAdvertisement)) {
            return false;
        }
        this.lockLog("setMaster()");
        this.viewLock.lock();
        try {
            if (newView != null) {
                this.addToView(newView);
            }
            this.setMaster(advertisement, true);
        }
        finally {
            this.viewLock.unlock();
        }
        return true;
    }

    public SystemAdvertisement getMaster() {
        return this.masterAdvertisement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemAdvertisement get(PeerID<?> id) {
        SystemAdvertisement adv;
        this.lockLog("get()");
        this.viewLock.lock();
        try {
            adv = this.view.get(id);
        }
        finally {
            this.viewLock.unlock();
        }
        return adv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SystemAdvertisement remove(SystemAdvertisement advertisement) {
        SystemAdvertisement removed = null;
        PeerID<?> id = advertisement.getID();
        this.lockLog("remove()");
        this.viewLock.lock();
        try {
            removed = this.view.remove(id);
        }
        finally {
            this.viewLock.unlock();
        }
        if (removed != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Removed " + removed.getName() + "   " + id);
            }
            this.manager.getNetworkManager().removePeerID(id);
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Skipping removal of " + id + " Not in view");
        }
        return removed;
    }

    public boolean containsKey(PeerID<?> id) {
        return this.containsKey(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(PeerID<?> id, boolean debug) {
        boolean contains;
        this.viewLock.lock();
        try {
            contains = this.view.containsKey(id);
            if (debug && !contains && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "ClusterViewManager.containsKey(peerid=" + id + ") is false.\ngroup: " + this.manager.getGroupName() + " view=" + this.dumpView());
            }
        }
        finally {
            this.viewLock.unlock();
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        this.viewLock.lock();
        try {
            this.view.clear();
            this.view.put(this.advertisement.getID(), this.advertisement);
        }
        finally {
            this.viewLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterView getLocalView() {
        TreeMap clone;
        long localViewId = 0L;
        long masterViewId = 0L;
        this.lockLog("getLocalView()");
        this.viewLock.lock();
        try {
            TreeMap temp;
            clone = temp = (TreeMap)this.view.clone();
            localViewId = this.viewId++;
            masterViewId = this.getMasterViewID();
        }
        finally {
            this.viewLock.unlock();
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "returning new ClusterView with view size:" + this.view.size());
        }
        return new ClusterView(clone, localViewId, masterViewId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getViewSize() {
        int size;
        this.lockLog("getViewSize()");
        this.viewLock.lock();
        try {
            size = this.view.size();
        }
        finally {
            this.viewLock.unlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SystemAdvertisement getMasterCandidate() {
        SystemAdvertisement seniorMember = null;
        this.lockLog("getMasterCandidate()");
        this.viewLock.lock();
        try {
            long seniorMemberStartTime = Long.MAX_VALUE;
            for (Map.Entry<PeerID<?>, SystemAdvertisement> e : this.view.entrySet()) {
                SystemAdvertisement i = e.getValue();
                if (seniorMember == null) {
                    seniorMember = i;
                    try {
                        seniorMemberStartTime = Long.parseLong(i.getCustomTagValue(CustomTagNames.START_TIME.toString()));
                    }
                    catch (NoSuchFieldException ignore) {}
                    continue;
                }
                long iCurrentStartTime = Long.MAX_VALUE;
                try {
                    iCurrentStartTime = Long.parseLong(i.getCustomTagValue(CustomTagNames.START_TIME.toString()));
                }
                catch (NoSuchFieldException ignore) {
                    // empty catch block
                }
                if (iCurrentStartTime >= seniorMemberStartTime) continue;
                seniorMember = i;
                seniorMemberStartTime = iCurrentStartTime;
            }
        }
        finally {
            this.viewLock.unlock();
        }
        if (seniorMember == null) {
            LOG.warning("getMasterCandidate: no master candidate selected, nominating self");
            seniorMember = this.manager.getSystemAdvertisement();
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, new StringBuffer().append("Returning Master Candidate Node :").append(seniorMember.getName()).append(' ').append(seniorMember.getID()).toString());
        }
        return seniorMember;
    }

    public boolean isMaster() {
        return this.masterAdvertisement != null && this.masterAdvertisement.getID().equals(this.advertisement.getID());
    }

    public boolean isFirst() {
        PeerID<?> id = this.view.firstKey();
        return this.advertisement.getID().equals(id);
    }

    public int indexOf(PeerID<?> id) {
        if (id == null) {
            return -1;
        }
        int index = 0;
        for (PeerID<?> peerID : this.view.keySet()) {
            PeerID<?> key = peerID;
            if (key.equals(id)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public PeerID<?> getID(String name) {
        return this.manager.getID(name);
    }

    void addToView(List<SystemAdvertisement> newView, boolean authoritative, ClusterViewEvent cvEvent) {
        if (cvEvent == null) {
            return;
        }
        if (authoritative) {
            ClusterViewEvents event = cvEvent.getEvent();
            boolean changed = this.addToView(newView);
            if (changed || event != ClusterViewEvents.ADD_EVENT) {
                this.notifyListeners(cvEvent);
            } else {
                GMSMember member = Utility.getGMSMember(cvEvent.getAdvertisement());
                LOG.log(Level.INFO, "mgmt.clusterviewmanager.skipnotify", new Object[]{cvEvent.getEvent(), member.getMemberToken(), member.getGroupName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToView(List<SystemAdvertisement> newView) {
        boolean changed = false;
        this.lockLog("addToView() - reset and add newView");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "addToView newViewSize=" + newView.size());
        }
        this.viewLock.lock();
        this.reset();
        try {
            if (!newView.contains(this.manager.getSystemAdvertisement())) {
                this.view.put(this.manager.getSystemAdvertisement().getID(), this.manager.getSystemAdvertisement());
            }
            for (SystemAdvertisement elem : newView) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, new StringBuffer().append("Adding ").append(elem.getID()).append(" to view").toString());
                }
                if (!changed && !this.view.containsKey(elem.getID())) {
                    changed = true;
                }
                this.manager.getNetworkManager().addRemotePeer(elem.getID());
                this.view.put(elem.getID(), elem);
            }
        }
        finally {
            this.viewLock.unlock();
        }
        return changed;
    }

    void notifyListeners(ClusterViewEvent event) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, MessageFormat.format("Notifying the {0} to listeners, peer in event is {1}", event.getEvent().toString(), event.getAdvertisement().getName()));
        }
        ClusterView cv = this.getLocalView();
        for (ClusterViewEventListener elem : this.cvListeners) {
            elem.clusterViewEvent(event, cv);
        }
    }

    public void setInDoubtPeerState(SystemAdvertisement adv) {
        if (adv == null) {
            throw new IllegalArgumentException("SystemAdvertisment may not be null");
        }
        this.notifyListeners(new ClusterViewEvent(ClusterViewEvents.IN_DOUBT_EVENT, adv));
    }

    public void setPeerStoppingState(SystemAdvertisement adv) {
        if (adv == null) {
            throw new IllegalArgumentException("SystemAdvertisment may not be null");
        }
        this.notifyListeners(new ClusterViewEvent(ClusterViewEvents.PEER_STOP_EVENT, adv));
    }

    public void setClusterStoppingState(SystemAdvertisement adv) {
        if (adv == null) {
            throw new IllegalArgumentException("SystemAdvertisment may not be null");
        }
        this.notifyListeners(new ClusterViewEvent(ClusterViewEvents.CLUSTER_STOP_EVENT, adv));
    }

    public void setPeerNoLongerInDoubtState(SystemAdvertisement adv) {
        if (adv == null) {
            throw new IllegalArgumentException("SystemAdvertisment may not be null");
        }
        this.notifyListeners(new ClusterViewEvent(ClusterViewEvents.NO_LONGER_INDOUBT_EVENT, adv));
    }

    public long getMasterViewID() {
        return this.masterViewID.get();
    }

    public void setMasterViewID(long masterViewID) {
        this.masterViewID.set(masterViewID);
    }

    private void lockLog(String method) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, MessageFormat.format("{0} viewLock Hold count :{1}, lock queue count:{2}", method, this.viewLock.getHoldCount(), this.viewLock.getQueueLength()));
        }
    }

    public void setPeerReadyState(SystemAdvertisement adv) {
        if (adv == null) {
            throw new IllegalArgumentException("SystemAdvertisment may not be null");
        }
        this.notifyListeners(new ClusterViewEvent(ClusterViewEvents.JOINED_AND_READY_EVENT, adv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String dumpView() {
        StringBuffer sb = new StringBuffer();
        this.viewLock.lock();
        try {
            sb.append("clusterviewmanager snapshot: group:" + this.manager.getGroupName() + " current view id=" + this.viewId + " \n");
            int counter = 0;
            for (Map.Entry<PeerID<?>, SystemAdvertisement> current : this.view.entrySet()) {
                PeerID<?> peerid = current.getKey();
                sb.append(++counter).append(". ");
                sb.append(peerid.getInstanceName());
                sb.append(" ");
                sb.append(peerid.getUniqueID().toString());
                sb.append('\n');
            }
        }
        finally {
            this.viewLock.unlock();
        }
        return sb.toString();
    }
}

