/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.common.FailureNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;

public class FailureRecoverySignalImpl
extends FailureNotificationSignalImpl
implements FailureRecoverySignal {
    private String componentName;

    public FailureRecoverySignalImpl(String componentName, String failedMember, String groupName, long startTime) {
        this.failedMember = failedMember;
        this.componentName = componentName;
        this.groupName = groupName;
        this.startTime = startTime;
        this.ctx = GMSContextFactory.getGMSContext(groupName);
    }

    FailureRecoverySignalImpl(FailureRecoverySignal signal) {
        this.failedMember = signal.getMemberToken();
        this.componentName = signal.getComponentName();
        this.groupName = signal.getGroupName();
        this.startTime = signal.getStartTime();
        this.ctx = GMSContextFactory.getGMSContext(this.groupName);
    }

    @Override
    public void acquire() throws SignalAcquireException {
    }

    @Override
    public void release() throws SignalReleaseException {
        try {
            this.ctx.getGroupHandle().removeRecoveryAppointments(this.failedMember, this.componentName);
            this.failedMember = null;
        }
        catch (GMSException e) {
            throw new SignalReleaseException(e);
        }
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }
}

