/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.CommonResourceBundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.runtime.application.wls.ApplicationParam;
import com.sun.enterprise.deployment.runtime.common.SecurityRoleMapping;
import com.sun.enterprise.deployment.runtime.common.wls.SecurityRoleAssignment;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.types.MessageDestinationReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceEnvReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.types.RoleMappingContainer;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.deployment.util.ApplicationVisitor;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.DescriptorVisitor;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Role;

public class Application
extends CommonResourceBundleDescriptor
implements RoleMappingContainer,
WritableJndiNameEnvironment,
EjbReferenceContainer,
ResourceEnvReferenceContainer,
ResourceReferenceContainer,
ServiceReferenceContainer,
MessageDestinationReferenceContainer {
    private static final String LIBRARY_DIRECTORY_DEFAULT_VALUE = "lib";
    private static final String PERSISTENCE_UNIT_NAME_SEPARATOR = "#";
    private String generatedXMLDir;
    private Set<ModuleDescriptor<BundleDescriptor>> modules = new OrderedSet<ModuleDescriptor<BundleDescriptor>>();
    private boolean uniqueIdSet = false;
    private long uniqueId;
    private boolean virtual = false;
    private Boolean passByReference = null;
    private String cmpDescriptorsLock = "cmp descriptors lock";
    private boolean isDirty;
    private transient SecurityRoleMapper roleMapper;
    private String registrationName;
    private String appName;
    private String archiveName;
    private String compatValue;
    private String classLoadingDelegate;
    private boolean initializeInOrder = false;
    private String realm;
    @Inject
    private transient SecurityRoleMapperFactory securityRoleMapperFactory;
    private boolean keepStateResolved;
    private transient Map<String, EntityManagerFactory> entityManagerFactories = new HashMap<String, EntityManagerFactory>();
    private Set<String> entityManagerFactoryUnitNames = new HashSet<String>();
    private Set<EnvironmentProperty> environmentProperties = new HashSet<EnvironmentProperty>();
    private Set<EjbReference> ejbReferences = new HashSet<EjbReference>();
    private Set<ResourceEnvReferenceDescriptor> resourceEnvReferences = new HashSet<ResourceEnvReferenceDescriptor>();
    private Set<MessageDestinationReferenceDescriptor> messageDestReferences = new HashSet<MessageDestinationReferenceDescriptor>();
    private Set<ResourceReferenceDescriptor> resourceReferences = new HashSet<ResourceReferenceDescriptor>();
    private Set<ServiceReferenceDescriptor> serviceReferences = new HashSet<ServiceReferenceDescriptor>();
    private Set<EntityManagerFactoryReferenceDescriptor> entityManagerFactoryReferences = new HashSet<EntityManagerFactoryReferenceDescriptor>();
    private Set<EntityManagerReferenceDescriptor> entityManagerReferences = new HashSet<EntityManagerReferenceDescriptor>();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Application.class);
    private Set<Role> appRoles;
    private String libraryDirectory;
    private List<SecurityRoleMapping> roleMaps = new ArrayList<SecurityRoleMapping>();
    private List<SecurityRoleAssignment> wlRoleAssignments = new ArrayList<SecurityRoleAssignment>();
    private boolean loadedFromApplicationXml = true;
    private Set<String> resourceAdapters = new HashSet<String>();
    private Set<ApplicationParam> applicationParams = new HashSet<ApplicationParam>();
    private static final ServiceLocator habitat = Globals.getDefaultHabitat();
    static Logger _logger = DOLUtils.getDefaultLogger();

    private Application() {
        super("", localStrings.getLocalString("enterprise.deployment.application.description", "Application description"));
    }

    @Override
    public String getDefaultSpecVersion() {
        return "7";
    }

    @Override
    public boolean isEmpty() {
        return this.modules.isEmpty();
    }

    public static Application createVirtualApplication(String name, ModuleDescriptor<BundleDescriptor> newModule) {
        Application application = Application.createApplication();
        application.setVirtual(true);
        if (name == null && newModule != null && newModule.getDescriptor() != null) {
            name = newModule.getDescriptor().getDisplayName();
        }
        String untaggedName = VersioningUtils.getUntaggedName(name);
        if (name != null) {
            application.setDisplayName(untaggedName);
            application.setName(untaggedName);
            application.setAppName(untaggedName);
        }
        if (newModule != null) {
            newModule.setStandalone(true);
            newModule.setArchiveUri(untaggedName);
            if (newModule.getDescriptor() != null) {
                newModule.getDescriptor().setApplication(application);
            }
            application.addModule(newModule);
        }
        return application;
    }

    public static Application createApplication() {
        Application retVal = habitat.create(Application.class);
        habitat.inject(retVal);
        habitat.postConstruct(retVal);
        return retVal;
    }

    @Override
    public Set<EjbReference> getEjbReferenceDescriptors() {
        return this.ejbReferences;
    }

    @Override
    public void addEjbReferenceDescriptor(EjbReference ejbReference) {
        this.ejbReferences.add(ejbReference);
        ejbReference.setReferringBundleDescriptor(this);
    }

    @Override
    public void removeEjbReferenceDescriptor(EjbReference ejbReference) {
        this.ejbReferences.remove(ejbReference);
    }

    public EjbReference getEjbReferenceByName(String name) {
        return (EjbReferenceDescriptor)this.getEjbReference(name);
    }

    @Override
    public EjbReference getEjbReference(String name) {
        for (EjbReference er : this.getEjbReferenceDescriptors()) {
            if (!er.getName().equals(name)) continue;
            return er;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbrefbyname", "This app [{0}] has no ejb reference by the name of [{1}] ", this.getName(), name));
    }

    @Override
    public Set<ServiceReferenceDescriptor> getServiceReferenceDescriptors() {
        return this.serviceReferences;
    }

    @Override
    public void addServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        serviceRef.setBundleDescriptor(this);
        this.serviceReferences.add(serviceRef);
    }

    @Override
    public void removeServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        this.serviceReferences.remove(serviceRef);
    }

    @Override
    public ServiceReferenceDescriptor getServiceReferenceByName(String name) {
        for (ServiceReferenceDescriptor srd : this.getServiceReferenceDescriptors()) {
            if (!srd.getName().equals(name)) continue;
            return srd;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoservicerefbyname", "This app [{0}] has no service reference by the name of [{1}]", this.getRegistrationName(), name));
    }

    @Override
    public Set<MessageDestinationReferenceDescriptor> getMessageDestinationReferenceDescriptors() {
        return this.messageDestReferences;
    }

    @Override
    public void addMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor messageDestRef) {
        messageDestRef.setReferringBundleDescriptor(this);
        this.messageDestReferences.add(messageDestRef);
    }

    @Override
    public void removeMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor msgDestRef) {
        this.messageDestReferences.remove(msgDestRef);
    }

    @Override
    public MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String name) {
        for (MessageDestinationReferenceDescriptor mdr : this.messageDestReferences) {
            if (!mdr.getName().equals(name)) continue;
            return mdr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("exceptionapphasnomsgdestrefbyname", "This app [{0}] has no message destination reference by the name of [{1}]", this.getRegistrationName(), name));
    }

    @Override
    public Set<ResourceEnvReferenceDescriptor> getResourceEnvReferenceDescriptors() {
        return this.resourceEnvReferences;
    }

    @Override
    public void addResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvReference) {
        this.resourceEnvReferences.add(resourceEnvReference);
    }

    @Override
    public void removeResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvReference) {
        this.resourceEnvReferences.remove(resourceEnvReference);
    }

    @Override
    public ResourceEnvReferenceDescriptor getResourceEnvReferenceByName(String name) {
        for (ResourceEnvReferenceDescriptor jdr : this.getResourceEnvReferenceDescriptors()) {
            if (!jdr.getName().equals(name)) continue;
            return jdr;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoresourceenvrefbyname", "This app {0} has no resource environment reference by the name of {1}", this.getRegistrationName(), name));
    }

    @Override
    public Set<ResourceReferenceDescriptor> getResourceReferenceDescriptors() {
        return this.resourceReferences;
    }

    @Override
    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.resourceReferences.add(resourceReference);
    }

    @Override
    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.resourceReferences.remove(resourceReference);
    }

    @Override
    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        for (ResourceReferenceDescriptor next : this.getResourceReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoresourcerefbyname", "This app {0} has no resource reference by the name of {1}", this.getRegistrationName(), name));
    }

    @Override
    public EnvironmentProperty getEnvironmentPropertyByName(String name) {
        for (EnvironmentProperty ev : this.getEnvironmentProperties()) {
            if (!ev.getName().equals(name)) continue;
            return ev;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoenvpropertybyname", "This app {0} has no environment property by the name of {1}", this.getRegistrationName(), name));
    }

    @Override
    public Set<EnvironmentProperty> getEnvironmentProperties() {
        return this.environmentProperties;
    }

    @Override
    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.environmentProperties.add(environmentProperty);
    }

    @Override
    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.getEnvironmentProperties().remove(environmentProperty);
    }

    @Override
    public Set<EntityManagerFactoryReferenceDescriptor> getEntityManagerFactoryReferenceDescriptors() {
        return this.entityManagerFactoryReferences;
    }

    @Override
    public EntityManagerFactoryReferenceDescriptor getEntityManagerFactoryReferenceByName(String name) {
        for (EntityManagerFactoryReferenceDescriptor next : this.getEntityManagerFactoryReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoentitymgrfactoryrefbyname", "This app {0} has no entity manager factory reference by the name of {1}", this.getRegistrationName(), name));
    }

    @Override
    public void addEntityManagerFactoryReferenceDescriptor(EntityManagerFactoryReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor(this);
        this.entityManagerFactoryReferences.add(reference);
    }

    @Override
    public Set<EntityManagerReferenceDescriptor> getEntityManagerReferenceDescriptors() {
        return this.entityManagerReferences;
    }

    @Override
    public EntityManagerReferenceDescriptor getEntityManagerReferenceByName(String name) {
        for (EntityManagerReferenceDescriptor next : this.getEntityManagerReferenceDescriptors()) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoentitymgrrefbyname", "This app {0} has no entity manager reference by the name of {1}", this.getRegistrationName(), name));
    }

    @Override
    public void addEntityManagerReferenceDescriptor(EntityManagerReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor(this);
        this.getEntityManagerReferenceDescriptors().add(reference);
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPostConstructDescriptors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPostConstructDescriptor(LifecycleCallbackDescriptor postConstructDesc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPreDestroyDescriptors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPreDestroyDescriptor(LifecycleCallbackDescriptor preDestroyDesc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<InjectionCapable> getInjectableResourcesByClass(String className) {
        return this.getInjectableResourcesByClass(className, this);
    }

    @Override
    public InjectionInfo getInjectionInfoByClass(Class clazz) {
        return this.getInjectionInfoByClass(clazz, this);
    }

    public void setGeneratedXMLDirectory(String xmlDir) {
        this.generatedXMLDir = xmlDir;
    }

    public String getGeneratedXMLDirectory() {
        return this.generatedXMLDir;
    }

    public void setRegistrationName(String appId) {
        SecurityRoleMapper roleMapper = null;
        try {
            roleMapper = this.getRoleMapper();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (roleMapper != null) {
            if (this.securityRoleMapperFactory == null) {
                throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.norolemapperfactorydefine", "This application has no role mapper factory defined"));
            }
            this.securityRoleMapperFactory.removeRoleMapper(this.getName());
            roleMapper.setName(appId);
            this.securityRoleMapperFactory.setRoleMapper(appId, roleMapper);
        }
        this.registrationName = appId;
    }

    public String getRegistrationName() {
        if (this.registrationName != null) {
            return this.registrationName;
        }
        return this.getName();
    }

    public String getAppName() {
        return VersioningUtils.getUntaggedName(this.appName);
    }

    public void setAppName(String appName) {
        this.appName = VersioningUtils.getUntaggedName(appName);
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
        if (this.appName == null && archiveName != null) {
            this.appName = DeploymentUtils.getDefaultEEName(archiveName);
        }
    }

    @Override
    public String getCompatibility() {
        return this.compatValue;
    }

    @Override
    public void setCompatibility(String compatValue) {
        this.compatValue = compatValue;
    }

    public String getClassLoadingDelegate() {
        return this.classLoadingDelegate;
    }

    public void setClassLoadingDelegate(String classLoadingDelegate) {
        this.classLoadingDelegate = classLoadingDelegate;
    }

    public boolean isInitializeInOrder() {
        return this.initializeInOrder;
    }

    public void setInitializeInOrder(boolean initializeInOrder) {
        this.initializeInOrder = initializeInOrder;
    }

    public void addEntityManagerFactory(String unitName, String persistenceRootUri, EntityManagerFactory emf) {
        String fullyQualifiedUnitName = persistenceRootUri + PERSISTENCE_UNIT_NAME_SEPARATOR + unitName;
        this.entityManagerFactories.put(fullyQualifiedUnitName, emf);
        if (this.entityManagerFactoryUnitNames.contains(unitName)) {
            this.entityManagerFactories.remove(unitName);
        } else {
            this.entityManagerFactories.put(unitName, emf);
            this.entityManagerFactoryUnitNames.add(unitName);
        }
    }

    public EntityManagerFactory getEntityManagerFactory(String unitName, BundleDescriptor declaringModule) {
        String lookupString = unitName;
        int separatorIndex = unitName.lastIndexOf(PERSISTENCE_UNIT_NAME_SEPARATOR);
        if (separatorIndex != -1) {
            String unqualifiedUnitName = unitName.substring(separatorIndex + 1);
            String path = unitName.substring(0, separatorIndex);
            String persistenceRootUri = this.getTargetUri(declaringModule, path);
            lookupString = persistenceRootUri + PERSISTENCE_UNIT_NAME_SEPARATOR + unqualifiedUnitName;
        }
        return this.entityManagerFactories.get(lookupString);
    }

    @Override
    public Set<EntityManagerFactory> getEntityManagerFactories() {
        return new HashSet<EntityManagerFactory>(this.entityManagerFactories.values());
    }

    @Override
    public Set<Role> getRoles() {
        HashSet<Role> roles = new HashSet<Role>();
        for (BundleDescriptor bd : this.getBundleDescriptors()) {
            if (bd == null) continue;
            roles.addAll(bd.getRoles());
        }
        return roles;
    }

    public Set<Role> getAppRoles() {
        if (this.appRoles == null) {
            this.appRoles = new HashSet<Role>();
        }
        return this.appRoles;
    }

    public void addAppRole(SecurityRoleDescriptor descriptor) {
        Role role = new Role(descriptor.getName());
        role.setDescription(descriptor.getDescription());
        this.getAppRoles().add(role);
    }

    @Override
    public void addRole(Role role) {
        for (BundleDescriptor bd : this.getBundleDescriptors()) {
            bd.addRole(role);
        }
    }

    @Override
    public void removeRole(Role role) {
        this.getAppRoles().remove(role);
        for (BundleDescriptor bd : this.getBundleDescriptors()) {
            bd.removeRole(role);
        }
    }

    @Override
    public void setName(String name) {
        name = name.replace('/', '-');
        name = name.replace('\\', '-');
        super.setName(name);
        if (this.getRoleMapper() != null) {
            this.getRoleMapper().setName(name);
        }
    }

    public void setLibraryDirectory(String value) {
        this.libraryDirectory = value;
    }

    public String getLibraryDirectory() {
        if (this.libraryDirectory != null) {
            return this.libraryDirectory.length() == 0 ? null : this.libraryDirectory;
        }
        return LIBRARY_DIRECTORY_DEFAULT_VALUE;
    }

    public String getLibraryDirectoryRawValue() {
        return this.libraryDirectory;
    }

    public void removeModule(ModuleDescriptor<BundleDescriptor> descriptor) {
        if (this.modules.contains(descriptor)) {
            if (descriptor.getDescriptor() != null) {
                descriptor.getDescriptor().setApplication(null);
            }
            this.modules.remove(descriptor);
        }
    }

    public void addModule(ModuleDescriptor<BundleDescriptor> descriptor) {
        this.modules.add(descriptor);
        if (descriptor.getDescriptor() != null) {
            descriptor.getDescriptor().setApplication(this);
        }
    }

    public Set<ModuleDescriptor<BundleDescriptor>> getModules() {
        return this.modules;
    }

    public String getTargetUri(BundleDescriptor origin, String relativeTargetUri) {
        String targetUri = null;
        try {
            String archiveUri = origin.getModuleDescriptor().getArchiveUri();
            URI originUri = new URI(archiveUri);
            URI resolvedUri = originUri.resolve(relativeTargetUri);
            targetUri = resolvedUri.getPath();
        }
        catch (URISyntaxException use) {
            _logger.log(Level.FINE, "origin " + origin + " has invalid syntax", use);
        }
        return targetUri;
    }

    public BundleDescriptor getRelativeBundle(BundleDescriptor origin, String relativeTargetUri) {
        String targetBundleUri = this.getTargetUri(origin, relativeTargetUri);
        BundleDescriptor targetBundle = null;
        if (targetBundleUri != null) {
            targetBundle = this.getModuleByUri(targetBundleUri);
        }
        return targetBundle;
    }

    public String getRelativeUri(BundleDescriptor origin, BundleDescriptor target) {
        String originUri = origin.getModuleDescriptor().getArchiveUri();
        String targetUri = target.getModuleDescriptor().getArchiveUri();
        StringTokenizer tokenizer = new StringTokenizer(originUri, "/");
        int numTokens = tokenizer.countTokens();
        int numSeparators = numTokens > 0 ? numTokens - 1 : 0;
        StringBuffer relativeUri = new StringBuffer();
        for (int i = 0; i < numSeparators; ++i) {
            relativeUri.append("../");
        }
        relativeUri.append(targetUri);
        return relativeUri.toString();
    }

    public ModuleDescriptor<BundleDescriptor> getModuleDescriptorByUri(String uri) {
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            if (!aModule.getArchiveUri().equals(uri)) continue;
            return aModule;
        }
        return null;
    }

    public Collection<ModuleDescriptor<BundleDescriptor>> getModuleDescriptorsByType(ArchiveType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        LinkedList<ModuleDescriptor<BundleDescriptor>> results = new LinkedList<ModuleDescriptor<BundleDescriptor>>();
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            if (!type2.equals(aModule.getModuleType())) continue;
            results.add(aModule);
        }
        return results;
    }

    public BundleDescriptor getModuleByUri(String uri) {
        ModuleDescriptor<BundleDescriptor> md = this.getModuleDescriptorByUri(uri);
        if (md != null) {
            return md.getDescriptor();
        }
        return null;
    }

    public <T extends BundleDescriptor> T getModuleByTypeAndUri(Class<T> type2, String uri) {
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            try {
                BundleDescriptor descriptor = (BundleDescriptor)type2.cast(aModule.getDescriptor());
                if (!descriptor.getModuleDescriptor().getArchiveUri().equals(uri)) continue;
                return (T)descriptor;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return null;
    }

    public EjbDescriptor getEjbByName(String ejbName) {
        for (EjbBundleDescriptor ejbd : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
            if (!ejbd.hasEjbByName(ejbName)) continue;
            return ejbd.getEjbByName(ejbName);
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnobeannamed", "This application has no beans of name {0}", ejbName));
    }

    public boolean hasEjbByName(String ejbName) {
        for (EjbBundleDescriptor ebd : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
            if (!ebd.hasEjbByName(ejbName)) continue;
            return true;
        }
        return false;
    }

    public BundleDescriptor getStandaloneBundleDescriptor() {
        if (this.isVirtual()) {
            if (this.getModules().size() > 1) {
                throw new IllegalStateException("Virtual application contains more than one module");
            }
            return this.getModules().iterator().next().getDescriptor();
        }
        return null;
    }

    public <T extends BundleDescriptor> Set<T> getBundleDescriptors(Class<T> type2) {
        if (type2 == null) {
            return null;
        }
        OrderedSet bundleSet = new OrderedSet();
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            try {
                BundleDescriptor descriptor = (BundleDescriptor)type2.cast(aModule.getDescriptor());
                bundleSet.add(descriptor);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (aModule.getDescriptor() == null) continue;
            bundleSet.addAll(aModule.getDescriptor().getExtensionsDescriptors(type2));
        }
        return bundleSet;
    }

    public Set<BundleDescriptor> getBundleDescriptorsOfType(ArchiveType bundleType) {
        if (bundleType == null) {
            return Collections.emptySet();
        }
        OrderedSet<BundleDescriptor> bundleSet = new OrderedSet<BundleDescriptor>();
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            if (((RootDeploymentDescriptor)aModule.getDescriptor()).getModuleType() == bundleType) {
                bundleSet.add(aModule.getDescriptor());
            }
            for (RootDeploymentDescriptor rd : aModule.getDescriptor().getExtensionsDescriptors()) {
                if (!(rd instanceof BundleDescriptor) || ((BundleDescriptor)rd).getModuleType() != bundleType) continue;
                bundleSet.add((BundleDescriptor)rd);
            }
        }
        return bundleSet;
    }

    public Set<BundleDescriptor> getBundleDescriptors() {
        OrderedSet<BundleDescriptor> bundleSet = new OrderedSet<BundleDescriptor>();
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            BundleDescriptor bundleDesc = aModule.getDescriptor();
            if (bundleDesc != null) {
                bundleSet.add(bundleDesc);
                for (RootDeploymentDescriptor rd : bundleDesc.getExtensionsDescriptors()) {
                    if (!(rd instanceof BundleDescriptor)) continue;
                    bundleSet.add((BundleDescriptor)rd);
                }
                continue;
            }
            DOLUtils.getDefaultLogger().fine("Null descriptor for module " + aModule.getArchiveUri());
        }
        return bundleSet;
    }

    @Override
    public void addBundleDescriptor(BundleDescriptor bundleDescriptor) {
        ModuleDescriptor newModule = bundleDescriptor.getModuleDescriptor();
        this.addModule(newModule);
    }

    public void removeBundleDescriptor(BundleDescriptor bundleDescriptor) {
        bundleDescriptor.setApplication(null);
        this.getBundleDescriptors().remove(bundleDescriptor);
    }

    public Vector<EjbDescriptor> getEjbDescriptors() {
        Vector<EjbDescriptor> ejbDescriptors = new Vector<EjbDescriptor>();
        for (EjbBundleDescriptor ejbBundleDescriptor : this.getBundleDescriptors(EjbBundleDescriptor.class)) {
            ejbDescriptors.addAll(ejbBundleDescriptor.getEjbs());
        }
        return ejbDescriptors;
    }

    public EjbDescriptor[] getSortedEjbDescriptors() {
        Vector<EjbDescriptor> ejbDesc = this.getEjbDescriptors();
        EjbDescriptor[] descs = ejbDesc.toArray(new EjbDescriptor[ejbDesc.size()]);
        Arrays.sort(descs, new Comparator(){

            public int compare(Object o1, Object o2) {
                EjbDescriptor desc1 = (EjbDescriptor)o1;
                EjbDescriptor desc2 = (EjbDescriptor)o2;
                String moduleUri1 = desc1.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                String moduleUri2 = desc2.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
                return (moduleUri1 + desc1.getName()).compareTo(moduleUri2 + desc2.getName());
            }
        });
        return descs;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isUniqueIdSet() {
        return this.uniqueIdSet;
    }

    public void setUniqueId(long id) {
        _logger.log(Level.FINE, "[Application] " + this.getName() + " , uid: " + id);
        this.uniqueId = id;
        EjbDescriptor[] descs = this.getSortedEjbDescriptors();
        TreeSet<Long> uniqueIds = new TreeSet<Long>();
        for (int i = 0; i < descs.length; ++i) {
            String module = descs[i].getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
            long uid = Math.abs(UUID.nameUUIDFromBytes((module.replaceFirst("\\..*", "") + descs[i].getName()).getBytes()).getLeastSignificantBits() % 65536L);
            while (uniqueIds.contains(uid)) {
                ++uid;
                uid %= 65536L;
            }
            uniqueIds.add(uid);
            descs[i].setUniqueId(id | uid);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, "Ejb  " + module + ":" + descs[i].getName() + " id = " + descs[i].getUniqueId());
        }
        this.uniqueIdSet = true;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setPassByReference(boolean passByReference) {
        this.passByReference = passByReference;
    }

    public boolean getPassByReference() {
        boolean passByReference = false;
        if (this.isPassByReferenceDefined()) {
            passByReference = this.passByReference;
        }
        return passByReference;
    }

    public boolean isPassByReferenceDefined() {
        boolean passByReferenceDefined = false;
        if (this.passByReference != null) {
            passByReferenceDefined = true;
        }
        return passByReferenceDefined;
    }

    public void addApplication(Application application) {
        for (ModuleDescriptor<BundleDescriptor> md : application.getModules()) {
            this.addModule(md);
        }
    }

    public Set getArchivableDescriptors() {
        OrderedSet archivableDescriptors = new OrderedSet();
        archivableDescriptors.addAll(this.getBundleDescriptors());
        return archivableDescriptors;
    }

    public void setRoleMapper(SecurityRoleMapper roleMapper) {
        this.roleMapper = roleMapper;
    }

    public boolean hasRuntimeInformation() {
        return true;
    }

    @Override
    public SecurityRoleMapper getRoleMapper() {
        if (this.roleMapper == null) {
            if (this.securityRoleMapperFactory == null) {
                _logger.log(Level.FINE, "SecurityRoleMapperFactory NOT set.");
            } else {
                this.roleMapper = this.securityRoleMapperFactory.getRoleMapper(this.getName());
            }
        }
        return this.roleMapper;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Application");
        toStringBuffer.append("\n");
        super.print(toStringBuffer);
        toStringBuffer.append("\n smallIcon ").append(super.getSmallIconUri());
        for (ModuleDescriptor<BundleDescriptor> aModule : this.getModules()) {
            toStringBuffer.append("\n  Module : ");
            aModule.print(toStringBuffer);
        }
        toStringBuffer.append("\n Bundles: \n");
        if (this.getBundleDescriptors() != null) {
            this.printDescriptorSet(this.getBundleDescriptors(), toStringBuffer);
        }
        toStringBuffer.append("\n roles ").append(this.getRoles());
        toStringBuffer.append("\n RoleMapper ").append(this.getRoleMapper());
        toStringBuffer.append("\n Realm ").append(this.realm);
    }

    private void printDescriptorSet(Set descSet, StringBuffer sbuf) {
        for (Object obj : descSet) {
            if (obj instanceof Descriptor) {
                ((Descriptor)obj).print(sbuf);
                continue;
            }
            sbuf.append(obj);
        }
    }

    @Override
    public void visit(DescriptorVisitor aVisitor) {
        if (aVisitor instanceof ApplicationVisitor) {
            this.visit((ComponentVisitor)aVisitor);
        } else {
            super.visit(aVisitor);
        }
    }

    @Override
    public String getModuleID() {
        if (this.appName != null) {
            return this.appName;
        }
        return this.moduleID;
    }

    @Override
    public boolean isApplication() {
        return true;
    }

    @Override
    public ArchiveType getModuleType() {
        return DOLUtils.earType();
    }

    public void addSecurityRoleMapping(SecurityRoleMapping roleMapping) {
        this.roleMaps.add(roleMapping);
    }

    public List<SecurityRoleMapping> getSecurityRoleMappings() {
        return this.roleMaps;
    }

    public List<SecurityRoleAssignment> getWlRoleAssignments() {
        return this.wlRoleAssignments;
    }

    public void addWLRoleAssignments(SecurityRoleAssignment wlRoleAssignment) {
        this.wlRoleAssignments.add(wlRoleAssignment);
    }

    public void setLoadedFromApplicationXml(boolean bool) {
        this.loadedFromApplicationXml = bool;
    }

    public boolean isLoadedFromApplicationXml() {
        return this.loadedFromApplicationXml;
    }

    public void addResourceAdapter(String raName) {
        this.resourceAdapters.add(raName);
    }

    public Set<String> getResourceAdapters() {
        return this.resourceAdapters;
    }

    public Set<ApplicationParam> getApplicationParams() {
        return this.applicationParams;
    }

    public void addApplicationParam(ApplicationParam appParam) {
        this.applicationParams.add(appParam);
    }

    @Override
    public boolean getKeepState() {
        BundleDescriptor bundleDesc;
        if (this.isVirtual() && (bundleDesc = this.getStandaloneBundleDescriptor()) != null) {
            return bundleDesc.getKeepState();
        }
        return super.getKeepState();
    }

    public boolean getKeepStateResolved() {
        return this.keepStateResolved;
    }

    public void setKeepStateResolved(String keepStateResolved) {
        this.keepStateResolved = Boolean.valueOf(keepStateResolved);
    }
}

