/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.admin.util.AsadminTrustManager;
import com.sun.enterprise.admin.util.AuthenticationInfo;
import com.sun.enterprise.universal.GFBase64Encoder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public final class HttpConnectorAddress {
    static final String HTTP_CONNECTOR = "http";
    static final String HTTPS_CONNECTOR = "https";
    public static final String AUTHORIZATION_KEY = "Authorization";
    private static final String AUTHORIZATION_TYPE = "Basic ";
    private String host;
    private int port;
    private String path;
    private boolean secure;
    private AuthenticationInfo authInfo;
    private boolean interactive = true;
    private SSLSocketFactory sslSocketFactory;
    private static final Logger logger = AdminLoggerInfo.getLogger();

    public HttpConnectorAddress() {
    }

    public HttpConnectorAddress(String host, int port) {
        this(host, port, false);
    }

    public HttpConnectorAddress(String host, int port, boolean secure) {
        this(host, port, secure, null);
    }

    public HttpConnectorAddress(String host, int port, boolean secure, String path) {
        this(host, port, secure, path, null);
    }

    public HttpConnectorAddress(String host, int port, SSLSocketFactory sslSocketFactory) {
        this(host, port, true, null, sslSocketFactory);
    }

    public HttpConnectorAddress(String host, int port, boolean secure, String path, SSLSocketFactory sslSocketFactory) {
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.path = path;
        this.sslSocketFactory = sslSocketFactory;
    }

    public URLConnection openConnection(String path) throws IOException {
        URLConnection cnx;
        if (path == null || path.trim().length() == 0) {
            path = this.path;
        }
        if (!((cnx = this.openConnection(this.toURL(path))) instanceof HttpsURLConnection)) {
            return cnx;
        }
        this.configureSSL((HttpsURLConnection)cnx);
        return cnx;
    }

    private void configureSSL(HttpsURLConnection httpsCnx) throws IOException {
        httpsCnx.setHostnameVerifier(new BasicHostnameVerifier(this.host));
        httpsCnx.setSSLSocketFactory(this.getOrCreateSSLSocketFactory());
    }

    private synchronized SSLSocketFactory getOrCreateSSLSocketFactory() throws IOException {
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = this.createAdminSSLSocketFactory(null, null);
        }
        return this.sslSocketFactory;
    }

    private SSLSocketFactory createAdminSSLSocketFactory(String alias, String protocol) {
        try {
            if (protocol == null) {
                if (System.getProperty("fish.payara.clientHttpsProtocol") != null) {
                    switch (System.getProperty("fish.payara.clientHttpsProtocol")) {
                        case "TLSv1": {
                            protocol = "TLSV1";
                            logger.log(Level.FINE, "NCLS-ADMIN-00021", protocol);
                            break;
                        }
                        case "TLSv1.1": {
                            protocol = "TLSv1.1";
                            logger.log(Level.FINE, "NCLS-ADMIN-00021", protocol);
                            break;
                        }
                        case "TLSv1.2": {
                            protocol = "TLSv1.2";
                            logger.log(Level.FINE, "NCLS-ADMIN-00021", protocol);
                            break;
                        }
                        default: {
                            protocol = "TLSv1.2";
                            Object[] logParams = new String[]{protocol, System.getProperty("fish.payara.clientHttpsProtocol")};
                            logger.log(Level.INFO, "NCLS-ADMIN-00019", logParams);
                            break;
                        }
                    }
                } else {
                    protocol = "TLSv1.2";
                    logger.log(Level.FINE, "NCLS-ADMIN-00020", protocol);
                }
            }
            SSLContext cntxt = SSLContext.getInstance(protocol);
            AsadminTrustManager atm = new AsadminTrustManager();
            atm.setInteractive(this.interactive);
            cntxt.init(null, new TrustManager[]{atm}, null);
            return cntxt.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getConnectorType() {
        return this.isSecure() ? HTTPS_CONNECTOR : HTTP_CONNECTOR;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path == null ? "/" : this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authInfo;
    }

    public void setAuthenticationInfo(AuthenticationInfo authInfo) {
        this.authInfo = authInfo;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setInteractive(boolean mode) {
        this.interactive = mode;
    }

    public URL toURL(String path) throws MalformedURLException {
        return new URL(this.getConnectorType(), this.getHost(), this.getPort(), path == null ? "" : path);
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    private String getUser() {
        return this.authInfo != null ? this.authInfo.getUser() : "";
    }

    private String getPassword() {
        return this.authInfo != null ? this.authInfo.getPassword() : "";
    }

    private URLConnection openConnection(URL url) throws IOException {
        return this.setOptions(this.makeConnection(url));
    }

    private URLConnection makeConnection(URL url) throws IOException {
        return url.openConnection();
    }

    private URLConnection setOptions(URLConnection uc) {
        uc.setDoOutput(true);
        uc.setUseCaches(false);
        uc.setRequestProperty("Connection", "Keep-Alive");
        return this.setAuthentication(uc);
    }

    private URLConnection setAuthentication(URLConnection uc) {
        if (this.authInfo != null) {
            uc.setRequestProperty(AUTHORIZATION_KEY, this.getBasicAuthString());
        }
        return uc;
    }

    public final String getBasicAuthString() {
        String cs = null;
        String user = this.getUser();
        String pass = this.getPassword();
        String up = user == null ? "" : user;
        String pp = pass == null ? "" : pass;
        cs = up + ":" + pp;
        String enc = this.getBase64Encoded(cs);
        enc = enc.replaceAll(System.getProperty("line.separator"), "");
        return AUTHORIZATION_TYPE + enc;
    }

    private String getBase64Encoded(String clearString) {
        return new GFBase64Encoder().encode(clearString.getBytes());
    }

    public static class BasicHostnameVerifier
    implements HostnameVerifier {
        private final String host;

        public BasicHostnameVerifier(String host) {
            if (host == null) {
                throw new IllegalArgumentException("null host");
            }
            this.host = host;
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return this.host.equals(s);
        }
    }
}

