/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.CreateLocalInstanceFilesystemCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.FileProtectionUtility;
import org.jvnet.hk2.annotations.Service;

@Service(name="create-local-instance")
@PerLookup
@I18n(value="create.local.instance")
public final class CreateLocalInstanceCommand
extends CreateLocalInstanceFilesystemCommand {
    private final String CONFIG = "config";
    private final String CLUSTER = "cluster";
    private static final LocalStringsImpl strings = new LocalStringsImpl(CreateLocalInstanceCommand.class);
    @Param(name="config", optional=true)
    private String configName;
    @Param(name="cluster", optional=true)
    private String clusterName;
    @Param(name="lbenabled", optional=true)
    private Boolean lbEnabled;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    @Param(name="portbase", optional=true)
    private String portBase;
    @Param(name="checkports", optional=true, defaultValue="true")
    private boolean checkPorts = true;
    @Param(name="savemasterpassword", optional=true, defaultValue="false")
    private boolean saveMasterPassword = false;
    @Param(name="usemasterpassword", optional=true, defaultValue="false")
    private boolean useMasterPassword = false;
    private String masterPassword = null;
    private static final String RENDEZVOUS_PROPERTY_NAME = "rendezvousOccurred";
    private String INSTANCE_DOTTED_NAME;
    private String RENDEZVOUS_DOTTED_NAME;
    private boolean _rendezvousOccurred;
    private String _node;
    private static final String DEFAULT_MASTER_PASSWORD = "changeit";
    private CommandModelData.ParamModelData masterPasswordOption;
    private static final String MASTER_PASSWORD_ALIAS = "master-password";

    @Override
    protected void validate() throws CommandException {
        this.echoCommand();
        if (this.configName != null && this.clusterName != null) {
            throw new CommandException(Strings.get("ConfigClusterConflict"));
        }
        if (this.lbEnabled != null && this.clusterName == null) {
            throw new CommandException(Strings.get("lbenabledNotForStandaloneInstance"));
        }
        this.setDasDefaultsOnly = true;
        super.validate();
        if (this.node != null) {
            String nodeInstallDir = this.getNodeInstallDir();
            if (nodeInstallDir == null || nodeInstallDir.isEmpty() || TokenResolver.hasToken(nodeInstallDir) || OS.isWindows()) {
                this.validateNode(this.node, this.getProductRootPath(), this.getInstanceHostName(true));
            } else {
                this.validateNodeInstallDirLocal(nodeInstallDir, this.getProductRootPath());
                this.validateNode(this.node, null, this.getInstanceHostName(true));
            }
        }
        if (!this.rendezvousWithDAS()) {
            throw new CommandException(Strings.get("Instance.rendezvousFailed", this.DASHost, "" + this.DASPort));
        }
        if (this.instanceName != null && this.instanceName.equals("server")) {
            throw new CommandException(Strings.get("Instance.alreadyExists", "server"));
        }
        this.setDomainName();
        this.setDasDefaultsOnly = false;
        super.validate();
        this.INSTANCE_DOTTED_NAME = "servers.server." + this.instanceName;
        this.RENDEZVOUS_DOTTED_NAME = this.INSTANCE_DOTTED_NAME + ".property." + RENDEZVOUS_PROPERTY_NAME;
        this._rendezvousOccurred = this.rendezvousOccurred();
        if (this._rendezvousOccurred) {
            throw new CommandException(Strings.get("Instance.rendezvousAlready", this.instanceName));
        }
    }

    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        int exitCode = -1;
        if (this.node == null) {
            if (this.nodeDirChild == null) {
                throw new CommandException(Strings.get("internal.error", "nodeDirChild was null.  The Base Class is supposed to guarantee that this won't happen"));
            }
            this._node = this.nodeDirChild.getName();
            String nodeHost = this.getInstanceHostName(true);
            this.createNodeImplicit(this._node, this.getProductRootPath(), nodeHost);
        } else {
            this._node = this.node;
        }
        if (this.isRegisteredToDAS()) {
            if (!this._rendezvousOccurred) {
                this.setRendezvousOccurred("true");
                this._rendezvousOccurred = true;
            }
        } else {
            this.validateInstanceDirUnique();
            try {
                this.registerToDAS();
                this._rendezvousOccurred = true;
            }
            catch (CommandException ce) {
                FileUtils.deleteFileNowOrLater(this.instanceDir);
                throw ce;
            }
        }
        this.bootstrapSecureAdminFiles();
        try {
            exitCode = super.executeCommand();
            if (exitCode == 0) {
                this.saveMasterPassword();
            }
        }
        catch (CommandException ce) {
            String msg = "Something went wrong in creating the local filesystem for instance " + this.instanceName;
            if (ce.getLocalizedMessage() != null) {
                msg = msg + ": " + ce.getLocalizedMessage();
            }
            logger.severe(msg);
            this.setRendezvousOccurred("false");
            this._rendezvousOccurred = false;
            throw new CommandException(msg, ce);
        }
        return exitCode;
    }

    private void validateInstanceDirUnique() throws CommandException {
        String[] registeredInstanceNamesOnThisNode;
        RemoteCLICommand rc = new RemoteCLICommand("list-instances", this.programOpts, this.env);
        String returnOutput = rc.executeAndReturnOutput("list-instances", "--nostatus", this._node);
        if (returnOutput == null) {
            return;
        }
        for (String registeredInstanceName : registeredInstanceNamesOnThisNode = returnOutput.split("\r?\n")) {
            File instanceListDir = new File(this.nodeDirChild, registeredInstanceName);
            if (this.instanceName == null || !registeredInstanceName.equalsIgnoreCase(this.instanceName) || this.instanceDir == null || !instanceListDir.equals(this.instanceDir)) continue;
            throw new CommandException(Strings.get("Instance.duplicateInstanceDir", this.instanceName, registeredInstanceName));
        }
    }

    private int bootstrapSecureAdminFiles() throws CommandException {
        RemoteCLICommand rc = new RemoteCLICommand("_bootstrap-secure-admin", this.programOpts, this.env);
        rc.setFileOutputDirectory(this.instanceDir);
        int result = rc.execute("_bootstrap-secure-admin");
        return result;
    }

    private void saveMasterPassword() throws CommandException {
        this.masterPasswordOption = new CommandModelData.ParamModelData("AS_ADMIN_MASTERPASSWORD", String.class, false, null);
        this.masterPasswordOption.prompt = Strings.get("MasterPassword");
        this.masterPasswordOption.promptAgain = Strings.get("MasterPasswordAgain");
        this.masterPasswordOption.param._password = true;
        if (this.saveMasterPassword) {
            this.useMasterPassword = true;
        }
        if (this.useMasterPassword) {
            this.masterPassword = this.getPassword(this.masterPasswordOption, DEFAULT_MASTER_PASSWORD, true);
        }
        if (this.masterPassword == null) {
            this.masterPassword = DEFAULT_MASTER_PASSWORD;
        }
        if (this.saveMasterPassword) {
            File mp = new File(new File(this.getServerDirs().getServerDir(), "config"), "keystore.jks");
            if (mp.canRead()) {
                if (this.verifyMasterPassword(this.masterPassword)) {
                    this.createMasterPasswordFile(this.masterPassword);
                } else {
                    logger.info(Strings.get("masterPasswordIncorrect"));
                }
            } else {
                this.createMasterPasswordFile(this.masterPassword);
            }
        }
    }

    protected void createMasterPasswordFile(String masterPassword) throws CommandException {
        File pwdFile = new File(this.getServerDirs().getAgentDir(), MASTER_PASSWORD_ALIAS);
        try {
            PasswordAdapter p = new PasswordAdapter(pwdFile.getAbsolutePath(), MASTER_PASSWORD_ALIAS.toCharArray());
            p.setPasswordForAlias(MASTER_PASSWORD_ALIAS, masterPassword.getBytes());
            FileProtectionUtility.chmod0600(pwdFile);
        }
        catch (Exception ex) {
            throw new CommandException(Strings.get("masterPasswordFileNotCreated", pwdFile), ex);
        }
    }

    private boolean rendezvousWithDAS() {
        try {
            this.getUptime();
            logger.info(Strings.get("Instance.rendezvousSuccess", this.DASHost, "" + this.DASPort));
            return true;
        }
        catch (CommandException ex) {
            return false;
        }
    }

    private int registerToDAS() throws CommandException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(0, "_register-instance");
        if (this.clusterName != null) {
            argsList.add("--cluster");
            argsList.add(this.clusterName);
        }
        if (this.lbEnabled != null) {
            argsList.add("--lbenabled");
            argsList.add(this.lbEnabled.toString());
        }
        if (this.configName != null) {
            argsList.add("--config");
            argsList.add(this.configName);
        }
        if (this._node != null) {
            argsList.add("--node");
            argsList.add(this._node);
        }
        argsList.add("--checkports");
        argsList.add(String.valueOf(this.checkPorts));
        if (this.portBase != null) {
            argsList.add("--portbase");
            argsList.add(this.portBase);
        }
        if (this.systemProperties != null) {
            argsList.add("--systemproperties");
            argsList.add(this.systemProperties);
        }
        argsList.add("--properties");
        argsList.add("rendezvousOccurred=true");
        argsList.add(this.instanceName);
        String[] argsArray = new String[argsList.size()];
        argsArray = argsList.toArray(argsArray);
        RemoteCLICommand rc = new RemoteCLICommand("_register-instance", this.programOpts, this.env);
        return rc.execute(argsArray);
    }

    private boolean isRegisteredToDAS() {
        boolean isRegistered = false;
        try {
            RemoteCLICommand rc = new RemoteCLICommand("get", this.programOpts, this.env);
            rc.executeAndReturnOutput("get", this.INSTANCE_DOTTED_NAME);
            isRegistered = true;
        }
        catch (CommandException ex) {
            logger.log(Level.FINER, "{0} is not yet registered to DAS.", this.instanceName);
            isRegistered = false;
        }
        return isRegistered;
    }

    private boolean rendezvousOccurred() {
        boolean rendezvousOccurred = false;
        RemoteCLICommand rc = null;
        try {
            rc = new RemoteCLICommand("get", this.programOpts, this.env);
            String s = rc.executeAndReturnOutput("get", this.RENDEZVOUS_DOTTED_NAME);
            String val = s.substring(s.indexOf("=") + 1);
            rendezvousOccurred = Boolean.parseBoolean(val);
            logger.log(Level.FINER, "rendezvousOccurred = {0} for instance {1}", new Object[]{val, this.instanceName});
        }
        catch (CommandException ce) {
            logger.log(Level.FINER, "rendezvousOccurred property may not be set yet on {0}", this.instanceName);
        }
        return rendezvousOccurred;
    }

    private void setRendezvousOccurred(String rendezVal) throws CommandException {
        String dottedName = this.RENDEZVOUS_DOTTED_NAME + "=" + rendezVal;
        RemoteCLICommand rc = new RemoteCLICommand("set", this.programOpts, this.env);
        logger.log(Level.FINER, "Setting rendezvousOccurred to {0} for instance {1}", new Object[]{rendezVal, this.instanceName});
        rc.executeAndReturnOutput("set", dottedName);
    }

    private int createNodeImplicit(String name, String installdir, String nodeHost) throws CommandException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(0, "_create-node-implicit");
        if (name != null) {
            argsList.add("--name");
            argsList.add(name);
        }
        if (this.nodeDir != null) {
            argsList.add("--nodedir");
            argsList.add(this.nodeDir);
        }
        if (installdir != null) {
            argsList.add("--installdir");
            argsList.add(installdir);
        }
        argsList.add(nodeHost);
        String[] argsArray = new String[argsList.size()];
        argsArray = argsList.toArray(argsArray);
        RemoteCLICommand rc = new RemoteCLICommand("_create-node-implicit", this.programOpts, this.env);
        return rc.execute(argsArray);
    }

    private int validateNode(String name, String installdir, String nodeHost) throws CommandException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(0, "_validate-node");
        if (this.nodeDir != null) {
            argsList.add("--nodedir");
            argsList.add(this.nodeDir);
        }
        if (nodeHost != null) {
            argsList.add("--nodehost");
            argsList.add(nodeHost);
        }
        if (installdir != null) {
            argsList.add("--installdir");
            argsList.add(installdir);
        }
        argsList.add(name);
        String[] argsArray = new String[argsList.size()];
        argsArray = argsList.toArray(argsArray);
        RemoteCLICommand rc = new RemoteCLICommand("_validate-node", this.programOpts, this.env);
        return rc.execute(argsArray);
    }

    private void validateNodeInstallDirLocal(String nodeInstallDir, String installDir) throws CommandValidationException {
        String canonicalNodeInstallDir = FileUtils.safeGetCanonicalPath(new File(nodeInstallDir));
        String canonicalInstallDir = FileUtils.safeGetCanonicalPath(new File(installDir));
        if (canonicalNodeInstallDir == null || canonicalInstallDir == null) {
            throw new CommandValidationException(Strings.get("Instance.installdir.null", this.node, canonicalInstallDir, canonicalNodeInstallDir));
        }
        if (!canonicalInstallDir.equals(canonicalNodeInstallDir)) {
            throw new CommandValidationException(Strings.get("Instance.installdir.mismatch", this.node, canonicalInstallDir, canonicalNodeInstallDir));
        }
    }

    private String getInstanceHostName(boolean isCanonical) throws CommandException {
        String instanceHostName = null;
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new CommandException(Strings.get("cantGetHostName", ex));
        }
        if (localHost != null) {
            instanceHostName = isCanonical ? localHost.getCanonicalHostName() : localHost.getHostName();
        }
        return instanceHostName;
    }

    private void setDomainName() throws CommandException {
        RemoteCLICommand rc = new RemoteCLICommand("_get-runtime-info", this.programOpts, this.env);
        ActionReport report = rc.executeAndReturnActionReport("_get-runtime-info", "--target", "server");
        this.domainName = report.findProperty("domain_name");
    }

    @Override
    protected boolean mkdirs(File f) {
        if (this.setDasDefaultsOnly) {
            return true;
        }
        return f.mkdirs();
    }

    @Override
    protected boolean isDirectory(File f) {
        if (this.setDasDefaultsOnly) {
            return true;
        }
        return f.isDirectory();
    }

    @Override
    protected boolean setServerDirs() {
        return !this.setDasDefaultsOnly;
    }

    private void echoCommand() {
        if (this.programOpts.isEcho()) {
            logger.info(this.toString());
            this.programOpts.setEcho(false);
        }
    }
}

