/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="exec-pool-mon", group="monitoring", isSingleton=false)
@ManagedObject
@Description(value="ThreadPoolExecutor Statistics")
public class EjbThreadPoolExecutorStatsProvider {
    private final ThreadPoolExecutor threadPoolExecutor;
    private final String poolName;
    private final EjbContainerUtil ejbContainerUtilImpl;
    private boolean registered = false;
    private CountStatisticImpl NumActiveThreads = new CountStatisticImpl("ActiveNumThreads", "count", "Number of active threads in the associated pool");
    private CountStatisticImpl NumTasksCompleted = new CountStatisticImpl("NumTasksCompleted", "count", "Number of tasks completed in the associated pool");
    private CountStatisticImpl corePoolSize = new CountStatisticImpl("CoreNumThreads", "count", "Core number of threads in the associated pool");
    private CountStatisticImpl keepAliveTime = new CountStatisticImpl("KeepAliveTime", "Milliseconds", "Keep-Alive time for threads in the associated pool");
    private CountStatisticImpl largestPoolSize = new CountStatisticImpl("LargestNumThreads", "count", "Largest number of simultaneous threads in the associated pool");
    private CountStatisticImpl maxPoolSize = new CountStatisticImpl("MaxNumThreads", "count", "Maximum number of threads in the associated pool");
    private CountStatisticImpl poolSize = new CountStatisticImpl("NumThreads", "count", "Current number of threads in the associated pool");
    private CountStatisticImpl tasksCreated = new CountStatisticImpl("TotalTasksCreated", "count", "Number of tasks created in the associated pool");

    public EjbThreadPoolExecutorStatsProvider(String poolName) {
        this.poolName = poolName != null ? poolName : "default-exec-pool";
        this.ejbContainerUtilImpl = EjbContainerUtilImpl.getInstance();
        this.threadPoolExecutor = this.ejbContainerUtilImpl.getThreadPoolExecutor(poolName);
    }

    public void register() {
        String node = EjbMonitoringUtils.registerSingleComponent(this.poolName, this);
        if (node != null) {
            this.registered = true;
        }
    }

    public void unregister() {
        if (this.registered) {
            this.registered = false;
            StatsProviderManager.unregister(this);
        }
    }

    @ManagedAttribute(id="activenumthreads")
    @Description(value="Number of active threads in the associated pool")
    public CountStatistic getActiveThreads() {
        this.NumActiveThreads.setCount(this.threadPoolExecutor.getActiveCount());
        return this.NumActiveThreads;
    }

    @ManagedAttribute(id="numtaskscompleted")
    @Description(value="Number of tasks completed in the associated pool")
    public CountStatistic getTasksCompleted() {
        this.NumTasksCompleted.setCount(this.threadPoolExecutor.getCompletedTaskCount());
        return this.NumTasksCompleted;
    }

    @ManagedAttribute(id="corenumthreads")
    @Description(value="Core number of threads in the associated pool")
    public CountStatistic getCorePoolSize() {
        this.corePoolSize.setCount(this.threadPoolExecutor.getCorePoolSize());
        return this.corePoolSize;
    }

    @ManagedAttribute(id="keepalivetime")
    @Description(value="Keep-Alive time for threads in the associated pool")
    public CountStatistic getKeepAlive() {
        this.keepAliveTime.setCount(this.threadPoolExecutor.getKeepAliveTime(TimeUnit.MILLISECONDS));
        return this.keepAliveTime;
    }

    @ManagedAttribute(id="largestnumthreads")
    @Description(value="Largest number of simultaneous threads in the associated pool")
    public CountStatistic getLargestPoolSize() {
        this.largestPoolSize.setCount(this.threadPoolExecutor.getLargestPoolSize());
        return this.largestPoolSize;
    }

    @ManagedAttribute(id="maxnumthreads")
    @Description(value="Maximum number of threads in the associated pool")
    public CountStatistic getMaxPoolSize() {
        this.maxPoolSize.setCount(this.threadPoolExecutor.getMaximumPoolSize());
        return this.maxPoolSize;
    }

    @ManagedAttribute(id="numthreads")
    @Description(value="Current number of threads in the associated pool")
    public CountStatistic getPoolSize() {
        this.poolSize.setCount(this.threadPoolExecutor.getPoolSize());
        return this.poolSize;
    }

    @ManagedAttribute(id="totaltaskscreated")
    @Description(value="Number of tasks created in the associated pool")
    public CountStatistic getTasksCreated() {
        this.tasksCreated.setCount(this.threadPoolExecutor.getTaskCount());
        return this.tasksCreated;
    }
}

