/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.waitnotifyservice.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.WaitSupport;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import java.util.Queue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

class WaitingOperation
extends AbstractOperation
implements Delayed,
PartitionAwareOperation {
    final Queue<WaitingOperation> queue;
    final Operation op;
    final WaitSupport waitSupport;
    final long expirationTime;
    volatile boolean valid = true;
    volatile Object cancelResponse;

    WaitingOperation(Queue<WaitingOperation> queue, WaitSupport waitSupport) {
        this.op = (Operation)((Object)waitSupport);
        this.waitSupport = waitSupport;
        this.queue = queue;
        this.expirationTime = this.getExpirationTime(waitSupport);
        this.setPartitionId(this.op.getPartitionId());
    }

    private long getExpirationTime(WaitSupport waitSupport) {
        long waitTimeout = waitSupport.getWaitTimeout();
        if (waitTimeout < 0L) {
            return -1L;
        }
        long expirationTime = Clock.currentTimeMillis() + waitTimeout;
        if (expirationTime < 0L) {
            return -1L;
        }
        return expirationTime;
    }

    public Operation getOperation() {
        return this.op;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean needsInvalidation() {
        return this.isExpired() || this.isCancelled() || this.isCallTimedOut();
    }

    public boolean isExpired() {
        return this.expirationTime > 0L && Clock.currentTimeMillis() >= this.expirationTime;
    }

    public boolean isCancelled() {
        return this.cancelResponse != null;
    }

    public boolean isCallTimedOut() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        InternalOperationService operationService = nodeEngine.getOperationService();
        if (operationService.isCallTimedOut(this.op)) {
            this.cancel(new CallTimeoutResponse(this.op.getCallId(), this.op.isUrgent()));
            return true;
        }
        return false;
    }

    public boolean shouldWait() {
        return this.waitSupport.shouldWait();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.expirationTime - Clock.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        if (other == this) {
            return 0;
        }
        long d = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
        return d == 0L ? 0 : (d < 0L ? -1 : 1);
    }

    @Override
    public void run() throws Exception {
        if (!this.valid) {
            return;
        }
        boolean expired = this.isExpired();
        boolean cancelled = this.isCancelled();
        if (!expired && !cancelled) {
            return;
        }
        if (!this.queue.remove(this)) {
            return;
        }
        this.valid = false;
        if (expired) {
            this.waitSupport.onWaitExpire();
        } else {
            OperationResponseHandler responseHandler = this.op.getOperationResponseHandler();
            responseHandler.sendResponse(this.op, this.cancelResponse);
        }
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public void logError(Throwable e) {
        ILogger logger2 = this.getLogger();
        if (e instanceof RetryableException) {
            logger2.warning("Op: " + this.op + ", " + e.getClass().getName() + ": " + e.getMessage());
        } else if (e instanceof OutOfMemoryError) {
            try {
                logger2.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
        } else {
            logger2.severe("Op: " + this.op + ", Error: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return this.op.getServiceName();
    }

    public void onExpire() {
        this.waitSupport.onWaitExpire();
    }

    public void cancel(Object error) {
        this.cancelResponse = error;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", op=").append(this.op);
        sb.append(", expirationTime=").append(this.expirationTime);
        sb.append(", valid=").append(this.valid);
    }
}

