/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.packetdispatcher.impl;

import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.impl.PacketHandler;
import com.hazelcast.spi.impl.packetdispatcher.PacketDispatcher;

public class PacketDispatcherImpl
implements PacketDispatcher {
    private final ILogger logger;
    private final PacketHandler eventPacketHandler;
    private final PacketHandler wanReplicationPacketHandler;
    private final PacketHandler operationPacketHandler;
    private final PacketHandler connectionPacketHandler;

    public PacketDispatcherImpl(ILogger logger2, PacketHandler operationPacketHandler, PacketHandler eventPacketHandler, PacketHandler wanReplicationPacketHandler, PacketHandler connectionPacketHandler) {
        this.logger = logger2;
        this.operationPacketHandler = operationPacketHandler;
        this.eventPacketHandler = eventPacketHandler;
        this.wanReplicationPacketHandler = wanReplicationPacketHandler;
        this.connectionPacketHandler = connectionPacketHandler;
    }

    @Override
    public void dispatch(Packet packet) {
        try {
            if (packet.isHeaderSet(0)) {
                this.operationPacketHandler.handle(packet);
            } else if (packet.isHeaderSet(2)) {
                this.eventPacketHandler.handle(packet);
            } else if (packet.isHeaderSet(3)) {
                this.wanReplicationPacketHandler.handle(packet);
            } else if (packet.isHeaderSet(5)) {
                this.connectionPacketHandler.handle(packet);
            } else {
                this.logger.severe("Unknown packet type! Header: " + packet.getHeader());
            }
        }
        catch (Throwable t) {
            OutOfMemoryErrorDispatcher.inspectOutputMemoryError(t);
            this.logger.severe("Failed to process packet:" + packet, t);
        }
    }
}

