/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.impl.BackpressureRegulator;
import com.hazelcast.spi.impl.operationservice.impl.CallIdSequence;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.responses.BackupResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.Response;
import com.hazelcast.util.counters.MwCounter;
import com.hazelcast.util.counters.SwCounter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InvocationRegistry {
    private static final int INITIAL_CAPACITY = 1000;
    private static final float LOAD_FACTOR = 0.75f;
    private static final double HUNDRED_PERCENT = 100.0;
    @Probe(name="invocations.pending", level=ProbeLevel.MANDATORY)
    private final ConcurrentMap<Long, Invocation> invocations;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final CallIdSequence callIdSequence;
    @Probe(name="response.normal.count", level=ProbeLevel.MANDATORY)
    private final SwCounter responseNormalCounter = SwCounter.newSwCounter();
    @Probe(name="response.timeout.count", level=ProbeLevel.MANDATORY)
    private final SwCounter responseTimeoutCounter = SwCounter.newSwCounter();
    @Probe(name="response.backup.count", level=ProbeLevel.MANDATORY)
    private final MwCounter responseBackupCounter = MwCounter.newMwCounter();
    @Probe(name="response.error.count", level=ProbeLevel.MANDATORY)
    private final SwCounter responseErrorCounter = SwCounter.newSwCounter();

    public InvocationRegistry(NodeEngineImpl nodeEngine, ILogger logger2, BackpressureRegulator backpressureRegulator, int concurrencyLevel) {
        this.nodeEngine = nodeEngine;
        this.logger = logger2;
        this.callIdSequence = backpressureRegulator.newCallIdSequence();
        this.invocations = new ConcurrentHashMap<Long, Invocation>(1000, 0.75f, concurrencyLevel);
        nodeEngine.getMetricsRegistry().scanAndRegister(this, "operation");
    }

    @Probe(name="invocations.usedPercentage")
    private double invocationsUsedPercentage() {
        int maxConcurrentInvocations = this.callIdSequence.getMaxConcurrentInvocations();
        if (maxConcurrentInvocations == Integer.MAX_VALUE) {
            return 0.0;
        }
        return 100.0 * (double)this.invocations.size() / (double)maxConcurrentInvocations;
    }

    @Probe(name="invocations.lastCallId")
    public long getLastCallId() {
        return this.callIdSequence.getLastCallId();
    }

    public void register(Invocation invocation) {
        assert (invocation.op.getCallId() == 0L) : "can't register twice: " + invocation;
        long callId = this.callIdSequence.next(invocation);
        OperationAccessor.setCallId(invocation.op, callId);
        if (callId == Long.MAX_VALUE) {
            return;
        }
        this.invocations.put(callId, invocation);
    }

    public void deregister(Invocation invocation) {
        boolean deleted;
        long callId = invocation.op.getCallId();
        this.callIdSequence.complete(invocation);
        OperationAccessor.setCallId(invocation.op, 0L);
        if (callId == 0L || callId == Long.MAX_VALUE) {
            return;
        }
        boolean bl = deleted = this.invocations.remove(callId) != null;
        if (!deleted && this.logger.isFinestEnabled()) {
            this.logger.finest("failed to deregister callId: " + callId + " " + invocation);
        }
    }

    public int size() {
        return this.invocations.size();
    }

    public Collection<Invocation> invocations() {
        return this.invocations.values();
    }

    public Set<Map.Entry<Long, Invocation>> entrySet() {
        return this.invocations.entrySet();
    }

    public Invocation get(long callId) {
        return (Invocation)this.invocations.get(callId);
    }

    public void notify(Response response, Address sender) {
        if (response instanceof NormalResponse) {
            this.notifyNormalResponse((NormalResponse)response, sender);
        } else if (response instanceof BackupResponse) {
            this.notifyBackupComplete(response.getCallId());
        } else if (response instanceof CallTimeoutResponse) {
            this.notifyCallTimeout((CallTimeoutResponse)response, sender);
        } else if (response instanceof ErrorResponse) {
            this.notifyErrorResponse((ErrorResponse)response, sender);
        } else {
            this.logger.severe("Unrecognized response: " + response);
        }
    }

    public void notifyBackupComplete(long callId) {
        this.responseBackupCounter.inc();
        try {
            Invocation invocation = (Invocation)this.invocations.get(callId);
            if (invocation == null) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("No Invocation found for BackupResponse with callId " + callId);
                }
                return;
            }
            invocation.notifySingleBackupComplete();
        }
        catch (Exception e) {
            ReplicaErrorLogger.log(e, this.logger);
        }
    }

    private void notifyErrorResponse(ErrorResponse response, Address sender) {
        this.responseErrorCounter.inc();
        Invocation invocation = (Invocation)this.invocations.get(response.getCallId());
        if (invocation == null) {
            if (this.nodeEngine.isRunning()) {
                this.logger.warning("No Invocation found for response: " + response + " sent from " + sender);
            }
            return;
        }
        invocation.notifyError(response.getCause());
    }

    private void notifyNormalResponse(NormalResponse response, Address sender) {
        this.responseNormalCounter.inc();
        Invocation invocation = (Invocation)this.invocations.get(response.getCallId());
        if (invocation == null) {
            if (this.nodeEngine.isRunning()) {
                this.logger.warning("No Invocation found for response: " + response + " sent from " + sender);
            }
            return;
        }
        invocation.notifyNormalResponse(response.getValue(), response.getBackupCount());
    }

    private void notifyCallTimeout(CallTimeoutResponse response, Address sender) {
        this.responseTimeoutCounter.inc();
        Invocation invocation = (Invocation)this.invocations.get(response.getCallId());
        if (invocation == null) {
            if (this.nodeEngine.isRunning()) {
                this.logger.warning("No Invocation found for response: " + response + " sent from " + sender);
            }
            return;
        }
        invocation.notifyCallTimeout();
    }

    public void reset() {
        for (Invocation invocation : this.invocations.values()) {
            try {
                invocation.notifyError(new MemberLeftException());
            }
            catch (Throwable e) {
                this.logger.warning(invocation + " could not be notified with reset message -> " + e.getMessage());
            }
        }
    }

    public void shutdown() {
        for (Invocation invocation : this.invocations.values()) {
            try {
                invocation.notifyError(new HazelcastInstanceNotActiveException());
            }
            catch (Throwable e) {
                this.logger.warning(invocation + " could not be notified with shutdown message -> " + e.getMessage(), e);
            }
        }
    }
}

