/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.ReplicatedMapCantBeCreatedOnLiteMemberException;
import com.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableEntryEvent;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableHook;
import com.hazelcast.replicatedmap.impl.record.ReplicatedEntryEventFilter;
import com.hazelcast.replicatedmap.impl.record.ReplicatedQueryEventFilter;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import java.io.IOException;
import java.security.Permission;

public class ClientReplicatedMapAddEntryListenerRequest
extends BaseClientAddListenerRequest {
    private String mapName;
    private Predicate predicate;
    private Data key;

    ClientReplicatedMapAddEntryListenerRequest() {
    }

    public ClientReplicatedMapAddEntryListenerRequest(String mapName, Predicate predicate, Data key) {
        this.mapName = mapName;
        this.predicate = predicate;
        this.key = key;
    }

    public Object call() throws Exception {
        if (this.getClientEngine().getConfig().isLiteMember()) {
            throw new ReplicatedMapCantBeCreatedOnLiteMemberException("Listener cannot be registered on lite members!");
        }
        ClientEndpoint endpoint = this.getEndpoint();
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedMapEventPublishingService eventPublishingService = service.getEventPublishingService();
        ClientReplicatedMapEntryListener listener = new ClientReplicatedMapEntryListener();
        String registrationId = this.predicate == null ? eventPublishingService.addEventListener(listener, new ReplicatedEntryEventFilter(this.key), this.mapName) : eventPublishingService.addEventListener(listener, new ReplicatedQueryEventFilter(this.key, this.predicate), this.mapName);
        endpoint.addListenerDestroyAction("hz:impl:replicatedMapService", this.mapName, registrationId);
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.mapName);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
        out.writeObject(this.predicate);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.mapName = reader.readUTF("n");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
        this.predicate = (Predicate)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.mapName, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return this.mapName;
    }

    @Override
    public String getMethodName() {
        return "addEntryListener";
    }

    @Override
    public Object[] getParameters() {
        if (this.key == null && this.predicate == null) {
            return new Object[]{null};
        }
        if (this.key == null && this.predicate != null) {
            return new Object[]{null, this.predicate};
        }
        if (this.key != null && this.predicate == null) {
            return new Object[]{null, this.key};
        }
        return new Object[]{null, this.predicate, this.key};
    }

    private class ClientReplicatedMapEntryListener
    implements EntryListener {
        private ClientReplicatedMapEntryListener() {
        }

        private void handleEvent(EntryEvent event) {
            if (!this.shouldSendEvent(event)) {
                return;
            }
            if (!(event instanceof DataAwareEntryEvent)) {
                throw new IllegalArgumentException("Expecting: DataAwareEntryEvent, Found: " + event.getClass().getSimpleName());
            }
            DataAwareEntryEvent dataAwareEntryEvent = (DataAwareEntryEvent)event;
            Data key = dataAwareEntryEvent.getKeyData();
            Data value = dataAwareEntryEvent.getNewValueData();
            Data oldValue = dataAwareEntryEvent.getOldValueData();
            EntryEventType eventType = event.getEventType();
            String uuid = event.getMember().getUuid();
            ReplicatedMapPortableEntryEvent portableEntryEvent = new ReplicatedMapPortableEntryEvent(key, value, oldValue, eventType, uuid);
            Object partitionKey = ClientReplicatedMapAddEntryListenerRequest.this.serializationService.toData(key);
            ClientReplicatedMapAddEntryListenerRequest.this.endpoint.sendEvent(partitionKey, portableEntryEvent, ClientReplicatedMapAddEntryListenerRequest.this.getCallId());
        }

        private void handleMapEvent(MapEvent event) {
            if (!this.shouldSendEvent(event)) {
                return;
            }
            EntryEventType type2 = event.getEventType();
            String uuid = event.getMember().getUuid();
            ReplicatedMapPortableEntryEvent portableEntryEvent = new ReplicatedMapPortableEntryEvent(null, null, null, type2, uuid, event.getNumberOfEntriesAffected());
            ClientReplicatedMapAddEntryListenerRequest.this.endpoint.sendEvent(null, portableEntryEvent, ClientReplicatedMapAddEntryListenerRequest.this.getCallId());
        }

        private boolean shouldSendEvent(IMapEvent event) {
            if (!ClientReplicatedMapAddEntryListenerRequest.this.endpoint.isAlive()) {
                return false;
            }
            Member originatedMember = event.getMember();
            return !ClientReplicatedMapAddEntryListenerRequest.this.localOnly || ClientReplicatedMapAddEntryListenerRequest.this.getClientEngine().getLocalMember().equals(originatedMember);
        }

        @Override
        public void entryAdded(EntryEvent event) {
            this.handleEvent(event);
        }

        @Override
        public void entryRemoved(EntryEvent event) {
            this.handleEvent(event);
        }

        @Override
        public void entryUpdated(EntryEvent event) {
            this.handleEvent(event);
        }

        @Override
        public void entryEvicted(EntryEvent event) {
            this.handleEvent(event);
        }

        @Override
        public void mapEvicted(MapEvent event) {
        }

        @Override
        public void mapCleared(MapEvent event) {
            this.handleMapEvent(event);
        }
    }
}

