/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.nonblocking;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.tcp.nonblocking.MigratableHandler;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThreadOutOfMemoryHandler;
import com.hazelcast.nio.tcp.nonblocking.SelectionHandler;
import com.hazelcast.spi.impl.operationexecutor.OperationHostileThread;
import com.hazelcast.util.counters.SwCounter;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class NonBlockingIOThread
extends Thread
implements OperationHostileThread {
    private static final int SELECT_WAIT_TIME_MILLIS = 5000;
    private static final int SELECT_FAILURE_PAUSE_MILLIS = 1000;
    @Probe(name="taskQueueSize")
    private final Queue<Runnable> taskQueue = new ConcurrentLinkedQueue<Runnable>();
    @Probe
    private final SwCounter eventCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter selectorIOExceptionCount = SwCounter.newSwCounter();
    private final ILogger logger;
    private final Selector selector;
    private final NonBlockingIOThreadOutOfMemoryHandler oomeHandler;
    private final boolean selectNow;
    private volatile long lastSelectTimeMs;

    public NonBlockingIOThread(ThreadGroup threadGroup, String threadName, ILogger logger2, NonBlockingIOThreadOutOfMemoryHandler oomeHandler) {
        this(threadGroup, threadName, logger2, oomeHandler, false);
    }

    public NonBlockingIOThread(ThreadGroup threadGroup, String threadName, ILogger logger2, NonBlockingIOThreadOutOfMemoryHandler oomeHandler, boolean selectNow) {
        this(threadGroup, threadName, logger2, oomeHandler, selectNow, NonBlockingIOThread.newSelector());
    }

    public NonBlockingIOThread(ThreadGroup threadGroup, String threadName, ILogger logger2, NonBlockingIOThreadOutOfMemoryHandler oomeHandler, boolean selectNow, Selector selector) {
        super(threadGroup, threadName);
        this.logger = logger2;
        this.selectNow = selectNow;
        this.oomeHandler = oomeHandler;
        this.selector = selector;
    }

    private static Selector newSelector() {
        try {
            return Selector.open();
        }
        catch (IOException e) {
            throw new HazelcastException("Failed to open a Selector", e);
        }
    }

    public final Selector getSelector() {
        return this.selector;
    }

    public long getEventCount() {
        return this.eventCount.get();
    }

    @Probe
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastSelectTimeMs, 0L);
    }

    public final void addTask(Runnable task) {
        this.taskQueue.add(task);
    }

    public void addTaskAndWakeup(Runnable task) {
        this.taskQueue.add(task);
        if (!this.selectNow) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            while (true) {
                try {
                    if (this.selectNow) {
                        this.runSelectNowLoop();
                    } else {
                        this.runSelectLoop();
                    }
                }
                catch (IOException nonFatalException) {
                    this.selectorIOExceptionCount.inc();
                    this.logger.warning(this.getName() + " " + nonFatalException.toString(), nonFatalException);
                    this.coolDown();
                    continue;
                }
                break;
            }
        }
        catch (OutOfMemoryError e) {
            this.oomeHandler.handle(e);
        }
        catch (Throwable e) {
            this.logger.warning("Unhandled exception in " + this.getName(), e);
        }
        finally {
            this.closeSelector();
        }
        this.logger.finest(this.getName() + " finished");
    }

    private void coolDown() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            this.interrupt();
        }
    }

    private void runSelectLoop() throws IOException {
        while (!this.isInterrupted()) {
            this.processTaskQueue();
            int selectedKeys = this.selector.select(5000L);
            if (selectedKeys <= 0) continue;
            this.lastSelectTimeMs = System.currentTimeMillis();
            this.handleSelectionKeys();
        }
    }

    private void runSelectNowLoop() throws IOException {
        while (!this.isInterrupted()) {
            this.processTaskQueue();
            int selectedKeys = this.selector.selectNow();
            if (selectedKeys <= 0) continue;
            this.lastSelectTimeMs = System.currentTimeMillis();
            this.handleSelectionKeys();
        }
    }

    private void processTaskQueue() {
        while (!this.isInterrupted()) {
            Runnable task = this.taskQueue.poll();
            if (task == null) {
                return;
            }
            this.executeTask(task);
        }
    }

    private void executeTask(Runnable task) {
        NonBlockingIOThread target = this.getTargetIoThread(task);
        if (target == this) {
            task.run();
        } else {
            target.addTaskAndWakeup(task);
        }
    }

    private NonBlockingIOThread getTargetIoThread(Runnable task) {
        if (task instanceof MigratableHandler) {
            return ((MigratableHandler)((Object)task)).getOwner();
        }
        return this;
    }

    private void handleSelectionKeys() {
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey sk = it.next();
            it.remove();
            this.handleSelectionKey(sk);
        }
    }

    protected void handleSelectionKey(SelectionKey sk) {
        SelectionHandler handler = (SelectionHandler)sk.attachment();
        try {
            if (!sk.isValid()) {
                throw new CancelledKeyException();
            }
            this.eventCount.inc();
            handler.handle();
        }
        catch (Throwable t) {
            handler.onFailure(t);
        }
    }

    private void closeSelector() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Closing selector for:" + this.getName());
        }
        try {
            this.selector.close();
        }
        catch (Exception e) {
            this.logger.finest("Failed to close selector", e);
        }
    }

    public final void shutdown() {
        this.taskQueue.clear();
        this.interrupt();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

