/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.MapEvent;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.multimap.impl.MultiMapPortableHook;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.impl.PortableEntryEvent;
import java.io.IOException;
import java.security.Permission;

public class AddEntryListenerRequest
extends BaseClientAddListenerRequest {
    String name;
    Data key;
    boolean includeValue;

    public AddEntryListenerRequest() {
    }

    public AddEntryListenerRequest(String name, Data key, boolean includeValue) {
        this.name = name;
        this.key = key;
        this.includeValue = includeValue;
    }

    public Object call() throws Exception {
        final ClientEndpoint endpoint = this.getEndpoint();
        MultiMapService service = (MultiMapService)this.getService();
        EntryAdapter listener = new EntryAdapter(){

            public void onEntryEvent(EntryEvent event) {
                if (endpoint.isAlive()) {
                    if (!(event instanceof DataAwareEntryEvent)) {
                        throw new IllegalArgumentException("Expecting: DataAwareEntryEvent, Found: " + event.getClass().getSimpleName());
                    }
                    DataAwareEntryEvent dataAwareEntryEvent = (DataAwareEntryEvent)event;
                    Data key = dataAwareEntryEvent.getKeyData();
                    Data value = dataAwareEntryEvent.getNewValueData();
                    Data oldValue = dataAwareEntryEvent.getOldValueData();
                    Data mergingValue = dataAwareEntryEvent.getMergingValueData();
                    EntryEventType type2 = event.getEventType();
                    String uuid = event.getMember().getUuid();
                    PortableEntryEvent portableEntryEvent = new PortableEntryEvent(key, value, oldValue, mergingValue, type2, uuid);
                    endpoint.sendEvent(key, portableEntryEvent, AddEntryListenerRequest.this.getCallId());
                }
            }

            @Override
            public void onMapEvent(MapEvent event) {
                if (endpoint.isAlive()) {
                    PortableEntryEvent portableEntryEvent = AddEntryListenerRequest.this.toPortableEntryEvent(event);
                    endpoint.sendEvent(null, portableEntryEvent, AddEntryListenerRequest.this.getCallId());
                }
            }
        };
        String registrationId = service.addListener(this.name, listener, this.key, this.includeValue, this.localOnly);
        endpoint.addListenerDestroyAction("hz:impl:multiMapService", this.name, registrationId);
        return registrationId;
    }

    private PortableEntryEvent toPortableEntryEvent(MapEvent event) {
        EntryEventType type2 = event.getEventType();
        String uuid = event.getMember().getUuid();
        return new PortableEntryEvent(type2, uuid, event.getNumberOfEntriesAffected());
    }

    @Override
    public String getServiceName() {
        return "hz:impl:multiMapService";
    }

    @Override
    public int getFactoryId() {
        return MultiMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 14;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeBoolean("i", this.includeValue);
        writer.writeUTF("n", this.name);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.includeValue = reader.readBoolean("i");
        this.name = reader.readUTF("n");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "addEntryListener";
    }

    @Override
    public Object[] getParameters() {
        if (this.key != null) {
            return new Object[]{null, this.key, this.includeValue};
        }
        return new Object[]{null, this.includeValue};
    }
}

