/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.map.impl.MapConfigValidator;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.map.impl.proxy.NearCachedMapProxyImpl;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.RemoteService;

class MapRemoteService
implements RemoteService {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;

    MapRemoteService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
    }

    @Override
    public DistributedObject createDistributedObject(String name) {
        MapConfig mapConfig = this.nodeEngine.getConfig().findMapConfig(name);
        MapConfigValidator.checkInMemoryFormat(mapConfig.getInMemoryFormat());
        if (mapConfig.isNearCacheEnabled()) {
            MapConfigValidator.checkInMemoryFormat(mapConfig.getNearCacheConfig().getInMemoryFormat());
            return new NearCachedMapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine);
        }
        return new MapProxyImpl(name, this.mapServiceContext.getService(), this.nodeEngine);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.mapServiceContext.destroyMap(name);
    }
}

