/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.DoubleGauge;
import com.hazelcast.internal.metrics.DoubleProbeFunction;
import com.hazelcast.internal.metrics.LongProbeFunction;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeFunction;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.impl.DoubleGaugeImpl;
import com.hazelcast.internal.metrics.impl.LockStripe;
import com.hazelcast.internal.metrics.impl.LongGaugeImpl;
import com.hazelcast.internal.metrics.impl.ProbeInstance;
import com.hazelcast.internal.metrics.impl.SortedProbesInstances;
import com.hazelcast.internal.metrics.impl.SourceMetadata;
import com.hazelcast.internal.metrics.metricsets.ClassLoadingMetricSet;
import com.hazelcast.internal.metrics.metricsets.GarbageCollectionMetricSet;
import com.hazelcast.internal.metrics.metricsets.OperatingSystemMetricsSet;
import com.hazelcast.internal.metrics.metricsets.RuntimeMetricSet;
import com.hazelcast.internal.metrics.metricsets.ThreadMetricSet;
import com.hazelcast.internal.metrics.renderers.ProbeRenderer;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class MetricsRegistryImpl
implements MetricsRegistry {
    final ILogger logger;
    final ProbeLevel minimumLevel;
    private final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(2);
    private final AtomicInteger modCount = new AtomicInteger();
    private final ConcurrentMap<String, ProbeInstance> probeInstances = new ConcurrentHashMap<String, ProbeInstance>();
    private final ConcurrentMap<Class<?>, SourceMetadata> metadataMap = new ConcurrentHashMap();
    private final LockStripe lockStripe = new LockStripe();
    private AtomicReference<SortedProbesInstances> sortedProbeInstance = new AtomicReference<SortedProbesInstances>(new SortedProbesInstances());

    public MetricsRegistryImpl(ILogger logger2, ProbeLevel minimumLevel) {
        this.logger = Preconditions.checkNotNull(logger2, "logger can't be null");
        this.minimumLevel = Preconditions.checkNotNull(minimumLevel, "minimumLevel can't be null");
        if (logger2.isFinestEnabled()) {
            logger2.finest("MetricsRegistry minimumLevel:" + (Object)((Object)minimumLevel));
        }
        RuntimeMetricSet.register(this);
        GarbageCollectionMetricSet.register(this);
        OperatingSystemMetricsSet.register(this);
        ThreadMetricSet.register(this);
        ClassLoadingMetricSet.register(this);
    }

    int modCount() {
        return this.modCount.get();
    }

    @Override
    public Set<String> getNames() {
        HashSet names = new HashSet(this.probeInstances.keySet());
        return Collections.unmodifiableSet(names);
    }

    SourceMetadata loadSourceMetadata(Class<?> clazz) {
        SourceMetadata metadata = (SourceMetadata)this.metadataMap.get(clazz);
        if (metadata == null) {
            metadata = new SourceMetadata(clazz);
            SourceMetadata found = this.metadataMap.putIfAbsent(clazz, metadata);
            metadata = found == null ? metadata : found;
        }
        return metadata;
    }

    @Override
    public <S> void scanAndRegister(S source, String namePrefix) {
        Preconditions.checkNotNull(source, "source can't be null");
        Preconditions.checkNotNull(namePrefix, "namePrefix can't be null");
        SourceMetadata metadata = this.loadSourceMetadata(source.getClass());
        metadata.register(this, source, namePrefix);
    }

    @Override
    public <S> void register(S source, String name, ProbeLevel level, LongProbeFunction<S> function) {
        Preconditions.checkNotNull(source, "source can't be null");
        Preconditions.checkNotNull(name, "name can't be null");
        Preconditions.checkNotNull(function, "function can't be null");
        Preconditions.checkNotNull(level, "level can't be null");
        this.registerInternal(source, name, level, function);
    }

    @Override
    public <S> void register(S source, String name, ProbeLevel level, DoubleProbeFunction<S> function) {
        Preconditions.checkNotNull(source, "source can't be null");
        Preconditions.checkNotNull(name, "name can't be null");
        Preconditions.checkNotNull(function, "function can't be null");
        Preconditions.checkNotNull(level, "level can't be null");
        this.registerInternal(source, name, level, function);
    }

    public ProbeInstance getProbeInstance(String name) {
        Preconditions.checkNotNull(name, "name can't be null");
        return (ProbeInstance)this.probeInstances.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <S> void registerInternal(S source, String name, ProbeLevel probeLevel, ProbeFunction function) {
        if (!probeLevel.isEnabled(this.minimumLevel)) {
            return;
        }
        Object object = this.lockStripe.getLock(source);
        synchronized (object) {
            ProbeInstance<S> probeInstance = (ProbeInstance<S>)this.probeInstances.get(name);
            if (probeInstance == null) {
                probeInstance = new ProbeInstance<S>(name, source, function);
                this.probeInstances.put(name, probeInstance);
            } else {
                this.logOverwrite(probeInstance);
            }
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Registered probeInstance " + name);
            }
            probeInstance.source = source;
            probeInstance.function = function;
        }
        this.modCount.incrementAndGet();
    }

    private void logOverwrite(ProbeInstance probeInstance) {
        if (probeInstance.function != null || probeInstance.source != null) {
            this.logger.warning(String.format("Overwriting existing probe '%s'", probeInstance.name));
        }
    }

    @Override
    public LongGaugeImpl newLongGauge(String name) {
        Preconditions.checkNotNull(name, "name can't be null");
        return new LongGaugeImpl(this, name);
    }

    @Override
    public DoubleGauge newDoubleGauge(String name) {
        Preconditions.checkNotNull(name, "name can't be null");
        return new DoubleGaugeImpl(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> void deregister(S source) {
        Preconditions.checkNotNull(source, "source can't be null");
        boolean changed = false;
        for (Map.Entry entry : this.probeInstances.entrySet()) {
            ProbeInstance probeInstance = (ProbeInstance)entry.getValue();
            if (probeInstance.source != source) continue;
            String name = (String)entry.getKey();
            boolean destroyed = false;
            Object object = this.lockStripe.getLock(source);
            synchronized (object) {
                if (probeInstance.source == source) {
                    changed = true;
                    this.probeInstances.remove(name);
                    probeInstance.source = null;
                    probeInstance.function = null;
                    destroyed = true;
                }
            }
            if (!destroyed || !this.logger.isFinestEnabled()) continue;
            this.logger.finest("Destroying probeInstance " + name);
        }
        if (changed) {
            this.modCount.incrementAndGet();
        }
    }

    @Override
    public void render(ProbeRenderer renderer) {
        Preconditions.checkNotNull(renderer, "renderer can't be null");
        renderer.start();
        for (ProbeInstance probeInstance : this.getSortedProbeInstances()) {
            this.render(renderer, probeInstance);
        }
        renderer.finish();
    }

    SortedProbesInstances getSortedProbeInstances() {
        SortedProbesInstances sortedProbeInstances = this.sortedProbeInstance.get();
        int lastModCount = this.modCount.get();
        if (lastModCount == sortedProbeInstances.modCount) {
            return sortedProbeInstances;
        }
        SortedProbesInstances newSortedProbeInstances = new SortedProbesInstances(this.probeInstances.values(), lastModCount);
        this.sortedProbeInstance.compareAndSet(sortedProbeInstances, newSortedProbeInstances);
        return this.sortedProbeInstance.get();
    }

    private void render(ProbeRenderer renderer, ProbeInstance probeInstance) {
        ProbeFunction function = probeInstance.function;
        Object source = probeInstance.source;
        String name = probeInstance.name;
        if (function == null || source == null) {
            renderer.renderNoValue(name);
            return;
        }
        try {
            if (function instanceof LongProbeFunction) {
                LongProbeFunction longFunction = (LongProbeFunction)function;
                renderer.renderLong(name, longFunction.get(source));
            } else {
                DoubleProbeFunction doubleFunction = (DoubleProbeFunction)function;
                renderer.renderDouble(name, doubleFunction.get(source));
            }
        }
        catch (Exception e) {
            renderer.renderException(name, e);
        }
    }

    @Override
    public void scheduleAtFixedRate(Runnable publisher, long period, TimeUnit timeUnit) {
        this.scheduledExecutorService.scheduleAtFixedRate(publisher, 0L, period, timeUnit);
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }
}

