/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl.operations;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.NodeEngineImpl;

public class ShutdownNodeOperation
extends AbstractClusterOperation
implements AllowedDuringPassiveState {
    @Override
    public void run() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        ILogger logger2 = this.getLogger();
        ClusterState clusterState = clusterService.getClusterState();
        if (clusterState == ClusterState.PASSIVE) {
            final NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
            if (nodeEngine.isRunning()) {
                logger2.info("Shutting down node in cluster passive state. Requested by: " + this.getCallerAddress());
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        nodeEngine.getNode().shutdown(false);
                    }
                }).start();
            } else {
                logger2.info("Node is already shutting down. NodeState: " + (Object)((Object)nodeEngine.getNode().getState()));
            }
        } else {
            logger2.severe("Can not shut down node because cluster is in " + (Object)((Object)clusterState) + " state. Requested by: " + this.getCallerAddress());
        }
    }
}

