/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.client;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEndpointManager;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.ClientPortableHook;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.operations.ClientReAuthOperation;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.impl.SerializableList;
import com.hazelcast.util.UuidUtil;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class AuthenticationRequest
extends CallableClientRequest {
    private Credentials credentials;
    private ClientPrincipal principal;
    private boolean ownerConnection;

    public AuthenticationRequest() {
    }

    public AuthenticationRequest(Credentials credentials) {
        this.credentials = credentials;
    }

    public AuthenticationRequest(Credentials credentials, ClientPrincipal principal) {
        this.credentials = credentials;
        this.principal = principal;
    }

    public Object call() throws Exception {
        boolean authenticated = this.authenticate();
        if (authenticated) {
            return this.handleAuthenticated();
        }
        return this.handleUnauthenticated();
    }

    private boolean authenticate() {
        boolean authenticated;
        ILogger logger2 = this.clientEngine.getLogger(this.getClass());
        if (this.credentials == null) {
            authenticated = false;
            logger2.severe("Could not retrieve Credentials object!");
        } else if (this.clientEngine.getSecurityContext() != null) {
            authenticated = this.authenticate(this.clientEngine.getSecurityContext());
        } else if (this.credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)this.credentials;
            authenticated = this.authenticate(usernamePasswordCredentials);
        } else {
            authenticated = false;
            logger2.severe("Hazelcast security is disabled.\nUsernamePasswordCredentials or cluster group-name and group-password should be used for authentication!\nCurrent credentials type is: " + this.credentials.getClass().getName());
        }
        return authenticated;
    }

    private boolean authenticate(UsernamePasswordCredentials credentials) {
        ClientEngineImpl clientEngine = (ClientEngineImpl)this.getService();
        GroupConfig groupConfig = clientEngine.getConfig().getGroupConfig();
        String nodeGroupName = groupConfig.getName();
        String nodeGroupPassword = groupConfig.getPassword();
        boolean usernameMatch = nodeGroupName.equals(credentials.getUsername());
        boolean passwordMatch = nodeGroupPassword.equals(credentials.getPassword());
        return usernameMatch && passwordMatch;
    }

    private boolean authenticate(SecurityContext securityContext) {
        Connection connection = this.endpoint.getConnection();
        this.credentials.setEndpoint(connection.getInetAddress().getHostAddress());
        try {
            LoginContext lc = securityContext.createClientLoginContext(this.credentials);
            lc.login();
            this.endpoint.setLoginContext(lc);
            return true;
        }
        catch (LoginException e) {
            ILogger logger2 = this.clientEngine.getLogger(this.getClass());
            logger2.warning(e);
            return false;
        }
    }

    private Object handleUnauthenticated() {
        Connection connection = this.endpoint.getConnection();
        ILogger logger2 = this.clientEngine.getLogger(this.getClass());
        logger2.log(Level.WARNING, "Received auth from " + connection + " with principal " + this.principal + " , authentication failed");
        return new AuthenticationException("Invalid credentials!");
    }

    private Object handleAuthenticated() {
        if (this.ownerConnection) {
            String uuid = this.getUuid();
            this.principal = new ClientPrincipal(uuid, this.clientEngine.getLocalMember().getUuid());
            this.reAuthLocal();
            Set<Member> members = this.clientEngine.getClusterService().getMembers();
            for (Member member : members) {
                if (member.localMember()) continue;
                ClientReAuthOperation op = new ClientReAuthOperation(uuid);
                op.setCallerUuid(this.clientEngine.getLocalMember().getUuid());
                this.operationService.send(op, member.getAddress());
            }
        }
        if (this.clientEngine.getClusterService().getMember(this.principal.getOwnerUuid()) == null) {
            return new AuthenticationException("Invalid owner-uuid: " + this.principal.getOwnerUuid() + ", it's not member of this cluster!");
        }
        Connection connection = this.endpoint.getConnection();
        ILogger logger2 = this.clientEngine.getLogger(this.getClass());
        logger2.log(Level.INFO, "Received auth from " + connection + ", successfully authenticated" + ", principal : " + this.principal + ", owner connection : " + this.ownerConnection);
        this.endpoint.authenticated(this.principal, this.credentials, this.ownerConnection);
        this.clientEngine.getEndpointManager().registerEndpoint(this.endpoint);
        this.clientEngine.bind(this.endpoint);
        ArrayList<Data> list = new ArrayList<Data>();
        list.add((Data)this.serializationService.toData(this.clientEngine.getThisAddress()));
        list.add((Data)this.serializationService.toData(this.principal));
        return new SerializableList(list);
    }

    private String getUuid() {
        if (this.principal != null) {
            return this.principal.getUuid();
        }
        return UuidUtil.createClientUuid(this.endpoint.getConnection().getEndPoint());
    }

    private void reAuthLocal() {
        ClientEndpointManager endpointManager = this.clientEngine.getEndpointManager();
        Set<ClientEndpoint> endpoints = endpointManager.getEndpoints(this.principal.getUuid());
        for (ClientEndpoint endpoint : endpoints) {
            endpoint.authenticated(this.principal);
        }
        this.clientEngine.addOwnershipMapping(this.principal.getUuid(), this.principal.getOwnerUuid());
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    public void setOwnerConnection(boolean ownerConnection) {
        this.ownerConnection = ownerConnection;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writePortable("credentials", (Portable)((Object)this.credentials));
        if (this.principal != null) {
            writer.writePortable("principal", this.principal);
        } else {
            writer.writeNullPortable("principal", ClientPortableHook.ID, 3);
        }
        writer.writeBoolean("firstConnection", this.ownerConnection);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.credentials = (Credentials)reader.readPortable("credentials");
        this.principal = (ClientPrincipal)reader.readPortable("principal");
        this.ownerConnection = reader.readBoolean("firstConnection");
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

