/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheProxy;
import com.hazelcast.cache.impl.AbstractCacheProxyBase;
import com.hazelcast.cache.impl.AbstractHazelcastCacheManager;
import com.hazelcast.cache.impl.CacheEntryProcessorResult;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.ClusterWideIterator;
import com.hazelcast.cache.impl.HazelcastServerCacheManager;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.event.CachePartitionLostEventFilter;
import com.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.hazelcast.cache.impl.event.InternalCachePartitionLostListenerAdapter;
import com.hazelcast.cache.impl.operation.CacheListenerRegistrationOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.Member;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class CacheProxy<K, V>
extends AbstractCacheProxy<K, V> {
    protected final ILogger logger;
    private AbstractHazelcastCacheManager cacheManager;

    protected CacheProxy(CacheConfig cacheConfig, NodeEngine nodeEngine, ICacheService cacheService, HazelcastServerCacheManager cacheManager) {
        super(cacheConfig, nodeEngine, cacheService);
        this.cacheManager = cacheManager;
        this.logger = this.getNodeEngine().getLogger(this.getClass());
    }

    @Override
    public V get(K key) {
        return (V)this.get((Object)key, (ExpiryPolicy)null);
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) {
        return this.getAll((Set)keys, (ExpiryPolicy)null);
    }

    @Override
    public boolean containsKey(K key) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        Object k = this.serializationService.toData(key);
        Operation operation = this.operationProvider.createContainsKeyOperation((Data)k);
        OperationService operationService = this.getNodeEngine().getOperationService();
        int partitionId = CacheProxyUtil.getPartitionId(this.getNodeEngine(), k);
        InternalCompletableFuture f = operationService.invokeOnPartition(this.getServiceName(), operation, partitionId);
        return (Boolean)f.getSafely();
    }

    @Override
    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        for (K key : keys) {
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
        }
        HashSet<Data> keysData = new HashSet<Data>(keys.size());
        for (K key : keys) {
            keysData.add((Data)this.serializationService.toData(key));
        }
        AbstractCacheProxyBase.LoadAllTask loadAllTask = new AbstractCacheProxyBase.LoadAllTask(this.operationProvider, keysData, replaceExistingValues, completionListener);
        try {
            this.submitLoadAllTask(loadAllTask);
        }
        catch (Exception e) {
            if (completionListener != null) {
                completionListener.onException(e);
            }
            throw new CacheException(e);
        }
    }

    @Override
    public void put(K key, V value) {
        this.put((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    @Override
    public V getAndPut(K key, V value) {
        return (V)this.getAndPut((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll((Map)map, (ExpiryPolicy)null);
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        return this.putIfAbsent((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    @Override
    public boolean remove(K key) {
        InternalCompletableFuture f = this.removeAsyncInternal(key, null, false, false, true);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public boolean remove(K key, V oldValue) {
        InternalCompletableFuture f = this.removeAsyncInternal(key, oldValue, true, false, true);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public V getAndRemove(K key) {
        InternalCompletableFuture f = this.removeAsyncInternal(key, null, false, true, true);
        try {
            return f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace((Object)key, (Object)oldValue, (Object)newValue, (ExpiryPolicy)null);
    }

    @Override
    public boolean replace(K key, V value) {
        ExpiryPolicy expiryPolicy = null;
        return this.replace((Object)key, (Object)value, expiryPolicy);
    }

    @Override
    public V getAndReplace(K key, V value) {
        return (V)this.getAndReplace((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    @Override
    public void removeAll(Set<? extends K> keys) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        this.removeAllInternal(keys);
    }

    @Override
    public void removeAll() {
        this.ensureOpen();
        this.removeAllInternal(null);
    }

    @Override
    public void clear() {
        this.ensureOpen();
        this.clearInternal();
    }

    @Override
    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.cacheConfig)) {
            return (C)((Configuration)clazz.cast(this.cacheConfig.getAsReadOnly()));
        }
        throw new IllegalArgumentException("The configuration class " + clazz + " is not supported by this implementation");
    }

    @Override
    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        Preconditions.checkNotNull(entryProcessor, "Entry Processor is null");
        Object keyData = this.serializationService.toData(key);
        Integer completionId = this.registerCompletionLatch(1);
        Operation op = this.operationProvider.createEntryProcessorOperation((Data)keyData, completionId, entryProcessor, arguments);
        try {
            OperationService operationService = this.getNodeEngine().getOperationService();
            int partitionId = CacheProxyUtil.getPartitionId(this.getNodeEngine(), keyData);
            InternalCompletableFuture f = operationService.invokeOnPartition(this.getServiceName(), op, partitionId);
            Object safely = f.getSafely();
            this.waitCompletionLatch(completionId);
            return (T)safely;
        }
        catch (CacheException ce) {
            this.deregisterCompletionLatch(completionId);
            throw ce;
        }
        catch (Exception e) {
            this.deregisterCompletionLatch(completionId);
            throw new EntryProcessorException(e);
        }
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        Preconditions.checkNotNull(entryProcessor, "Entry Processor is null");
        HashMap<K, CacheEntryProcessorResult<T>> allResult = new HashMap<K, CacheEntryProcessorResult<T>>();
        for (K key : keys) {
            CacheEntryProcessorResult<T> ceResult;
            try {
                T result = this.invoke(key, entryProcessor, arguments);
                ceResult = result != null ? new CacheEntryProcessorResult<T>(result) : null;
            }
            catch (Exception e) {
                ceResult = new CacheEntryProcessorResult<T>(e);
            }
            if (ceResult == null) continue;
            allResult.put(key, ceResult);
        }
        return allResult;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + clazz + " is not supported by this implementation");
    }

    @Override
    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.ensureOpen();
        Preconditions.checkNotNull(cacheEntryListenerConfiguration, "CacheEntryListenerConfiguration can't be null");
        ICacheService service = this.getService();
        CacheEventListenerAdaptor<K, V> entryListener = new CacheEventListenerAdaptor<K, V>(this, cacheEntryListenerConfiguration, this.getNodeEngine().getSerializationService());
        String regId = service.registerListener(this.getDistributedObjectName(), entryListener, entryListener, false);
        if (regId != null) {
            this.cacheConfig.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)cacheEntryListenerConfiguration);
            this.addListenerLocally(regId, cacheEntryListenerConfiguration);
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, true);
        }
    }

    @Override
    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        Preconditions.checkNotNull(cacheEntryListenerConfiguration, "CacheEntryListenerConfiguration can't be null");
        ICacheService service = this.getService();
        String regId = this.getListenerIdLocal(cacheEntryListenerConfiguration);
        if (regId != null && service.deregisterListener(this.getDistributedObjectName(), regId)) {
            this.removeListenerLocally(cacheEntryListenerConfiguration);
            this.cacheConfig.removeCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)cacheEntryListenerConfiguration);
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, false);
        }
    }

    protected void updateCacheListenerConfigOnOtherNodes(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean isRegister) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        Set<Member> members = this.getNodeEngine().getClusterService().getMembers();
        ArrayList futures = new ArrayList();
        for (Member member : members) {
            if (member.localMember()) continue;
            CacheListenerRegistrationOperation op = new CacheListenerRegistrationOperation(this.getDistributedObjectName(), cacheEntryListenerConfiguration, isRegister);
            InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
            futures.add(future);
        }
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        return new ClusterWideIterator(this);
    }

    @Override
    public String addPartitionLostListener(CachePartitionLostListener listener) {
        Preconditions.checkNotNull(listener, "CachePartitionLostListener can't be null");
        InternalCachePartitionLostListenerAdapter listenerAdapter = new InternalCachePartitionLostListenerAdapter(listener);
        CachePartitionLostEventFilter filter = new CachePartitionLostEventFilter();
        ICacheService service = this.getService();
        EventRegistration registration = service.getNodeEngine().getEventService().registerListener("hz:impl:cacheService", this.name, filter, listenerAdapter);
        return registration.getId();
    }

    @Override
    public boolean removePartitionLostListener(String id) {
        Preconditions.checkNotNull(id, "Listener id should not be null!");
        ICacheService service = this.getService();
        return service.getNodeEngine().getEventService().deregisterListener("hz:impl:cacheService", this.name, id);
    }
}

