/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.common_impl.Jar;
import com.sun.enterprise.module.common_impl.LogHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.jvnet.hk2.osgiadapter.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

public class OSGiModuleDefinition
implements ModuleDefinition,
Serializable {
    private String name;
    private String bundleName;
    private URI location;
    private String version;
    private Manifest manifest;
    private String lifecyclePolicyClassName;
    private ModuleMetadata metadata = new ModuleMetadata();

    public OSGiModuleDefinition(File jar) throws IOException {
        this(Jar.create(jar), jar.toURI());
    }

    public OSGiModuleDefinition(Jar jarFile, URI location) throws IOException {
        this.location = location;
        Manifest m = jarFile.getManifest();
        this.manifest = m instanceof Serializable ? m : new SerializableManifest(m);
        Attributes mainAttr = this.manifest.getMainAttributes();
        this.bundleName = mainAttr.getValue("Bundle-Name");
        this.name = mainAttr.getValue("Bundle-SymbolicName");
        if (this.name == null) {
            this.name = location.toString();
        }
        this.version = mainAttr.getValue("Bundle-Version");
        this.lifecyclePolicyClassName = mainAttr.getValue("HK2-Module-Lifecycle-Policy");
        jarFile.loadMetadata(this.metadata);
    }

    public OSGiModuleDefinition(Bundle b) throws IOException, URISyntaxException {
        this(new BundleJar(b), OSGiModuleDefinition.toURI(b));
    }

    static URI toURI(Bundle b) throws URISyntaxException {
        try {
            return new URI(b.getLocation());
        }
        catch (URISyntaxException ue) {
            if (b.getLocation().startsWith("initial@")) {
                return new URI(b.getLocation().substring("initial@".length()));
            }
            throw ue;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getPublicInterfaces() {
        throw new UnsupportedOperationException("This method should not be called in OSGi environment, hence not supported");
    }

    @Override
    public ModuleDependency[] getDependencies() {
        ArrayList<ModuleDependency> mds = new ArrayList<ModuleDependency>();
        String requiredBundles = this.getManifest().getMainAttributes().getValue("Require-Bundle");
        if (requiredBundles != null) {
            int i1;
            Logger.logger.log(Level.INFO, this.name + " -> " + requiredBundles);
            while ((i1 = requiredBundles.indexOf(34)) != -1) {
                int i2 = requiredBundles.indexOf(34, i1 + 1);
                StringBuilder sb = new StringBuilder();
                sb.append(requiredBundles.substring(0, i1));
                sb.append(requiredBundles.substring(i2 + 1));
                requiredBundles = sb.toString();
            }
            StringTokenizer st = new StringTokenizer(requiredBundles, ",", false);
            while (st.hasMoreTokens()) {
                String requireBundle = st.nextToken();
                int idx = requireBundle.indexOf(59);
                String requiredBundleName = idx == -1 ? requireBundle : requireBundle.substring(0, idx);
                mds.add(new ModuleDependency(requiredBundleName, null));
            }
        }
        return mds.toArray(new ModuleDependency[mds.size()]);
    }

    @Override
    public URI[] getLocations() {
        return new URI[]{this.location};
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getImportPolicyClassName() {
        throw new UnsupportedOperationException("This method should not be called in OSGi environment, hence not supported");
    }

    @Override
    public String getLifecyclePolicyClassName() {
        return this.lifecyclePolicyClassName;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public ModuleMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.name + "(" + this.bundleName + ")" + ':' + this.version;
    }

    private static class SerializableManifest
    extends Manifest
    implements Serializable {
        private SerializableManifest() {
        }

        private SerializableManifest(Manifest man) {
            super(man);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.write(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.read(in);
        }
    }

    private static class BundleJar
    extends Jar {
        private static final String HK2_DESCRIPTOR_LOCATION = "META-INF/hk2-locator";
        private static final String SERVICE_LOCATION = "META-INF/services";
        Bundle b;
        Manifest m;

        private BundleJar(Bundle b) throws IOException {
            this.b = b;
            this.m = new BundleManifest(b);
        }

        @Override
        public Manifest getManifest() throws IOException {
            return this.m;
        }

        @Override
        public void loadMetadata(ModuleMetadata result) {
            this.parseServiceDescriptors(result);
            this.parseDescriptors(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseServiceDescriptors(ModuleMetadata result) {
            if (this.b.getEntry(SERVICE_LOCATION) == null) {
                return;
            }
            Enumeration entries = this.b.getEntryPaths(SERVICE_LOCATION);
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    String entry = (String)entries.nextElement();
                    String serviceName = entry.substring(SERVICE_LOCATION.length() + 1);
                    InputStream is = null;
                    URL url = this.b.getEntry(entry);
                    try {
                        is = url.openStream();
                        result.load(url, serviceName, is);
                    }
                    catch (IOException e) {
                        LogHelper.getDefaultLogger().log(Level.SEVERE, "Error reading service provider in " + this.b.getLocation(), e);
                    }
                    finally {
                        if (is == null) continue;
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void parseDescriptors(ModuleMetadata result) {
            if (this.b.getEntry(HK2_DESCRIPTOR_LOCATION) == null) {
                return;
            }
            Enumeration entries = this.b.getEntryPaths(HK2_DESCRIPTOR_LOCATION);
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    String entry = (String)entries.nextElement();
                    String serviceLocatorName = entry.substring(HK2_DESCRIPTOR_LOCATION.length() + 1);
                    URL url = this.b.getEntry(entry);
                    InputStream is = null;
                    if (url == null) continue;
                    ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
                    try {
                        is = url.openStream();
                        BufferedReader br = new BufferedReader(new InputStreamReader(is));
                        try {
                            boolean readOne = false;
                            do {
                                DescriptorImpl descriptorImpl;
                                if (!(readOne = (descriptorImpl = new DescriptorImpl()).readObject(br))) continue;
                                descriptors.add(descriptorImpl);
                            } while (readOne);
                        }
                        finally {
                            br.close();
                        }
                        result.addDescriptors(serviceLocatorName, descriptors);
                    }
                    catch (IOException e) {
                        LogHelper.getDefaultLogger().log(Level.SEVERE, "Error reading descriptor in " + this.b.getLocation(), e);
                    }
                    finally {
                        if (is == null) continue;
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }

        @Override
        public String getBaseName() {
            throw new UnsupportedOperationException("Method not implemented");
        }

        private static class BundleManifest
        extends Manifest
        implements Serializable {
            private long bundleId;

            private BundleManifest() {
            }

            private BundleManifest(Bundle b) {
                this.bundleId = b.getBundleId();
                this.init(b);
            }

            private void init(Bundle b) {
                Attributes attrs = this.getMainAttributes();
                Dictionary headers = b.getHeaders();
                for (Object o : Collections.list(headers.keys())) {
                    attrs.putValue((String)o, (String)headers.get(o));
                }
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.defaultWriteObject();
            }

            private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                in.defaultReadObject();
                ClassLoader cl = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return this.getClass().getClassLoader();
                    }
                }) : this.getClass().getClassLoader();
                Bundle clBundle = ((BundleReference)cl).getBundle();
                if (clBundle == null) {
                    throw new RuntimeException("Cannot resolve classLoader " + cl + " bundle");
                }
                BundleContext bctx = clBundle.getBundleContext();
                if (bctx == null) {
                    throw new RuntimeException("Cannot obtain BundleContext");
                }
                Bundle bundle2 = bctx.getBundle(this.bundleId);
                if (bundle2 == null) {
                    throw new RuntimeException("Cannot obtain bundle " + this.bundleId);
                }
                this.init(bundle2);
            }
        }
    }
}

