/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.net.URLPattern;
import java.util.Arrays;
import java.util.logging.Level;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.web.deployment.annotation.handlers.AbstractWebHandler;
import org.glassfish.web.deployment.descriptor.ServletFilterDescriptor;
import org.glassfish.web.deployment.descriptor.ServletFilterMappingDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=WebFilter.class)
public class WebFilterHandler
extends AbstractWebHandler {
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WebFilterHandler.class);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        return this.processAnnotation(ainfo, webCompContexts[0].getDescriptor().getWebBundleDescriptor());
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        return this.processAnnotation(ainfo, webBundleContext.getDescriptor());
    }

    private HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleDescriptor webBundleDesc) throws AnnotationProcessorException {
        DispatcherType[] dispatcherTypes;
        String[] servletNames;
        int n;
        boolean bl;
        WebInitParam[] initParams;
        Class filterClass = (Class)ainfo.getAnnotatedElement();
        if (!Filter.class.isAssignableFrom(filterClass)) {
            this.log(Level.SEVERE, ainfo, localStrings.getLocalString("web.deployment.annotation.handlers.needtoimpl", "The Class {0} having annotation {1} need to implement the interface {2}.", filterClass.getName(), WebFilter.class.getName(), Filter.class.getName()));
            return this.getDefaultFailedResult();
        }
        WebFilter webFilterAn = (WebFilter)ainfo.getAnnotation();
        String filterName = webFilterAn.filterName();
        if (filterName == null || filterName.length() == 0) {
            filterName = filterClass.getName();
        }
        ServletFilterDescriptor servletFilterDesc = null;
        for (ServletFilter servletFilter : webBundleDesc.getServletFilters()) {
            if (!filterName.equals(servletFilter.getName())) continue;
            servletFilterDesc = (ServletFilterDescriptor)servletFilter;
            break;
        }
        if (servletFilterDesc == null) {
            servletFilterDesc = new ServletFilterDescriptor();
            servletFilterDesc.setName(filterName);
            webBundleDesc.addServletFilter(servletFilterDesc);
        } else {
            String filterImpl = servletFilterDesc.getClassName();
            if (filterImpl != null && filterImpl.length() > 0 && !filterImpl.equals(filterClass.getName())) {
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("web.deployment.annotation.handlers.filternamedontmatch", "The filter '{0}' has implementation '{1}' in xml. It does not match with '{2}' from annotation @{3}.", filterName, filterImpl, filterClass.getName(), WebFilter.class.getName()));
                return this.getDefaultFailedResult();
            }
        }
        servletFilterDesc.setClassName(filterClass.getName());
        if (servletFilterDesc.getDescription() == null || servletFilterDesc.getDescription().length() == 0) {
            servletFilterDesc.setDescription(webFilterAn.description());
        }
        if (servletFilterDesc.hasSetDisplayName()) {
            servletFilterDesc.setDisplayName(webFilterAn.displayName());
        }
        if (servletFilterDesc.getInitializationParameters().size() == 0 && (initParams = webFilterAn.initParams()) != null && initParams.length > 0) {
            for (WebInitParam initParam : initParams) {
                servletFilterDesc.addInitializationParameter(new EnvironmentProperty(initParam.name(), initParam.value(), initParam.description()));
            }
        }
        if (servletFilterDesc.getSmallIconUri() == null) {
            servletFilterDesc.setSmallIconUri(webFilterAn.smallIcon());
        }
        if (servletFilterDesc.getLargeIconUri() == null) {
            servletFilterDesc.setLargeIconUri(webFilterAn.largeIcon());
        }
        if (servletFilterDesc.isAsyncSupported() == null) {
            servletFilterDesc.setAsyncSupported(webFilterAn.asyncSupported());
        }
        ServletFilterMapping servletFilterMappingDesc = null;
        boolean bl2 = false;
        boolean hasServletName = false;
        for (ServletFilterMapping sfm : webBundleDesc.getServletFilterMappings()) {
            if (!filterName.equals(sfm.getName())) continue;
            servletFilterMappingDesc = sfm;
            bl = bl || sfm.getUrlPatterns().size() > 0;
            hasServletName = hasServletName || sfm.getServletNames().size() > 0;
        }
        if (servletFilterMappingDesc == null) {
            servletFilterMappingDesc = new ServletFilterMappingDescriptor();
            servletFilterMappingDesc.setName(filterName);
            webBundleDesc.addServletFilterMapping(servletFilterMappingDesc);
        }
        if (!bl) {
            Object[] urlPatterns = webFilterAn.urlPatterns();
            if (urlPatterns == null || urlPatterns.length == 0) {
                urlPatterns = webFilterAn.value();
            }
            boolean validUrlPatterns = true;
            if (urlPatterns != null && urlPatterns.length > 0) {
                Object[] objectArray = urlPatterns;
                n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object up = objectArray[i];
                    if (!URLPattern.isValid((String)up)) {
                        validUrlPatterns = false;
                        break;
                    }
                    servletFilterMappingDesc.addURLPattern((String)up);
                }
            }
            if (!validUrlPatterns) {
                String urlPatternString = urlPatterns != null ? Arrays.toString(urlPatterns) : "";
                throw new IllegalArgumentException(localStrings.getLocalString("web.deployment.annotation.handlers.invalidUrlPatterns", "Invalid url patterns: {0}.", urlPatternString));
            }
        }
        if (!hasServletName && (servletNames = webFilterAn.servletNames()) != null && servletNames.length > 0) {
            String[] stringArray = servletNames;
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                String sn = stringArray[n];
                servletFilterMappingDesc.addServletName(sn);
            }
        }
        if (servletFilterMappingDesc.getDispatchers().size() == 0 && (dispatcherTypes = webFilterAn.dispatcherTypes()) != null && dispatcherTypes.length > 0) {
            for (DispatcherType dType : dispatcherTypes) {
                servletFilterMappingDesc.addDispatcher(dType.name());
            }
        }
        return this.getDefaultProcessedResult();
    }
}

