/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.common;

import org.glassfish.api.admin.PasswordAliasResolver;
import org.glassfish.api.admin.PasswordAliasStore;

public class PasswordAliasResolverImpl
implements PasswordAliasResolver {
    private static final String ALIAS_TOKEN = "ALIAS";
    private static final String STARTER = "${ALIAS=";
    private static final String ENDER = "}";
    private final PasswordAliasStore store;

    public PasswordAliasResolverImpl(PasswordAliasStore store) {
        this.store = store;
    }

    @Override
    public char[] resolvePassword(String aliasExpressionOrPassword) {
        String alias = PasswordAliasResolverImpl.getAlias(aliasExpressionOrPassword);
        if (alias != null) {
            return this.store.get(alias);
        }
        return aliasExpressionOrPassword.toCharArray();
    }

    private static String getAlias(String pwOrAliasExpression) {
        int lastIdx;
        String aliasName = null;
        if ((pwOrAliasExpression = pwOrAliasExpression.trim()).startsWith(STARTER) && pwOrAliasExpression.endsWith(ENDER) && (lastIdx = (pwOrAliasExpression = pwOrAliasExpression.substring(STARTER.length())).length() - 1) > 1 && (pwOrAliasExpression = pwOrAliasExpression.substring(0, lastIdx)) != null) {
            aliasName = pwOrAliasExpression.trim();
        }
        return aliasName;
    }
}

