/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.persistence.common.Java2DBProcessorHelper;
import org.glassfish.persistence.jpa.EmbeddedProviderContainerContractInfo;
import org.glassfish.persistence.jpa.JPAContainer;
import org.glassfish.persistence.jpa.JPApplicationContainer;
import org.glassfish.persistence.jpa.PersistenceUnitLoader;
import org.glassfish.persistence.jpa.ServerProviderContainerContractInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service
public class JPADeployer
extends SimpleDeployer<JPAContainer, JPApplicationContainer>
implements PostConstruct,
EventListener {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private ServerEnvironmentImpl serverEnvironment;
    @Inject
    private volatile StartupContext sc = null;
    @Inject
    private Events events;
    @Inject
    private ApplicationRegistry applicationRegistry;
    private static Logger logger = LogDomains.getLogger(PersistenceUnitLoader.class, "javax.org.glassfish.persistence.jpadeployer");
    private static final String EMF_KEY = EntityManagerFactory.class.toString();

    @Override
    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    @Override
    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    @Override
    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin.isUndeploy() && this.isDas()) {
            boolean hasScopedResource = false;
            String appName = params.name();
            ApplicationInfo appInfo = this.applicationRegistry.get(appName);
            Application application = appInfo.getMetaData(Application.class);
            Set<BundleDescriptor> bundles = application.getBundleDescriptors();
            for (BundleDescriptor bundle2 : bundles) {
                PersistenceUnitDescriptor pud;
                Collection<? extends PersistenceUnitDescriptor> pusReferencedFromBundle = bundle2.findReferencedPUs();
                Iterator<? extends PersistenceUnitDescriptor> iterator = pusReferencedFromBundle.iterator();
                while (iterator.hasNext() && !(hasScopedResource = this.hasScopedResource(pud = iterator.next()))) {
                }
            }
            if (hasScopedResource) {
                this.connectorRuntime.registerDataSourceDefinitions(application);
            }
            Java2DBProcessorHelper helper = new Java2DBProcessorHelper(dc);
            helper.init();
            helper.createOrDropTablesInDB(false, "JPA");
            if (hasScopedResource) {
                this.connectorRuntime.unRegisterDataSourceDefinitions(application);
            }
        }
    }

    @Override
    public <V> V loadMetaData(Class<V> type2, DeploymentContext context) {
        return null;
    }

    @Override
    public boolean prepare(DeploymentContext context) {
        boolean prepared = super.prepare(context);
        if (prepared && this.isEMFCreationRequired(context)) {
            this.createEMFs(context);
        }
        return prepared;
    }

    private void createEMFs(DeploymentContext context) {
        Application application = context.getModuleMetaData(Application.class);
        Set<BundleDescriptor> bundles = application.getBundleDescriptors();
        boolean hasScopedResource = false;
        final ArrayList<PersistenceUnitDescriptor> referencedPus = new ArrayList<PersistenceUnitDescriptor>();
        for (BundleDescriptor bundle2 : bundles) {
            Collection<? extends PersistenceUnitDescriptor> pusReferencedFromBundle = bundle2.findReferencedPUs();
            for (PersistenceUnitDescriptor persistenceUnitDescriptor : pusReferencedFromBundle) {
                referencedPus.add(persistenceUnitDescriptor);
                if (!this.hasScopedResource(persistenceUnitDescriptor)) continue;
                hasScopedResource = true;
            }
        }
        if (hasScopedResource) {
            this.connectorRuntime.registerDataSourceDefinitions(application);
        }
        PersistenceUnitDescriptorIterator pudIterator = new PersistenceUnitDescriptorIterator(){

            @Override
            void visitPUD(PersistenceUnitDescriptor pud, DeploymentContext context) {
                if (referencedPus.contains(pud)) {
                    boolean isDas = JPADeployer.this.isDas();
                    boolean weavingEnabled = Boolean.valueOf(JPADeployer.this.sc.getArguments().getProperty("org.glassfish.persistence.embedded.weaving.enabled", "true"));
                    ServerProviderContainerContractInfo providerContainerContractInfo = weavingEnabled ? new ServerProviderContainerContractInfo(context, JPADeployer.this.connectorRuntime, isDas) : new EmbeddedProviderContainerContractInfo(context, JPADeployer.this.connectorRuntime, isDas);
                    try {
                        ((ExtendedDeploymentContext)context).prepareScratchDirs();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    PersistenceUnitLoader puLoader = new PersistenceUnitLoader(pud, providerContainerContractInfo);
                    context.addTransientAppMetaData(JPADeployer.getUniquePuIdentifier(pud), puLoader);
                }
            }
        };
        pudIterator.iteratePUDs(context);
    }

    private boolean hasScopedResource(PersistenceUnitDescriptor pud) {
        boolean hasScopedResource = false;
        String jtaDataSource = pud.getJtaDataSource();
        if (jtaDataSource != null && jtaDataSource.startsWith("java:")) {
            hasScopedResource = true;
        }
        return hasScopedResource;
    }

    private boolean isEMFCreationRequired(DeploymentContext context) {
        boolean createEMFs = false;
        DeployCommandParameters deployCommandParameters = context.getCommandParameters(DeployCommandParameters.class);
        boolean deploy = deployCommandParameters.origin.isDeploy();
        boolean enabled = deployCommandParameters.enabled;
        boolean isDas = this.isDas();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("isEMFCreationRequired(): deploy: " + deploy + " enabled: " + enabled + " isDas: " + isDas);
        }
        if (isDas) {
            if (deploy) {
                createEMFs = true;
            } else {
                boolean isTargetDas = JPADeployer.isTargetDas(deployCommandParameters);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("isEMFCreationRequired(): isTargetDas: " + isTargetDas);
                }
                if (enabled && isTargetDas) {
                    createEMFs = true;
                }
            }
        } else if (enabled) {
            createEMFs = true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("isEMFCreationRequired(): returning createEMFs:" + createEMFs);
        }
        return createEMFs;
    }

    private static boolean isTargetDas(DeployCommandParameters deployCommandParameters) {
        return "server".equals(deployCommandParameters.target);
    }

    @Override
    public JPApplicationContainer load(JPAContainer container, DeploymentContext context) {
        return new JPApplicationContainer();
    }

    private static String getUniquePuIdentifier(PersistenceUnitDescriptor pud) {
        return pud.getAbsolutePuRoot() + pud.getName();
    }

    private boolean isDas() {
        return this.serverEnvironment.isDas() || this.serverEnvironment.isEmbedded();
    }

    @Override
    public void postConstruct() {
        this.events.register(this);
    }

    @Override
    public void event(EventListener.Event event) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JpaDeployer.event():" + event.name());
        }
        if (event.is(Deployment.APPLICATION_PREPARED)) {
            ExtendedDeploymentContext context = (ExtendedDeploymentContext)event.hook();
            DeployCommandParameters deployCommandParameters = context.getCommandParameters(DeployCommandParameters.class);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JpaDeployer.event(): Handling APPLICATION_PREPARED origin is:" + (Object)((Object)deployCommandParameters.origin));
            }
            if (!deployCommandParameters.origin.isCreateAppRef() || JPADeployer.isTargetDas(deployCommandParameters)) {
                Map<String, ExtendedDeploymentContext> deploymentContexts = context.getModuleDeploymentContexts();
                for (DeploymentContext deploymentContext : deploymentContexts.values()) {
                    this.iterateInitializedPUsAtApplicationPrepare(deploymentContext);
                }
                this.iterateInitializedPUsAtApplicationPrepare(context);
            }
        } else if (event.is(Deployment.APPLICATION_DISABLED)) {
            logger.fine("JpaDeployer.event(): APPLICATION_DISABLED");
            ApplicationInfo appInfo = (ApplicationInfo)event.hook();
            this.closeEMFs(appInfo);
        }
    }

    private void closeEMFs(ApplicationInfo appInfo) {
        List emfsCreatedForThisApp = appInfo.getTransientAppMetaData(EMF_KEY, List.class);
        if (emfsCreatedForThisApp != null) {
            for (EntityManagerFactory entityManagerFactory : emfsCreatedForThisApp) {
                entityManagerFactory.close();
            }
            emfsCreatedForThisApp.clear();
        }
    }

    private void iterateInitializedPUsAtApplicationPrepare(DeploymentContext context) {
        final DeployCommandParameters deployCommandParameters = context.getCommandParameters(DeployCommandParameters.class);
        String appName = deployCommandParameters.name;
        final ApplicationInfo appInfo = this.applicationRegistry.get(appName);
        PersistenceUnitDescriptorIterator pudIterator = new PersistenceUnitDescriptorIterator(){

            @Override
            void visitPUD(PersistenceUnitDescriptor pud, DeploymentContext context) {
                PersistenceUnitLoader puLoader = context.getTransientAppMetaData(JPADeployer.getUniquePuIdentifier(pud), PersistenceUnitLoader.class);
                if (puLoader != null) {
                    boolean saveEMF = true;
                    if (JPADeployer.this.isDas() && deployCommandParameters.origin.isDeploy()) {
                        EntityManagerFactory emf = puLoader.getEMF();
                        try (EntityManager em = null;){
                            em = emf.createEntityManager();
                        }
                        puLoader.doJava2DB();
                        boolean enabled = deployCommandParameters.enabled;
                        boolean isTargetDas = JPADeployer.isTargetDas(deployCommandParameters);
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("iterateInitializedPUsAtApplicationPrepare(): enabled: " + enabled + " isTargetDas: " + isTargetDas);
                        }
                        if (!isTargetDas || !enabled) {
                            puLoader.getEMF().close();
                            saveEMF = false;
                        }
                    }
                    if (saveEMF) {
                        ArrayList<EntityManagerFactory> emfsCreatedForThisApp = appInfo.getTransientAppMetaData(EMF_KEY, List.class);
                        if (emfsCreatedForThisApp == null) {
                            emfsCreatedForThisApp = new ArrayList<EntityManagerFactory>();
                            appInfo.addTransientAppMetaData(EMF_KEY, emfsCreatedForThisApp);
                        }
                        emfsCreatedForThisApp.add(puLoader.getEMF());
                    }
                }
            }
        };
        pudIterator.iteratePUDs(context);
    }

    private static abstract class PersistenceUnitDescriptorIterator {
        private PersistenceUnitDescriptorIterator() {
        }

        void iteratePUDs(DeploymentContext context) {
            BundleDescriptor currentBundle = DOLUtils.getCurrentBundleForContext(context);
            if (currentBundle != null) {
                Collection<PersistenceUnitsDescriptor> pusDescriptorForThisBundle = currentBundle.getExtensionsDescriptors(PersistenceUnitsDescriptor.class);
                for (PersistenceUnitsDescriptor persistenceUnitsDescriptor : pusDescriptorForThisBundle) {
                    for (PersistenceUnitDescriptor pud : persistenceUnitsDescriptor.getPersistenceUnitDescriptors()) {
                        this.visitPUD(pud, context);
                    }
                }
            }
        }

        abstract void visitPUD(PersistenceUnitDescriptor var1, DeploymentContext var2);
    }
}

