/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.config;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.glassfish.admin.cli.resources.UniqueResourceNameConstraint;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.PropertyDesc;
import org.glassfish.config.support.datatypes.Port;
import org.glassfish.connectors.config.validators.ConnectionPoolErrorMessages;
import org.glassfish.jdbc.config.validators.JdbcConnectionPoolConstraint;
import org.glassfish.jdbc.config.validators.JdbcConnectionPoolConstraints;
import org.glassfish.resourcebase.resources.ResourceDeploymentOrder;
import org.glassfish.resourcebase.resources.ResourceTypeOrder;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
@JdbcConnectionPoolConstraints(value={@JdbcConnectionPoolConstraint(value=ConnectionPoolErrorMessages.MAX_STEADY_INVALID), @JdbcConnectionPoolConstraint(value=ConnectionPoolErrorMessages.STMT_WRAPPING_DISABLED), @JdbcConnectionPoolConstraint(value=ConnectionPoolErrorMessages.RES_TYPE_MANDATORY), @JdbcConnectionPoolConstraint(value=ConnectionPoolErrorMessages.TABLE_NAME_MANDATORY), @JdbcConnectionPoolConstraint(value=ConnectionPoolErrorMessages.CUSTOM_VALIDATION_CLASS_NAME_MANDATORY)})
@RestRedirects(value={@RestRedirect(opType=RestRedirect.OpType.POST, commandName="create-jdbc-connection-pool"), @RestRedirect(opType=RestRedirect.OpType.DELETE, commandName="delete-jdbc-connection-pool")})
@ResourceTypeOrder(deploymentOrder=ResourceDeploymentOrder.JDBC_POOL)
@UniqueResourceNameConstraint(message="{resourcename.isnot.unique}", payload={JdbcConnectionPool.class})
public interface JdbcConnectionPool
extends ConfigBeanProxy,
Resource,
ResourcePool,
PropertyBag {
    @Attribute
    public String getDatasourceClassname();

    public void setDatasourceClassname(String var1) throws PropertyVetoException;

    @Attribute
    public String getDriverClassname();

    public void setDriverClassname(String var1) throws PropertyVetoException;

    @Attribute
    @Pattern(regexp="(java.sql.Driver|javax.sql.DataSource|javax.sql.XADataSource|javax.sql.ConnectionPoolDataSource)")
    public String getResType();

    public void setResType(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="8")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public String getSteadyPoolSize();

    public void setSteadyPoolSize(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="32")
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    public String getMaxPoolSize();

    public void setMaxPoolSize(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="60000")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public String getMaxWaitTimeInMillis();

    public void setMaxWaitTimeInMillis(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="2")
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    public String getPoolResizeQuantity();

    public void setPoolResizeQuantity(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="300")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public String getIdleTimeoutInSeconds();

    public void setIdleTimeoutInSeconds(String var1) throws PropertyVetoException;

    @Attribute
    @Pattern(regexp="(read-uncommitted||read-committed|repeatable-read|serializable)")
    public String getTransactionIsolationLevel();

    public void setTransactionIsolationLevel(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getIsIsolationLevelGuaranteed();

    public void setIsIsolationLevelGuaranteed(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getIsConnectionValidationRequired();

    public void setIsConnectionValidationRequired(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="table")
    @Pattern(regexp="(auto-commit|meta-data|custom-validation|table)")
    public String getConnectionValidationMethod();

    public void setConnectionValidationMethod(String var1) throws PropertyVetoException;

    @Attribute
    public String getValidationTableName();

    public void setValidationTableName(String var1) throws PropertyVetoException;

    @Attribute
    public String getValidationClassname();

    public void setValidationClassname(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getFailAllConnections();

    public void setFailAllConnections(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getNonTransactionalConnections();

    public void setNonTransactionalConnections(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getAllowNonComponentCallers();

    public void setAllowNonComponentCallers(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="0")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public String getValidateAtmostOncePeriodInSeconds();

    public void setValidateAtmostOncePeriodInSeconds(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="0")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public String getConnectionLeakTimeoutInSeconds();

    public void setConnectionLeakTimeoutInSeconds(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getConnectionLeakReclaim();

    public void setConnectionLeakReclaim(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="0")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public String getConnectionCreationRetryAttempts();

    public void setConnectionCreationRetryAttempts(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="10")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public String getConnectionCreationRetryIntervalInSeconds();

    public void setConnectionCreationRetryIntervalInSeconds(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="-1", dataType=Integer.class)
    @Min(value=-1L)
    public String getStatementTimeoutInSeconds();

    public void setStatementTimeoutInSeconds(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getLazyConnectionEnlistment();

    public void setLazyConnectionEnlistment(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getLazyConnectionAssociation();

    public void setLazyConnectionAssociation(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getAssociateWithThread();

    public void setAssociateWithThread(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getPooling();

    public void setPooling(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="0")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public String getStatementCacheSize();

    public void setStatementCacheSize(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="")
    public String getStatementCacheType();

    public void setStatementCacheType(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="0")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public String getStatementLeakTimeoutInSeconds();

    public void setStatementLeakTimeoutInSeconds(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getStatementLeakReclaim();

    public void setStatementLeakReclaim(String var1) throws PropertyVetoException;

    @Attribute
    public String getInitSql();

    public void setInitSql(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getMatchConnections();

    public void setMatchConnections(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="0")
    @Min(value=0L)
    @Max(value=0x7FFFFFFFL)
    public String getMaxConnectionUsageCount();

    public void setMaxConnectionUsageCount(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getWrapJdbcObjects();

    public void setWrapJdbcObjects(String var1) throws PropertyVetoException;

    @Attribute
    public String getSqlTraceListeners();

    public void setSqlTraceListeners(String var1) throws PropertyVetoException;

    @Attribute
    public String getDescription();

    public void setDescription(String var1) throws PropertyVetoException;

    @Override
    @PropertiesDesc(props={@PropertyDesc(name="PortNumber", defaultValue="1527", dataType=Port.class, description="Port on which the database server listens for requests"), @PropertyDesc(name="Password", defaultValue="APP", description="Password for connecting to the database"), @PropertyDesc(name="User", defaultValue="APP", description="User name for connecting to the database"), @PropertyDesc(name="serverName", defaultValue="localhost", description="Database server for this connection pool"), @PropertyDesc(name="DatabaseName", defaultValue="sun-appserv-samples", description="Database for this connection pool."), @PropertyDesc(name="connectionAttributes", defaultValue=";create=true", description="connection attributes")})
    @Element
    public List<Property> getProperty();

    @Override
    @DuckTyped
    public String getIdentity();

    public static class Duck {
        public static String getIdentity(JdbcConnectionPool resource) {
            return resource.getName();
        }
    }
}

