/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli.internal;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-jdbc-driver-class-names")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-jdbc-driver-class-names", description="Get JDBC Driver Class Names")})
public class GetJdbcDriverClassNames
implements AdminCommand {
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Param
    private String dbVendor;
    @Param
    private String resType;
    @Param(defaultValue="true", optional=true)
    private boolean introspect;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Set<String> driverClassNames = this.connectorRuntime.getJdbcDriverClassNames(this.dbVendor, this.resType, this.introspect);
            Properties extraProperties = new Properties();
            extraProperties.put("driverClassNames", new ArrayList<String>(driverClassNames));
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-jdbc-driver-class-names failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

