/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.compression.HeaderListener;
import org.glassfish.grizzly.http2.hpack.BinaryPrimitives;
import org.glassfish.grizzly.http2.hpack.BinaryRepresentation;
import org.glassfish.grizzly.http2.hpack.HeaderFieldTable;

public class SizeUpdate
implements BinaryRepresentation {
    public static final SizeUpdate getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private SizeUpdate() {
    }

    public static boolean matches(byte sig) {
        return (sig & 0xE0) == 32;
    }

    @Override
    public void process(Buffer source, HeaderFieldTable.DecTable table, HeaderListener handler) {
        int size = BinaryPrimitives.readInteger(source, 5);
        table.setMaxSize(size);
    }

    public static void write(int newSize, OutputStream destination) throws IOException {
        BinaryPrimitives.writeInteger(destination, newSize, 5);
    }

    private static class InstanceHolder {
        private static final SizeUpdate INSTANCE = new SizeUpdate();

        private InstanceHolder() {
        }
    }
}

