/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.draft14;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http2.DraftVersion;
import org.glassfish.grizzly.http2.Http2BaseFilter;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2ConnectionException;
import org.glassfish.grizzly.http2.Http2ConnectionOutputSink;
import org.glassfish.grizzly.http2.draft14.Http2ConnectionOutputSink14;
import org.glassfish.grizzly.http2.frames.ContinuationFrame;
import org.glassfish.grizzly.http2.frames.DataFrame;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.GoAwayFrame;
import org.glassfish.grizzly.http2.frames.HeadersFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.frames.PingFrame;
import org.glassfish.grizzly.http2.frames.PriorityFrame;
import org.glassfish.grizzly.http2.frames.PushPromiseFrame;
import org.glassfish.grizzly.http2.frames.RstStreamFrame;
import org.glassfish.grizzly.http2.frames.SettingsFrame;
import org.glassfish.grizzly.http2.frames.WindowUpdateFrame;

public final class Http2Connection14
extends Http2Connection {
    public Http2Connection14(Connection<?> connection, boolean isServer, Http2BaseFilter handlerFilter) {
        super(connection, isServer, handlerFilter);
    }

    @Override
    public DraftVersion getVersion() {
        return DraftVersion.DRAFT_14;
    }

    @Override
    protected Http2ConnectionOutputSink newOutputSink() {
        return new Http2ConnectionOutputSink14(this);
    }

    @Override
    public int getFrameHeaderSize() {
        return 9;
    }

    @Override
    protected int getSpecDefaultFramePayloadSize() {
        return 16384;
    }

    @Override
    protected int getSpecMinFramePayloadSize() {
        return 16384;
    }

    @Override
    protected int getSpecMaxFramePayloadSize() {
        return 0xFFFFFF;
    }

    @Override
    public int getDefaultConnectionWindowSize() {
        return 65535;
    }

    @Override
    public int getDefaultStreamWindowSize() {
        return DraftVersion.DRAFT_14.getDefaultStreamWindowSize();
    }

    @Override
    public int getDefaultMaxConcurrentStreams() {
        return DraftVersion.DRAFT_14.getDefaultMaxConcurrentStreams();
    }

    @Override
    protected boolean isFrameReady(Buffer buffer) {
        int frameLen = this.getFrameSize(buffer);
        return frameLen > 0 && buffer.remaining() >= frameLen;
    }

    @Override
    protected int getFrameSize(Buffer buffer) {
        return buffer.remaining() < 4 ? -1 : (buffer.getInt(buffer.position()) >>> 8) + this.getFrameHeaderSize();
    }

    @Override
    public Http2Frame parseHttp2FrameHeader(Buffer buffer) throws Http2ConnectionException {
        assert (buffer.remaining() == this.getFrameSize(buffer));
        int i1 = buffer.getInt();
        int length = i1 >>> 8 & 0xFFFFFF;
        int type2 = i1 & 0xFF;
        int flags = buffer.get() & 0xFF;
        int streamId = buffer.getInt() & Integer.MAX_VALUE;
        switch (type2) {
            case 0: {
                return DataFrame.fromBuffer(length, flags, streamId, buffer).normalize();
            }
            case 1: {
                return HeadersFrame.fromBuffer(length, flags, streamId, buffer).normalize();
            }
            case 2: {
                return PriorityFrame.fromBuffer(streamId, buffer);
            }
            case 3: {
                return RstStreamFrame.fromBuffer(flags, streamId, buffer);
            }
            case 4: {
                return SettingsFrame.fromBuffer(length, flags, buffer);
            }
            case 5: {
                return PushPromiseFrame.fromBuffer(length, flags, streamId, buffer);
            }
            case 6: {
                return PingFrame.fromBuffer(flags, buffer);
            }
            case 7: {
                return GoAwayFrame.fromBuffer(length, buffer);
            }
            case 8: {
                return WindowUpdateFrame.fromBuffer(flags, streamId, buffer);
            }
            case 9: {
                return ContinuationFrame.fromBuffer(length, flags, streamId, buffer);
            }
        }
        throw new Http2ConnectionException(ErrorCode.PROTOCOL_ERROR, "Unknown frame type: " + type2);
    }

    @Override
    public void serializeHttp2FrameHeader(Http2Frame frame, Buffer buffer) {
        assert (buffer.remaining() >= this.getFrameHeaderSize());
        buffer.putInt((frame.getLength() & 0xFFFFFF) << 8 | frame.getType());
        buffer.put((byte)frame.getFlags());
        buffer.putInt(frame.getStreamId());
    }
}

