/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.Arrays;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http2.AlpnServerNegotiatorImpl;
import org.glassfish.grizzly.http2.AlpnSupport;
import org.glassfish.grizzly.http2.DraftVersion;
import org.glassfish.grizzly.http2.Http2ServerFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.npn.AlpnServerNegotiator;
import org.glassfish.grizzly.ssl.SSLBaseFilter;

public class Http2AddOn
implements AddOn {
    private static final Logger LOGGER = Grizzly.logger(Http2AddOn.class);
    static final DraftVersion[] ALL_HTTP2_DRAFTS = new DraftVersion[]{DraftVersion.DRAFT_14};
    protected final DraftVersion[] supportedDrafts;
    private int maxConcurrentStreams = -1;
    private int initialWindowSize = -1;
    private int maxFramePayloadSize = -1;

    public Http2AddOn() {
        this(ALL_HTTP2_DRAFTS);
    }

    public Http2AddOn(DraftVersion ... supportedDrafts) {
        this.supportedDrafts = supportedDrafts == null || supportedDrafts.length == 0 ? Arrays.copyOf(ALL_HTTP2_DRAFTS, ALL_HTTP2_DRAFTS.length) : Arrays.copyOf(supportedDrafts, supportedDrafts.length);
    }

    @Override
    public void setup(NetworkListener networkListener, FilterChainBuilder builder) {
        TCPNIOTransport transport = networkListener.getTransport();
        if (networkListener.isSecure() && !AlpnSupport.isEnabled()) {
            LOGGER.warning("TLS ALPN (Application-Layer Protocol Negotiation) support is not available. HTTP/2 support will not be enabled.");
            return;
        }
        Http2ServerFilter http2Filter = this.updateFilterChain(builder);
        if (networkListener.isSecure()) {
            this.configureAlpn(transport, http2Filter, builder);
        }
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public int getMaxFramePayloadSize() {
        return this.maxFramePayloadSize;
    }

    public void setMaxFramePayloadSize(int maxFramePayloadSize) {
        this.maxFramePayloadSize = maxFramePayloadSize;
    }

    private Http2ServerFilter updateFilterChain(FilterChainBuilder builder) {
        int codecFilterIdx = builder.indexOfType(HttpServerFilter.class);
        Http2ServerFilter http2HandlerFilter = new Http2ServerFilter(this.supportedDrafts);
        http2HandlerFilter.setLocalMaxFramePayloadSize(this.getMaxFramePayloadSize());
        http2HandlerFilter.setInitialWindowSize(this.getInitialWindowSize());
        http2HandlerFilter.setMaxConcurrentStreams(this.getMaxConcurrentStreams());
        builder.add(codecFilterIdx + 1, http2HandlerFilter);
        return http2HandlerFilter;
    }

    private void configureAlpn(Transport transport, Http2ServerFilter http2Filter, FilterChainBuilder builder) {
        int idx = builder.indexOfType(SSLBaseFilter.class);
        if (idx != -1) {
            SSLBaseFilter sslFilter = (SSLBaseFilter)builder.get(idx);
            AlpnSupport.getInstance().configure(sslFilter);
            AlpnSupport.getInstance().setServerSideNegotiator(transport, (AlpnServerNegotiator)new AlpnServerNegotiatorImpl(this.supportedDrafts, http2Filter));
        }
    }
}

