/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.versioning;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Domain;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningException;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@I18n(value="versioning.service")
@Service
@PerLookup
public class VersioningService {
    @Inject
    private CommandRunner commandRunner;
    @Inject
    private Domain domain;

    private final List<String> getAllversions(String untaggedName, String target) {
        List<Application> allApplications = null;
        allApplications = target != null ? this.domain.getApplicationsInTarget(target) : this.domain.getApplications().getApplications();
        return VersioningUtils.getVersions(untaggedName, allApplications);
    }

    public Map<String, Set<String>> getEnabledVersionInReferencedTargetsForExpression(String versionExpression) throws VersioningSyntaxException {
        Map<String, Set<String>> enabledVersionsInTargets = Collections.EMPTY_MAP;
        List<String> matchedVersions = this.getMatchedVersions(versionExpression, "domain");
        for (String matchedVersion : matchedVersions) {
            Map<String, Set<String>> tempMap = this.getEnabledVersionsInReferencedTargets(matchedVersion);
            if (enabledVersionsInTargets != Collections.EMPTY_MAP) {
                for (Map.Entry<String, Set<String>> entry : tempMap.entrySet()) {
                    String tempKey = entry.getKey();
                    Set<String> tempList = entry.getValue();
                    if (enabledVersionsInTargets.containsKey(tempKey)) {
                        enabledVersionsInTargets.get(tempKey).addAll(tempList);
                        continue;
                    }
                    enabledVersionsInTargets.put(tempKey, tempList);
                }
                continue;
            }
            enabledVersionsInTargets = tempMap;
        }
        return enabledVersionsInTargets;
    }

    public Map<String, Set<String>> getEnabledVersionsInReferencedTargets(String versionIdentifier) throws VersioningSyntaxException {
        HashMap<String, Set<String>> enabledVersionsInTargets = new HashMap<String, Set<String>>();
        List<String> allTargets = this.domain.getAllReferencedTargetsForApplication(versionIdentifier);
        for (String target : allTargets) {
            String enabledVersion = this.getEnabledVersion(versionIdentifier, target);
            if (enabledVersion == null) continue;
            if (enabledVersionsInTargets.containsKey(enabledVersion)) {
                ((Set)enabledVersionsInTargets.get(enabledVersion)).add(target);
                continue;
            }
            HashSet<String> setTargets = new HashSet<String>();
            setTargets.add(target);
            enabledVersionsInTargets.put(enabledVersion, setTargets);
        }
        return enabledVersionsInTargets;
    }

    public final String getEnabledVersion(String name, String target) throws VersioningSyntaxException {
        String untaggedName = VersioningUtils.getUntaggedName(name);
        List<String> allVersions = this.getAllversions(untaggedName, target);
        if (allVersions != null) {
            for (String app : allVersions) {
                if (!this.domain.isAppEnabledInTarget(app, target)) continue;
                return app;
            }
        }
        return null;
    }

    public final List<String> getMatchedVersions(String name, String target) throws VersioningSyntaxException, VersioningException {
        String untagged = VersioningUtils.getUntaggedName(name);
        List<String> allVersions = this.getAllversions(untagged, target);
        if (allVersions.size() == 0) {
            if (!name.equals(untagged)) {
                throw new VersioningException(VersioningUtils.LOCALSTRINGS.getLocalString("versioning.deployment.application.noversion", "Application {0} has no version registered", untagged));
            }
            return Collections.EMPTY_LIST;
        }
        return VersioningUtils.matchExpression(allVersions, name);
    }

    public void handleDisable(String appName, String target, ActionReport report, Subject subject) throws VersioningSyntaxException {
        Set<String> versionsToDisable = Collections.EMPTY_SET;
        if (DeploymentUtils.isDomainTarget(target)) {
            Map<String, Set<String>> enabledVersions = this.getEnabledVersionsInReferencedTargets(appName);
            if (!enabledVersions.isEmpty()) {
                versionsToDisable = enabledVersions.keySet();
            }
        } else {
            String enabledVersion = this.getEnabledVersion(appName, target);
            if (enabledVersion != null && !enabledVersion.equals(appName)) {
                versionsToDisable = new HashSet<String>();
                versionsToDisable.add(enabledVersion);
            }
        }
        for (String currentVersion : versionsToDisable) {
            if (currentVersion == null || currentVersion.equals(appName)) continue;
            ParameterMap parameters = new ParameterMap();
            parameters.add("DEFAULT", currentVersion);
            parameters.add("target", target);
            ActionReport subReport = report.addSubActionsReport();
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("disable", subReport, subject);
            inv.parameters(parameters).execute();
        }
    }

    public String getVersionFromSameDir(File dir) throws VersioningSyntaxException {
        try {
            Iterator<Application> it = this.domain.getApplications().getApplications().iterator();
            Application app = null;
            while (it.hasNext()) {
                app = it.next();
                if (!dir.toURI().toString().equals(app.getLocation()) || VersioningUtils.getUntaggedName(app.getName()).equals(app.getName())) continue;
                return app.getName();
            }
        }
        catch (VersioningSyntaxException versioningSyntaxException) {
            // empty catch block
        }
        return null;
    }
}

